/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.search.strings.fuzzySearch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import us.ihmc.tools.search.strings.fuzzySearch.CombinedFuzzySearchResult;
import us.ihmc.tools.search.strings.fuzzySearch.comparators.SortByMatchedStringComparator;
import us.ihmc.tools.search.strings.fuzzySearch.comparators.SortByResultTypeComparator;
import us.ihmc.tools.search.strings.fuzzySearch.comparators.SortFuzzyMatchesDescendingByFuzzyDistanceComparator;

public class CombinedFuzzySearcher {
    private CombinedFuzzySearcher() {
    }

    public static List<CombinedFuzzySearchResult> getAllSearchResultsForSearchString(Collection<String> stringsToSearch, String searchString) {
        Set<CombinedFuzzySearchResult> resultsOfFuzzyDistanceSearch = CombinedFuzzySearcher.performFuzzyStringSearch(searchString, stringsToSearch);
        Set<CombinedFuzzySearchResult> resultsOfRegexSearch = CombinedFuzzySearcher.performRegularExpressionSearch(searchString, stringsToSearch);
        Set<CombinedFuzzySearchResult> resultsOfExactSubstringSearch = CombinedFuzzySearcher.performExactSubstringSearch(searchString, stringsToSearch);
        TreeSet<CombinedFuzzySearchResult> accumulator = new TreeSet<CombinedFuzzySearchResult>(new SortByMatchedStringComparator());
        accumulator.addAll(resultsOfExactSubstringSearch);
        accumulator.addAll(resultsOfRegexSearch);
        ArrayList<CombinedFuzzySearchResult> allSearchResults = new ArrayList<CombinedFuzzySearchResult>(accumulator);
        Collections.sort(allSearchResults, new SortByResultTypeComparator());
        ArrayList<CombinedFuzzySearchResult> sortedFuzzyResults = new ArrayList<CombinedFuzzySearchResult>();
        for (CombinedFuzzySearchResult combinedFuzzySearchResult : resultsOfFuzzyDistanceSearch) {
            if (accumulator.contains(combinedFuzzySearchResult)) continue;
            sortedFuzzyResults.add(combinedFuzzySearchResult);
        }
        Collections.sort(sortedFuzzyResults, new SortFuzzyMatchesDescendingByFuzzyDistanceComparator());
        return allSearchResults;
    }

    private static Set<CombinedFuzzySearchResult> performFuzzyStringSearch(String searchString, Collection<String> stringsToSearch) {
        HashSet<CombinedFuzzySearchResult> resultsOfFuzzyDistanceSearch = new HashSet<CombinedFuzzySearchResult>();
        for (String stringToSearch : stringsToSearch) {
            int fuzzyDistance = StringUtils.getFuzzyDistance((CharSequence)stringToSearch, (CharSequence)searchString, (Locale)Locale.ENGLISH);
            if (fuzzyDistance <= 0) continue;
            resultsOfFuzzyDistanceSearch.add(new CombinedFuzzySearchResult(stringToSearch, CombinedFuzzySearchResult.CombinedFuzzySearchResultType.FUZZY, fuzzyDistance, searchString.split("")));
        }
        TreeSet<CombinedFuzzySearchResult> sortedResults = new TreeSet<CombinedFuzzySearchResult>(new SortFuzzyMatchesDescendingByFuzzyDistanceComparator());
        sortedResults.addAll(resultsOfFuzzyDistanceSearch);
        return sortedResults;
    }

    private static Set<CombinedFuzzySearchResult> performRegularExpressionSearch(String searchString, Collection<String> stringsToSearch) {
        HashSet<CombinedFuzzySearchResult> resultsOfRegexSearch = new HashSet();
        try {
            Object wildCardBoundedRegexSearchString = "";
            if (!searchString.startsWith("^")) {
                wildCardBoundedRegexSearchString = (String)wildCardBoundedRegexSearchString + "(?<startGroup>.*)";
            }
            wildCardBoundedRegexSearchString = (String)wildCardBoundedRegexSearchString + searchString;
            if (!searchString.endsWith("$")) {
                wildCardBoundedRegexSearchString = (String)wildCardBoundedRegexSearchString + "(?<endGroup>.*)";
            }
            boolean hasStartGroup = !((String)wildCardBoundedRegexSearchString).startsWith("^");
            boolean hasEndGroup = !((String)wildCardBoundedRegexSearchString).endsWith("$");
            Pattern simpleRegexPattern = Pattern.compile((String)wildCardBoundedRegexSearchString, 2);
            for (String stringToSearch : stringsToSearch) {
                if (!simpleRegexPattern.matcher(stringToSearch).matches()) continue;
                resultsOfRegexSearch.add(CombinedFuzzySearcher.getSearchResultFromRegex(hasStartGroup, hasEndGroup, simpleRegexPattern, stringToSearch));
            }
        }
        catch (PatternSyntaxException ignored) {
            resultsOfRegexSearch = Collections.emptySet();
        }
        return resultsOfRegexSearch;
    }

    private static Set<CombinedFuzzySearchResult> performExactSubstringSearch(String searchString, Collection<String> stringsToSearch) {
        HashSet<CombinedFuzzySearchResult> resultsOfExactSubstringSearch = new HashSet<CombinedFuzzySearchResult>();
        for (String stringToSearch : stringsToSearch) {
            if (!searchString.contains(searchString)) continue;
            resultsOfExactSubstringSearch.add(new CombinedFuzzySearchResult(stringToSearch, CombinedFuzzySearchResult.CombinedFuzzySearchResultType.EXACT_SUBSTRING, searchString));
        }
        return resultsOfExactSubstringSearch;
    }

    private static CombinedFuzzySearchResult getSearchResultFromRegex(boolean hasStartGroup, boolean hasEndGroup, Pattern simpleRegexPattern, String stringToSearch) {
        ArrayList<String> matches = new ArrayList<String>();
        Matcher matcher = simpleRegexPattern.matcher(stringToSearch);
        while (matcher.find()) {
            String endGroup;
            String startGroup;
            String group = matcher.group();
            if (hasStartGroup && group.startsWith(startGroup = matcher.group("startGroup"))) {
                group = group.replace(startGroup, "");
            }
            if (hasEndGroup && group.endsWith(endGroup = matcher.group("endGroup"))) {
                group = group.replace(endGroup, "");
            }
            matches.add(group);
        }
        return new CombinedFuzzySearchResult(stringToSearch, CombinedFuzzySearchResult.CombinedFuzzySearchResultType.REGEX, matches.toArray(new String[matches.size()]));
    }
}

