/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io;

import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Supplier;
import us.ihmc.tools.io.WorkspaceDirectory;

public class WorkspaceFile {
    private final Supplier<InputStream> getResourceAsStream;
    private final Supplier<URL> getResource;
    private final Path workspaceFile;
    private final String pathForResourceLoadingPathFiltered;

    public WorkspaceFile(WorkspaceDirectory directory, String subsequentPathToFile) {
        String pathForResourceLoading = Paths.get(directory.getPathNecessaryForClasspathLoading(), new String[0]).resolve(subsequentPathToFile).toString();
        this.pathForResourceLoadingPathFiltered = pathForResourceLoading.replaceAll("\\\\", "/");
        if (directory.getClassForLoading() == null) {
            this.getResourceAsStream = () -> ClassLoader.getSystemResourceAsStream(this.pathForResourceLoadingPathFiltered);
            this.getResource = () -> ClassLoader.getSystemResource(this.pathForResourceLoadingPathFiltered);
        } else {
            this.getResourceAsStream = () -> directory.getClassForLoading().getResourceAsStream(this.pathForResourceLoadingPathFiltered);
            this.getResource = () -> directory.getClassForLoading().getResource(this.pathForResourceLoadingPathFiltered);
        }
        Path directoryPath = directory.getDirectoryPath();
        this.workspaceFile = directoryPath != null ? directoryPath.resolve(subsequentPathToFile) : null;
    }

    public boolean isFileAccessAvailable() {
        return this.workspaceFile != null;
    }

    public InputStream getClasspathResourceAsStream() {
        return this.getResourceAsStream.get();
    }

    public URL getClasspathResource() {
        return this.getResource.get();
    }

    public String getFileName() {
        return this.pathForResourceLoadingPathFiltered.substring(this.pathForResourceLoadingPathFiltered.lastIndexOf("/"));
    }

    public Path getFilePath() {
        return this.workspaceFile;
    }

    public String getPathForResourceLoadingPathFiltered() {
        return this.pathForResourceLoadingPathFiltered;
    }
}

