/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.factories;

import java.lang.reflect.Field;
import us.ihmc.tools.factories.FactoryField;
import us.ihmc.tools.factories.OptionalFactoryField;
import us.ihmc.tools.factories.RequiredFactoryField;

public class FactoryTools {
    public static void checkAllFactoryFieldsAreSet(Object factory) {
        for (Field field : factory.getClass().getDeclaredFields()) {
            if (!FactoryField.class.isAssignableFrom(field.getType())) continue;
            try {
                field.setAccessible(true);
                if (OptionalFactoryField.class.isAssignableFrom(field.getType())) {
                    OptionalFactoryField optionalFactoryField = (OptionalFactoryField)field.get(factory);
                    if (!optionalFactoryField.hasValue()) continue;
                    optionalFactoryField.get();
                    continue;
                }
                RequiredFactoryField requiredFactoryField = (RequiredFactoryField)field.get(factory);
                requiredFactoryField.get();
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    public static void disposeFactory(Object factory) {
        for (Field field : factory.getClass().getDeclaredFields()) {
            if (!FactoryField.class.isAssignableFrom(field.getType())) continue;
            FactoryField factoryField = null;
            try {
                field.setAccessible(true);
                factoryField = (FactoryField)field.get(factory);
                factoryField.dispose();
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }
}

