/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.containers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.TreeSet;

public class ContainerTools {
    private ContainerTools() {
    }

    public static <K extends Enum<K>, V> EnumMap<K, V> createEnumMap(Class<K> keyType) {
        return new EnumMap(keyType);
    }

    public static <E> TreeSet<E> findLargestElements(Collection<? extends E> collection, Comparator<? super E> comparator, int n) {
        TreeSet<E> ret = new TreeSet<E>(comparator);
        for (E element : collection) {
            if (ret.size() < n) {
                ret.add(element);
                continue;
            }
            E currentLowest = ret.first();
            if (ret.comparator().compare(element, currentLowest) <= 0) continue;
            ret.remove(currentLowest);
            ret.add(element);
        }
        return ret;
    }

    public static <K1 extends Enum<K1>, K2 extends Enum<K2>, V> ArrayList<V> flatten(EnumMap<K1, EnumMap<K2, V>> mapOfMaps) {
        ArrayList<V> ret = new ArrayList<V>();
        for (EnumMap<K2, V> map : mapOfMaps.values()) {
            for (V value : map.values()) {
                ret.add(value);
            }
        }
        return ret;
    }

    public static <K1 extends Enum<K1>, K2 extends Enum<K2>> double[][] toArrayOfArrays(EnumMap<K1, EnumMap<K2, Double>> mapOfMaps) {
        int size1 = mapOfMaps.keySet().size();
        double[][] ret = new double[size1][];
        for (Enum key1 : mapOfMaps.keySet()) {
            EnumMap<K2, Double> map = mapOfMaps.get(key1);
            int size2 = map.keySet().size();
            ret[key1.ordinal()] = new double[size2];
            for (Enum key2 : map.keySet()) {
                ret[key1.ordinal()][key2.ordinal()] = mapOfMaps.get(key1).get(key2);
            }
        }
        return ret;
    }

    public static <T extends Comparable<? super T>> List<T> asSortedList(Collection<T> c) {
        ArrayList<T> list = new ArrayList<T>(c);
        Collections.sort(list);
        return list;
    }

    public static <T> boolean removeByReference(List<T> list, T o) {
        if (o == null) {
            list.remove(o);
        } else {
            for (int index = 0; index < list.size(); ++index) {
                if (o != list.get(index)) continue;
                list.remove(index);
                return true;
            }
        }
        return false;
    }
}

