/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.log.LogTools;
import us.ihmc.tools.io.HybridDirectory;
import us.ihmc.tools.io.HybridResourceMode;
import us.ihmc.tools.io.WorkspaceFile;

public class HybridFile {
    private final WorkspaceFile workspaceFile;
    private final Path externalFile;
    private HybridResourceMode mode = HybridResourceMode.WORKSPACE;

    public HybridFile(HybridDirectory directory, String subsequentPathToFile) {
        this.workspaceFile = new WorkspaceFile(directory.getInternalWorkspaceDirectory(), subsequentPathToFile);
        this.externalFile = directory.getExternalDirectory().resolve(subsequentPathToFile);
    }

    public boolean isWorkspaceFileAccessAvailable() {
        return this.workspaceFile.isFileAccessAvailable();
    }

    public void setMode(HybridResourceMode mode) {
        this.mode = mode;
    }

    public HybridResourceMode getMode() {
        return this.mode;
    }

    public Path getFileForWriting() {
        return this.mode == HybridResourceMode.WORKSPACE ? this.workspaceFile.getFilePath() : this.externalFile;
    }

    public boolean getInputStream(Consumer<InputStream> inputStreamGetter) {
        boolean success = false;
        try (InputStream inputStream = this.getInputStreamUnsafe();){
            if (inputStream != null) {
                inputStreamGetter.accept(inputStream);
                success = true;
            } else {
                LogTools.error((int)1, (Object)"Input stream is null");
            }
        }
        catch (IOException ioException) {
            DefaultExceptionHandler.MESSAGE_AND_STACKTRACE.handleException((Throwable)ioException);
        }
        return success;
    }

    private InputStream getInputStreamUnsafe() {
        return this.mode == HybridResourceMode.WORKSPACE ? this.getClasspathResourceAsStream() : (InputStream)ExceptionTools.handle(() -> new FileInputStream(this.externalFile.toFile()), (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
    }

    public boolean isInputStreamAvailable() {
        boolean isInputStreamAvailable = this.mode == HybridResourceMode.WORKSPACE ? this.workspaceFile.getClasspathResource() != null : Files.exists(this.externalFile, new LinkOption[0]);
        return isInputStreamAvailable;
    }

    public boolean isWritingAvailable() {
        boolean isWritingAvailable = this.mode == HybridResourceMode.WORKSPACE ? this.isWorkspaceFileAccessAvailable() : true;
        return isWritingAvailable;
    }

    public String getLocationOfResourceForReading() {
        if (this.mode == HybridResourceMode.WORKSPACE) {
            return "Resource: " + this.getPathForResourceLoadingPathFiltered();
        }
        return "File: " + this.externalFile.toString();
    }

    public InputStream getClasspathResourceAsStream() {
        return this.workspaceFile.getClasspathResourceAsStream();
    }

    public URL getClasspathResource() {
        return this.workspaceFile.getClasspathResource();
    }

    public Path getExternalFile() {
        return this.externalFile;
    }

    public Path getWorkspaceFile() {
        return this.workspaceFile.getFilePath();
    }

    public String getPathForResourceLoadingPathFiltered() {
        return this.workspaceFile.getPathForResourceLoadingPathFiltered();
    }
}

