/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.inputDevices.joystick;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;
import us.ihmc.commons.PrintTools;
import us.ihmc.tools.inputDevices.joystick.JoystickCompatibilityFilter;
import us.ihmc.tools.inputDevices.joystick.mapping.LogitechExtreme3DMapping;
import us.ihmc.tools.inputDevices.joystick.mapping.MadCatzFLY5StickMapping;
import us.ihmc.tools.inputDevices.joystick.mapping.MadCatzV1StickMapping;
import us.ihmc.tools.inputDevices.joystick.mapping.SaitekX52Mapping;
import us.ihmc.tools.inputDevices.joystick.mapping.Thrustmaster16000M;
import us.ihmc.tools.inputDevices.joystick.mapping.XBoxOneMapping;

public enum JoystickModel {
    LOGITECH_EXTREME_3D("Logitech Extreme 3D", LogitechExtreme3DMapping.getCompatibilityFilters()),
    MAD_CATZ_V1_STICK("Mad Catz V.1 Stick", MadCatzV1StickMapping.getCompatibilityFilters()),
    MAD_CATZ_FLY5_STICK("Mad Catz F.L.Y.5 Stick", MadCatzFLY5StickMapping.getCompatibilityFilters()),
    SAITEK_X52("Saitek X52 Flight Control System", SaitekX52Mapping.getCompatibilityFilters()),
    THRUSTMASTER_16000M("T.16000M", Thrustmaster16000M.getCompatibilityFilters()),
    XBOX_ONE("Xbox One For Windows", "Xbox One Wired Controller", "Microsoft X-Box One pad", XBoxOneMapping.getCompatibilityFilters()),
    XBOX_ONE_S("Xbox Wireless Controller", "Xbox Wireless Controller", "Xbox Wireless Controller", XBoxOneMapping.getCompatibilityFilters()),
    UNKNOWN("Unknown", new ArrayList<JoystickCompatibilityFilter>());

    public static final JoystickModel[] values;
    private final String jinputName;
    private final List<JoystickCompatibilityFilter> compatibilityFilters;

    private JoystickModel(String jinputName, List<JoystickCompatibilityFilter> compatibilityFilters) {
        this.jinputName = jinputName;
        this.compatibilityFilters = compatibilityFilters;
    }

    private JoystickModel(String jinputWindowsName, String jinputMacName, String jinputLinuxName, List<JoystickCompatibilityFilter> compatibilityFilters) {
        this.jinputName = SystemUtils.IS_OS_WINDOWS ? jinputWindowsName : (SystemUtils.IS_OS_MAC ? jinputMacName : (SystemUtils.IS_OS_LINUX ? jinputLinuxName : null));
        this.compatibilityFilters = compatibilityFilters;
    }

    public String getJinputName() {
        return this.jinputName;
    }

    public static JoystickModel getModelFromName(String name) {
        for (JoystickModel joystickModel : values) {
            if (!name.toLowerCase().contains(joystickModel.getJinputName().toLowerCase())) continue;
            return joystickModel;
        }
        PrintTools.warn((String)("Unknown joystick name: " + name));
        return UNKNOWN;
    }

    public List<JoystickCompatibilityFilter> getCompatibilityFilters() {
        return this.compatibilityFilters;
    }

    static {
        values = JoystickModel.values();
    }
}

