/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.thread;

import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.log.LogTools;

public class ExecutorServiceTools {
    public static ScheduledExecutorService newSingleThreadScheduledExecutor(Class<?> creator, ExceptionHandling exceptionHandling) {
        return ExecutorServiceTools.newSingleThreadScheduledExecutor(ThreadTools.createNamedThreadFactory((String)creator.getSimpleName()), exceptionHandling);
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(ThreadFactory threadFactory, ExceptionHandling exceptionHandling) {
        return ExecutorServiceTools.newScheduledThreadPool(1, threadFactory, exceptionHandling);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, Class<?> creator, ExceptionHandling exceptionHandling) {
        return ExecutorServiceTools.newScheduledThreadPool(corePoolSize, ThreadTools.createNamedThreadFactory((String)creator.getSimpleName()), exceptionHandling);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, ThreadFactory threadFactory, final ExceptionHandling exceptionHandling) {
        return new ScheduledThreadPoolExecutor(corePoolSize, threadFactory){

            @Override
            public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
                return super.schedule(ExecutorServiceTools.wrapWithTryAndCatch(command, exceptionHandling), delay, unit);
            }

            @Override
            public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
                return super.schedule(ExecutorServiceTools.wrapWithTryAndCatch(callable, exceptionHandling), delay, unit);
            }

            @Override
            public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
                return super.scheduleAtFixedRate(ExecutorServiceTools.wrapWithTryAndCatch(command, exceptionHandling), initialDelay, period, unit);
            }

            @Override
            public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
                return super.scheduleWithFixedDelay(ExecutorServiceTools.wrapWithTryAndCatch(command, exceptionHandling), initialDelay, delay, unit);
            }
        };
    }

    private static <V> Callable<V> wrapWithTryAndCatch(final Callable<V> callable, final ExceptionHandling exceptionHandling) {
        return new Callable<V>(){

            @Override
            public V call() throws Exception {
                try {
                    return callable.call();
                }
                catch (Exception e) {
                    if (exceptionHandling.shouldReportExceptions()) {
                        e.printStackTrace();
                    }
                    if (!exceptionHandling.isCatchExceptionsEnabled()) {
                        LogTools.warn((String)"Current task is cancelled.");
                        throw e;
                    }
                    return null;
                }
            }
        };
    }

    private static Runnable wrapWithTryAndCatch(final Runnable command, final ExceptionHandling exceptionHandling) {
        return new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        command.run();
                    }
                    catch (Exception e) {
                        if (exceptionHandling.shouldReportExceptions()) {
                            e.printStackTrace();
                        }
                        if (exceptionHandling.isCatchExceptionsEnabled()) break block3;
                        LogTools.warn((String)"Current task is cancelled.");
                        throw e;
                    }
                }
            }
        };
    }

    public static enum ExceptionHandling {
        NONE(false, false),
        CANCEL_AND_REPORT(false, true),
        CATCH(true, false),
        CATCH_AND_REPORT(true, true);

        private final boolean catchExceptions;
        private final boolean reportExceptions;

        private ExceptionHandling(boolean catchExceptions, boolean reportExceptions) {
            this.catchExceptions = catchExceptions;
            this.reportExceptions = reportExceptions;
        }

        private boolean isCatchExceptionsEnabled() {
            return this.catchExceptions;
        }

        private boolean shouldReportExceptions() {
            return this.reportExceptions;
        }
    }
}

