/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io.files;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;

public class DeprecatedFileTools {
    public static BufferedReader getFileReader(String filename) throws FileNotFoundException {
        return new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
    }

    public static PrintWriter getFileWriter(String filename) throws FileNotFoundException, IOException {
        return new PrintWriter(new BufferedWriter(new FileWriter(filename)));
    }

    public static PrintWriter getFileWriterWithAppend(String filename) throws FileNotFoundException, IOException {
        return new PrintWriter(new BufferedWriter(new FileWriter(filename, true)));
    }

    public static DataOutputStream getFileDataOutputStream(String filename) throws FileNotFoundException, IOException {
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(filename)));
    }

    public static DataInputStream getFileDataInputStream(String filename) throws FileNotFoundException, IOException {
        return new DataInputStream(new BufferedInputStream(new FileInputStream(filename)));
    }

    public static ArrayList<File> getAllFilesInDirectoryRecursive(File directory) {
        return DeprecatedFileTools.getAllFilesInDirectoryRecursiveRegex(".*", directory);
    }

    public static ArrayList<File> getAllFilesInDirectoryRecursiveRegex(String regex, File directory) {
        File[] contents;
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(directory.getAbsolutePath() + " is not a directory");
        }
        ArrayList<File> ret = new ArrayList<File>();
        for (File file : contents = directory.listFiles()) {
            if (file.isHidden()) continue;
            if (file.isDirectory()) {
                ret.addAll(DeprecatedFileTools.getAllFilesInDirectoryRecursiveRegex(regex, file));
                continue;
            }
            if (!file.getName().matches(regex)) continue;
            ret.add(file);
        }
        return ret;
    }

    public static ArrayList<File> getAllFilesInDirectoryWithSuffix(String suffix, File directory) {
        if (directory.getName().equals("")) {
            directory = new File(".");
        }
        if (!directory.isDirectory()) {
            throw new RuntimeException("This method can only be called with a directory: " + directory.toString());
        }
        ArrayList<File> allValidFiles = new ArrayList<File>();
        File[] allFiles = directory.listFiles();
        if (allFiles == null || allFiles.length <= 0) {
            return allValidFiles;
        }
        for (File file : allFiles) {
            if (!file.getName().endsWith(suffix) || file.isDirectory()) continue;
            allValidFiles.add(file);
        }
        return allValidFiles;
    }
}

