/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io;

import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;

public class AudioTools {
    public static void playFirstNotRunningClip(Clip[] clips) {
        for (int i = 0; i < clips.length; ++i) {
            if (clips[i].isRunning()) continue;
            clips[i].setFramePosition(0);
            clips[i].start();
            return;
        }
    }

    public static void playSoundOnce(Clip clip) {
        if (clip == null || clip.isRunning()) {
            return;
        }
        clip.setFramePosition(0);
        clip.start();
    }

    public static Clip loadSoundClip(InputStream is) {
        try {
            AudioInputStream stream = AudioSystem.getAudioInputStream(is);
            AudioFormat format = stream.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, format);
            Clip clip = (Clip)AudioSystem.getLine(info);
            clip.open(stream);
            return clip;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Clip loadSoundClip(URL url) {
        try {
            AudioInputStream stream = AudioSystem.getAudioInputStream(url);
            AudioFormat format = stream.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, format);
            Clip clip = (Clip)AudioSystem.getLine(info);
            clip.open(stream);
            return clip;
        }
        catch (LineUnavailableException e) {
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

