/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.inputDevices.mouse3DJoystick;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import us.ihmc.commons.PrintTools;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.graphicsDescription.input.mouse.Mouse3DInterface;
import us.ihmc.graphicsDescription.input.mouse.Mouse3DListener;
import us.ihmc.graphicsDescription.input.mouse.Mouse3DListenerHolder;
import us.ihmc.tools.inputDevices.JInputTools;

public class Mouse3DJoystick
implements Mouse3DInterface {
    private final long POLL_PERIOD_MILLISECONDS = 10L;
    private final double POLL_PERIOD_SECONDS = 0.01;
    public final double DEAD_ZONE = 0.001;
    public final Map<String, Double> controllerScales = new HashMap<String, Double>();
    public final double MAX_VALUE = 1.0;
    public final double MIN_VALUE = -1.0;
    private final double X_SIGN = 1.0;
    private final double Y_SIGN = -1.0;
    private final double Z_SIGN = -1.0;
    private final double RX_SIGN = 1.0;
    private final double RY_SIGN = 1.0;
    private final double RZ_SIGN = -1.0;
    private Mouse3DListenerHolder mouse3DListenerHolder = new Mouse3DListenerHolder();
    private Controller controller;
    private double scale;
    private ScheduledExecutorService scheduledExecutorService;
    private Stopwatch timer = new Stopwatch();

    public Mouse3DJoystick() {
        this.controllerScales.put("Space Navigator", 0.002857142857142857);
        this.controllerScales.put("SpaceMouse Wireless Receiver", 1.0);
        this.controllerScales.put("SpaceMouse Pro", 1.0);
        this.controllerScales.put("SpaceM", 1.0);
        Map<JInputTools.ControllerType, Controller> controllersByType = JInputTools.getControllersByType();
        if (controllersByType.containsKey((Object)JInputTools.ControllerType.JOYSTICK_3D)) {
            this.controller = controllersByType.get((Object)JInputTools.ControllerType.JOYSTICK_3D);
            PrintTools.info((Object)this, (String)("Using Mouse3DJoystick: " + this.controller.getName()));
            this.scale = this.controllerScales.get(this.controller.getName());
            this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(ThreadTools.getNamedThreadFactory((String)this.getClass().getSimpleName()));
            this.scheduledExecutorService.scheduleAtFixedRate(new Mouse3DJoystickPollService(), 0L, 10L, TimeUnit.MILLISECONDS);
        }
    }

    public void addMouse3DListener(Mouse3DListener mouse3DListener) {
        this.mouse3DListenerHolder.addMouse3DListener(mouse3DListener);
    }

    public void stopPolling() {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
        }
    }

    private class Mouse3DJoystickPollService
    implements Runnable {
        private boolean timerStarted = false;

        private Mouse3DJoystickPollService() {
        }

        @Override
        public void run() {
            if (!this.timerStarted) {
                Mouse3DJoystick.this.timer.start();
                this.timerStarted = true;
                return;
            }
            Mouse3DJoystick.this.controller.poll();
            double lap = Mouse3DJoystick.this.timer.lap();
            double timeScale = lap / 0.01;
            double dx = 1.0 * (double)Mouse3DJoystick.this.controller.getComponent((Component.Identifier)Component.Identifier.Axis.X).getPollData() * Mouse3DJoystick.this.scale * timeScale;
            double dy = -1.0 * (double)Mouse3DJoystick.this.controller.getComponent((Component.Identifier)Component.Identifier.Axis.Y).getPollData() * Mouse3DJoystick.this.scale * timeScale;
            double dz = -1.0 * (double)Mouse3DJoystick.this.controller.getComponent((Component.Identifier)Component.Identifier.Axis.Z).getPollData() * Mouse3DJoystick.this.scale * timeScale;
            double drx = 1.0 * (double)Mouse3DJoystick.this.controller.getComponent((Component.Identifier)Component.Identifier.Axis.RX).getPollData() * Mouse3DJoystick.this.scale * timeScale;
            double dry = 1.0 * (double)Mouse3DJoystick.this.controller.getComponent((Component.Identifier)Component.Identifier.Axis.RY).getPollData() * Mouse3DJoystick.this.scale * timeScale;
            double drz = -1.0 * (double)Mouse3DJoystick.this.controller.getComponent((Component.Identifier)Component.Identifier.Axis.RZ).getPollData() * Mouse3DJoystick.this.scale * timeScale;
            if (Math.abs(dx) < 0.001) {
                dx = 0.0;
            }
            if (Math.abs(dy) < 0.001) {
                dy = 0.0;
            }
            if (Math.abs(dz) < 0.001) {
                dz = 0.0;
            }
            if (Math.abs(drx) < 0.001) {
                drx = 0.0;
            }
            if (Math.abs(dry) < 0.001) {
                dry = 0.0;
            }
            if (Math.abs(drz) < 0.001) {
                drz = 0.0;
            }
            if (dx != 0.0 || dy != 0.0 || dz != 0.0 || drx != 0.0 || dry != 0.0 || drz != 0.0) {
                Mouse3DJoystick.this.mouse3DListenerHolder.mouseDragged(dx, dy, dz, drx, dry, drz);
            }
        }
    }
}

