/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.inputDevices.joystick.mapping;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.List;
import net.java.games.input.Component;
import net.java.games.input.Event;
import org.apache.commons.lang3.SystemUtils;
import us.ihmc.tools.inputDevices.joystick.JoystickCompatibilityFilter;
import us.ihmc.tools.inputDevices.joystick.mapping.JoystickMapping;

public enum MadCatzV1StickMapping implements JoystickMapping
{
    TRIGGER,
    THROTTLE,
    HAT,
    STICK_ROLL,
    STICK_PITCH,
    STICK_YAW,
    BUTTON_2,
    BUTTON_3,
    BUTTON_4,
    BUTTON_5,
    BUTTON_6,
    PINKY_TRIGGER;

    public static final MadCatzV1StickMapping[] values;
    private static final BiMap<Component.Identifier, MadCatzV1StickMapping> windowsBiMap;
    private static final BiMap<Component.Identifier, MadCatzV1StickMapping> macBiMap;
    private static final BiMap<Component.Identifier, MadCatzV1StickMapping> linuxBiMap;

    private static void mapValues(MadCatzV1StickMapping mapping, Component.Identifier windowsIdentifier, Component.Identifier macIdentifier, Component.Identifier linuxIdentifier) {
        windowsBiMap.put((Object)windowsIdentifier, (Object)mapping);
        macBiMap.put((Object)macIdentifier, (Object)mapping);
        linuxBiMap.put((Object)linuxIdentifier, (Object)mapping);
    }

    public static List<JoystickCompatibilityFilter> getCompatibilityFilters() {
        ArrayList<JoystickCompatibilityFilter> compatibilityFilters = new ArrayList<JoystickCompatibilityFilter>();
        return compatibilityFilters;
    }

    @Override
    public Component.Identifier getIdentifier() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return (Component.Identifier)windowsBiMap.inverse().get((Object)this);
        }
        if (SystemUtils.IS_OS_MAC) {
            return (Component.Identifier)macBiMap.inverse().get((Object)this);
        }
        if (SystemUtils.IS_OS_LINUX) {
            return (Component.Identifier)linuxBiMap.inverse().get((Object)this);
        }
        return null;
    }

    public static MadCatzV1StickMapping getMapping(Component.Identifier identifier) {
        if (SystemUtils.IS_OS_WINDOWS) {
            return (MadCatzV1StickMapping)windowsBiMap.get((Object)identifier);
        }
        if (SystemUtils.IS_OS_MAC) {
            return (MadCatzV1StickMapping)macBiMap.get((Object)identifier);
        }
        if (SystemUtils.IS_OS_LINUX) {
            return (MadCatzV1StickMapping)linuxBiMap.get((Object)identifier);
        }
        return null;
    }

    private static MadCatzV1StickMapping getMapping(Component component) {
        return MadCatzV1StickMapping.getMapping(component.getIdentifier());
    }

    public static MadCatzV1StickMapping getMapping(Event event) {
        return MadCatzV1StickMapping.getMapping(event.getComponent());
    }

    static {
        values = MadCatzV1StickMapping.values();
        windowsBiMap = HashBiMap.create((int)values.length);
        macBiMap = HashBiMap.create((int)values.length);
        linuxBiMap = HashBiMap.create((int)values.length);
        MadCatzV1StickMapping.mapValues(TRIGGER, (Component.Identifier)Component.Identifier.Button._0, (Component.Identifier)Component.Identifier.Button._0, (Component.Identifier)Component.Identifier.Button.TRIGGER);
        MadCatzV1StickMapping.mapValues(THROTTLE, (Component.Identifier)Component.Identifier.Axis.Z, (Component.Identifier)Component.Identifier.Axis.Z, (Component.Identifier)Component.Identifier.Axis.Z);
        MadCatzV1StickMapping.mapValues(HAT, (Component.Identifier)Component.Identifier.Axis.POV, (Component.Identifier)Component.Identifier.Axis.POV, (Component.Identifier)Component.Identifier.Axis.POV);
        MadCatzV1StickMapping.mapValues(STICK_ROLL, (Component.Identifier)Component.Identifier.Axis.X, (Component.Identifier)Component.Identifier.Axis.X, (Component.Identifier)Component.Identifier.Axis.X);
        MadCatzV1StickMapping.mapValues(STICK_PITCH, (Component.Identifier)Component.Identifier.Axis.Y, (Component.Identifier)Component.Identifier.Axis.Y, (Component.Identifier)Component.Identifier.Axis.Y);
        MadCatzV1StickMapping.mapValues(STICK_YAW, (Component.Identifier)Component.Identifier.Axis.RZ, (Component.Identifier)Component.Identifier.Axis.RZ, (Component.Identifier)Component.Identifier.Axis.RZ);
        MadCatzV1StickMapping.mapValues(BUTTON_2, (Component.Identifier)Component.Identifier.Button._1, (Component.Identifier)Component.Identifier.Button._1, (Component.Identifier)Component.Identifier.Button.THUMB);
        MadCatzV1StickMapping.mapValues(BUTTON_3, (Component.Identifier)Component.Identifier.Button._2, (Component.Identifier)Component.Identifier.Button._2, (Component.Identifier)Component.Identifier.Button.THUMB2);
        MadCatzV1StickMapping.mapValues(BUTTON_4, (Component.Identifier)Component.Identifier.Button._3, (Component.Identifier)Component.Identifier.Button._3, (Component.Identifier)Component.Identifier.Button.TOP);
        MadCatzV1StickMapping.mapValues(BUTTON_5, (Component.Identifier)Component.Identifier.Button._4, (Component.Identifier)Component.Identifier.Button._4, (Component.Identifier)Component.Identifier.Button.TOP2);
        MadCatzV1StickMapping.mapValues(BUTTON_6, (Component.Identifier)Component.Identifier.Button._5, (Component.Identifier)Component.Identifier.Button._5, (Component.Identifier)Component.Identifier.Button.PINKIE);
        MadCatzV1StickMapping.mapValues(PINKY_TRIGGER, (Component.Identifier)Component.Identifier.Button._6, (Component.Identifier)Component.Identifier.Button._6, (Component.Identifier)Component.Identifier.Button.BASE);
    }
}

