/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.inputDevices;

import java.util.HashMap;
import java.util.Map;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import org.apache.commons.lang3.SystemUtils;
import us.ihmc.tools.io.printing.SystemStreamGobbler;

public class JInputTools {
    private static boolean controllersHaveBeenLoaded = false;
    private static Map<ControllerType, Controller> controllerMap;

    private static Map<ControllerType, Controller> loadControllersByType() {
        HashMap<ControllerType, Controller> controllerMap = new HashMap<ControllerType, Controller>();
        if (SystemUtils.IS_OS_WINDOWS_8) {
            System.setProperty("jinput.useDefaultPlugin", "false");
            System.setProperty("net.java.games.input.plugins", "net.java.games.input.DirectAndRawInputEnvironmentPlugin");
        }
        ControllerEnvironment controllerEnvironment = ControllerEnvironment.getDefaultEnvironment();
        SystemStreamGobbler gobbler = new SystemStreamGobbler(SystemStreamGobbler.GobbleType.SYSTEM_OUT, SystemStreamGobbler.GobbleType.SYSTEM_ERROR);
        Controller[] controllers = controllerEnvironment.getControllers();
        gobbler.stopGobbling();
        for (Controller controller : controllers) {
            ControllerType controllerType = JInputTools.getControllerType(controller);
            controllerMap.put(controllerType, controller);
        }
        return controllerMap;
    }

    public static Map<ControllerType, Controller> getControllersByType() {
        if (!controllersHaveBeenLoaded) {
            controllerMap = JInputTools.loadControllersByType();
            controllersHaveBeenLoaded = true;
        }
        return controllerMap;
    }

    public static ControllerType getControllerType(Controller controller) {
        boolean knownModel;
        boolean hasXAxis = controller.getComponent((Component.Identifier)Component.Identifier.Axis.X) != null;
        boolean hasYAxis = controller.getComponent((Component.Identifier)Component.Identifier.Axis.Y) != null;
        boolean hasZAxis = controller.getComponent((Component.Identifier)Component.Identifier.Axis.Z) != null;
        boolean hasRXAxis = controller.getComponent((Component.Identifier)Component.Identifier.Axis.RX) != null;
        boolean hasRYAxis = controller.getComponent((Component.Identifier)Component.Identifier.Axis.RY) != null;
        boolean hasRZAxis = controller.getComponent((Component.Identifier)Component.Identifier.Axis.RZ) != null;
        boolean bl = knownModel = controller.getName() != null && (controller.getName().equals("SpaceM") || controller.getName().equals("Space Navigator") || controller.getName().equals("SpaceMouse Pro") || controller.getName().equals("SpaceMouse Wireless Receiver"));
        if (hasXAxis && hasYAxis && hasZAxis && hasRXAxis && hasRYAxis && hasRZAxis && controller.getType().equals(Controller.Type.STICK) && knownModel) {
            return ControllerType.JOYSTICK_3D;
        }
        return ControllerType.UNKNOWN;
    }

    public static enum ControllerType {
        JOYSTICK_3D,
        UNKNOWN;

    }
}

