/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.gui;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import us.ihmc.tools.gui.MyFileFilter;

public class SwingFilePicker
extends JPanel {
    private static final long serialVersionUID = -6158977155755198479L;
    private JTextField textField;
    private JButton button;
    private JFileChooser fileChooser;
    private final Mode mode;

    public SwingFilePicker(Mode mode, int width) {
        this.mode = mode;
        this.fileChooser = new JFileChooser();
        this.setLayout(new FlowLayout(0, 0, 0));
        this.textField = new JTextField(width);
        this.button = new JButton("Browse...");
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingFilePicker.this.browse(e);
            }
        });
        this.add(this.textField);
        this.add(this.button);
    }

    private void browse(ActionEvent e) {
        File file = new File(this.textField.getText());
        File parent = file.getAbsoluteFile().getParentFile();
        if (parent.exists()) {
            this.fileChooser.setCurrentDirectory(parent);
        }
        if (this.mode == Mode.MODE_OPEN) {
            if (this.fileChooser.showOpenDialog(this) == 0) {
                this.textField.setText(this.fileChooser.getSelectedFile().getAbsolutePath());
            }
        } else if (this.mode == Mode.MODE_SAVE && this.fileChooser.showSaveDialog(this) == 0) {
            this.textField.setText(this.fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    public void setAcceptAllFileFilterUsed(boolean b) {
        this.fileChooser.setAcceptAllFileFilterUsed(b);
    }

    public void addFileTypeFilter(FileFilter fileFilter) {
        this.fileChooser.addChoosableFileFilter(fileFilter);
    }

    public void addFileTypeFilter(String extension, String description) {
        MyFileFilter filter = new MyFileFilter(extension, description);
        this.addFileTypeFilter((FileFilter)filter);
    }

    public void setFileSelectionMode(int fileSelectionMode) {
        this.fileChooser.setFileSelectionMode(fileSelectionMode);
    }

    public String getSelectedFilePath() {
        return this.textField.getText();
    }

    public void setSelectedFilePath(String path) {
        this.textField.setText(path);
    }

    public JFileChooser getFileChooser() {
        return this.fileChooser;
    }

    public static enum Mode {
        MODE_OPEN,
        MODE_SAVE;

    }
}

