/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools;

import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.tools.TimerSnapshot;
import us.ihmc.tools.TimerSnapshotWithExpiration;

public class Timer {
    private final Stopwatch stopwatch = new Stopwatch();

    public void reset() {
        this.stopwatch.start();
    }

    public double getElapsedTime() {
        return this.stopwatch.totalElapsed();
    }

    public void sleepUntilExpiration(double expirationTime) {
        TimerSnapshotWithExpiration snapshot = this.createSnapshot(expirationTime);
        if (snapshot.isRunning()) {
            ThreadTools.sleepSeconds((double)(expirationTime - snapshot.getTimePassedSinceReset()));
        }
    }

    public boolean hasBeenSet() {
        return Timer.hasBeenSet(this.getElapsedTime());
    }

    public boolean isExpired(double expirationTime) {
        return Timer.isExpired(this.getElapsedTime(), expirationTime);
    }

    public boolean isRunning(double expirationTime) {
        return Timer.isRunning(this.getElapsedTime(), expirationTime);
    }

    static boolean isRunning(double timePassedSinceReset, double expirationTime) {
        return Timer.hasBeenSet(timePassedSinceReset) && !Timer.isExpired(timePassedSinceReset, expirationTime);
    }

    static boolean hasBeenSet(double timePassedSinceReset) {
        return !Double.isNaN(timePassedSinceReset);
    }

    static boolean isExpired(double timePassedSinceReset, double expirationTime) {
        return Timer.hasBeenSet(timePassedSinceReset) && timePassedSinceReset > expirationTime;
    }

    public TimerSnapshotWithExpiration createSnapshot(double expirationTime) {
        return new TimerSnapshotWithExpiration(this.getElapsedTime(), expirationTime);
    }

    public TimerSnapshot createSnapshot() {
        return new TimerSnapshot(this.getElapsedTime());
    }
}

