/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.thread;

import java.util.concurrent.ScheduledFuture;
import us.ihmc.tools.thread.ExceptionHandlingThreadScheduler;

public class PausablePeriodicThread {
    private final Runnable runnable;
    private final double period;
    private final ExceptionHandlingThreadScheduler scheduler;
    private volatile ScheduledFuture<?> scheduled;

    public PausablePeriodicThread(String name, double period, Runnable runnable) {
        this(name, period, false, runnable);
    }

    public PausablePeriodicThread(String name, double period, int crashesBeforeGivingUp, Runnable runnable) {
        this(name, period, crashesBeforeGivingUp, false, runnable);
    }

    public PausablePeriodicThread(String name, double period, boolean runAsDaemon, Runnable runnable) {
        this(name, period, 0, runAsDaemon, runnable);
    }

    public PausablePeriodicThread(String name, double period, int crashesBeforeGivingUp, boolean runAsDaemon, Runnable runnable) {
        this.runnable = runnable;
        this.period = period;
        this.scheduler = new ExceptionHandlingThreadScheduler(name, ExceptionHandlingThreadScheduler.DEFAULT_HANDLER, crashesBeforeGivingUp, runAsDaemon);
    }

    public void start() {
        if (this.scheduled == null || this.scheduled.isDone()) {
            this.scheduled = this.scheduler.schedule(this.runnable, this.period);
        }
    }

    public void stop() {
        if (this.scheduled != null && !this.scheduled.isCancelled()) {
            this.scheduled.cancel(false);
        }
    }

    public void destroy() {
        this.stop();
        this.scheduler.shutdown();
    }

    public void setRunning(boolean running) {
        if (running) {
            this.start();
        } else {
            this.stop();
        }
    }
}

