/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.factories;

import us.ihmc.tools.factories.FactoryDisposedException;
import us.ihmc.tools.factories.FactoryFieldNotSetException;

public abstract class FactoryField<T> {
    protected boolean hasBeenSet = false;
    protected boolean disposed = false;
    protected String fieldName;
    protected T fieldValue = null;

    public FactoryField(String fieldName) {
        this.fieldName = fieldName;
    }

    public void set(T fieldValue) {
        this.checkNotDisposed();
        this.hasBeenSet = true;
        this.fieldValue = fieldValue;
    }

    public T get() {
        this.checkNotDisposed();
        if (!this.hasBeenSet) {
            throw new FactoryFieldNotSetException(this.fieldName);
        }
        return this.fieldValue;
    }

    public void dispose() {
        this.disposed = true;
    }

    protected void checkNotDisposed() {
        if (this.disposed) {
            throw new FactoryDisposedException();
        }
    }
}

