/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import us.ihmc.commons.nio.PathTools;
import us.ihmc.log.LogTools;

public class WorkspacePathTools {
    public static Path findPathToResource(String directoryNameToAssumePresent, String subsequentPathToResourceFolder, String resourcePathString) {
        return PathTools.findDirectoryInline((String)directoryNameToAssumePresent).resolve(subsequentPathToResourceFolder).resolve(resourcePathString).toAbsolutePath().normalize();
    }

    public static Path handleWorkingDirectoryFuzziness(String directoryNameToFind) {
        Path absoluteWorkingDirectory = Paths.get(".", new String[0]).toAbsolutePath().normalize();
        Path pathBuiltFromSystemRoot = Paths.get("/", new String[0]).toAbsolutePath().normalize();
        boolean directoryFound = false;
        for (Path path : absoluteWorkingDirectory) {
            pathBuiltFromSystemRoot = pathBuiltFromSystemRoot.resolve(path);
            if (!path.toString().equals(directoryNameToFind)) continue;
            directoryFound = true;
            break;
        }
        if (!directoryFound && Files.exists(pathBuiltFromSystemRoot.resolve(directoryNameToFind), new LinkOption[0])) {
            pathBuiltFromSystemRoot = pathBuiltFromSystemRoot.resolve(directoryNameToFind);
            directoryFound = true;
        }
        if (!directoryFound) {
            LogTools.warn((String)"{} directory could not be found. Working directory: {} Search stopped at: {}", (Object)directoryNameToFind, (Object)absoluteWorkingDirectory, (Object)pathBuiltFromSystemRoot);
            return null;
        }
        return pathBuiltFromSystemRoot;
    }
}

