/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.thread;

import gnu.trove.list.array.TIntArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.commons.thread.TypedNotification;
import us.ihmc.log.LogTools;
import us.ihmc.tools.thread.MissingThreadTools;
import us.ihmc.tools.thread.ResettableExceptionHandlingExecutorService;

public class MissingThreadToolsTest {
    @Test
    public void testSleepAtLeast() {
        Assertions.assertTrue((boolean)this.conductSleepTest(1.0E-13, false));
        Assertions.assertTrue((boolean)this.conductSleepTest(5.0E-10, false));
        Assertions.assertTrue((boolean)this.conductSleepTest(1.0E-9, false));
        Assertions.assertTrue((boolean)this.conductSleepTest(0.1, false));
        Assertions.assertTrue((boolean)this.conductSleepTest(1.0E-4, false));
        Assertions.assertTrue((boolean)this.conductSleepTest(5.0E-10, false));
        Assertions.assertTrue((boolean)this.conductSleepTest(1.1, false));
        Assertions.assertTrue((boolean)this.conductSleepTest(2.0, false));
        Assertions.assertTrue((boolean)this.conductSleepTest(1.0E-13, true));
        Assertions.assertTrue((boolean)this.conductSleepTest(5.0E-10, true));
        Assertions.assertTrue((boolean)this.conductSleepTest(1.0E-9, true));
        Assertions.assertTrue((boolean)this.conductSleepTest(0.1, true));
        Assertions.assertTrue((boolean)this.conductSleepTest(1.0E-4, true));
        Assertions.assertTrue((boolean)this.conductSleepTest(5.0E-10, true));
        Assertions.assertTrue((boolean)this.conductSleepTest(1.1, true));
        Assertions.assertTrue((boolean)this.conductSleepTest(2.0, true));
    }

    private boolean conductSleepTest(double sleepDuration, boolean atLeast) {
        double before = Conversions.nanosecondsToSeconds((long)System.nanoTime());
        if (atLeast) {
            ThreadTools.parkAtLeast((double)sleepDuration);
        } else {
            ThreadTools.park((double)sleepDuration);
        }
        double after = Conversions.nanosecondsToSeconds((long)System.nanoTime());
        double overslept = after - before - sleepDuration;
        LogTools.info((String)"Overslept %f ms".formatted(Conversions.secondsToMilliseconds((double)overslept)));
        Assertions.assertTrue((overslept < 0.005 ? 1 : 0) != 0);
        return overslept > 0.0;
    }

    @Test
    public void testSecondsDecomposition() {
        double seconds = Math.PI / 180;
        long nanoseconds = (long)(seconds * 1.0E9);
        long milliseconds = nanoseconds / 1000000L;
        double seconds2 = (double)milliseconds / 1000.0 + (double)(nanoseconds %= 1000000L) / 1.0E9;
        double remaining = seconds - seconds2;
        LogTools.info((String)"Original:      %.40f".formatted(seconds));
        LogTools.info((String)"Reconstructed: %.40f".formatted(seconds2));
        LogTools.info((String)"Remaining: %.40f".formatted(remaining));
        LogTools.info((String)"s %% 1e-9: %.40f".formatted(seconds % 1.0E-9));
        this.conductModTest(1.0);
        this.conductModTest(0.1);
        this.conductModTest(1239991.123);
        this.conductModTest(181.232381318381);
        this.conductModTest(0.0);
        this.conductModTest(1.0E-9);
        this.conductModTest(5.0E-10);
        LogTools.info((String)"%d".formatted(0L));
        LogTools.info((String)"%d".formatted(0L));
        LogTools.info((String)"%d".formatted(1L));
        LogTools.info((String)"%d".formatted(0L));
        Assertions.assertEquals((double)seconds, (double)seconds2, (double)1.0E-9);
    }

    private void conductModTest(double number) {
        double nanos = number % 1.0E-9;
        LogTools.info((String)"%.16f: %.35f  %b".formatted(number, nanos, nanos > 1.0E-9));
    }

    @Test
    public void testSingleScheduleThreadWithThrownException() {
        LogTools.info((String)"Begin test");
        TIntArrayList ints = new TIntArrayList();
        int queueSize = -1;
        boolean daemon = false;
        ResettableExceptionHandlingExecutorService executor = MissingThreadTools.newSingleThreadExecutor((String)"Test", (boolean)daemon, (int)queueSize);
        AtomicInteger numberOfThingsThatHappened = new AtomicInteger();
        executor.execute(() -> {
            ThreadTools.parkAtLeast((double)0.01);
            ints.add(0);
            LogTools.info((String)"ints = {}", (Object)ints);
            numberOfThingsThatHappened.getAndIncrement();
        }, exception -> {
            ResettableExceptionHandlingExecutorService.MESSAGE_AND_TRACE_WITH_THREAD_NAME.handleException(exception);
            Assertions.assertTrue((boolean)(exception instanceof ArrayIndexOutOfBoundsException));
        });
        MissingThreadToolsTest.awaitExecution(executor);
        executor.submit(() -> {
            ThreadTools.parkAtLeast((double)0.01);
            ints.add(1);
            LogTools.info((String)"ints = {}", (Object)ints);
            numberOfThingsThatHappened.getAndIncrement();
        }, exception -> {
            ResettableExceptionHandlingExecutorService.MESSAGE_AND_TRACE_WITH_THREAD_NAME.handleException(exception);
            Assertions.assertTrue((boolean)(exception instanceof ArrayIndexOutOfBoundsException));
        });
        MissingThreadToolsTest.awaitExecution(executor);
        executor.submit(() -> {
            ThreadTools.parkAtLeast((double)0.01);
            ints.add(2);
            LogTools.info((String)"ints = {}", (Object)ints);
            numberOfThingsThatHappened.getAndIncrement();
            return 5;
        }, (result, exception) -> {
            ResettableExceptionHandlingExecutorService.MESSAGE_AND_TRACE_WITH_THREAD_NAME.handleException(exception);
            Assertions.assertTrue((boolean)(exception instanceof ArrayIndexOutOfBoundsException));
        });
        MissingThreadToolsTest.awaitExecution(executor);
        executor.submit(() -> {
            ThreadTools.parkAtLeast((double)0.01);
            ints.add(3);
            LogTools.info((String)"ints = {}", (Object)ints);
            numberOfThingsThatHappened.getAndIncrement();
            return 5;
        }, (result, exception) -> Assertions.assertEquals((int)5, (Integer)result));
        MissingThreadToolsTest.awaitExecution(executor);
        Assertions.assertEquals((int)4, (int)numberOfThingsThatHappened.get());
        executor.destroy();
    }

    private static void awaitExecution(ResettableExceptionHandlingExecutorService executor) {
        double timeSlept;
        double timeout = 2.0;
        for (timeSlept = 0.0; executor.isExecuting() && timeSlept < timeout; timeSlept += ThreadTools.parkAtLeast((double)0.2)) {
        }
        Assertions.assertTrue((timeSlept < timeout ? 1 : 0) != 0, (String)"Timed out");
    }

    @Test
    public void testOneQueued() {
        StringBuilder output = new StringBuilder();
        ResettableExceptionHandlingExecutorService executor = MissingThreadTools.newSingleThreadExecutor((String)"Test", (boolean)false, (int)1);
        TypedNotification resultOne = new TypedNotification();
        TypedNotification resultTwo = new TypedNotification();
        Runnable runnableOne = () -> {
            output.append("a");
            ThreadTools.sleep((long)10L);
            resultOne.set((Object)output.toString());
        };
        Runnable runnableTwo = () -> {
            output.append("b");
            ThreadTools.sleep((long)10L);
            resultTwo.set((Object)output.toString());
        };
        executor.clearTaskQueue();
        executor.submit(runnableOne);
        executor.clearTaskQueue();
        executor.submit(runnableTwo);
        resultOne.blockingPoll();
        Assertions.assertEquals((Object)"a", (Object)resultOne.read());
        resultTwo.blockingPoll();
        Assertions.assertEquals((Object)"ab", (Object)resultTwo.read());
        executor.destroy();
    }

    @Test
    public void testSkipItemInQueue() {
        StringBuilder output = new StringBuilder();
        ResettableExceptionHandlingExecutorService executor = MissingThreadTools.newSingleThreadExecutor((String)"Test", (boolean)false, (int)1);
        TypedNotification resultOne = new TypedNotification();
        TypedNotification resultTwo = new TypedNotification();
        TypedNotification resultThree = new TypedNotification();
        Runnable runnableOne = () -> {
            output.append("a");
            ThreadTools.sleep((long)10L);
            resultOne.set((Object)output.toString());
        };
        Runnable runnableTwo = () -> {
            output.append("b");
            ThreadTools.sleep((long)10L);
            resultTwo.set((Object)output.toString());
        };
        Runnable runnableThree = () -> {
            output.append("c");
            ThreadTools.sleep((long)10L);
            resultThree.set((Object)output.toString());
        };
        executor.clearTaskQueue();
        executor.submit(runnableOne);
        executor.clearTaskQueue();
        executor.submit(runnableTwo);
        executor.clearTaskQueue();
        executor.submit(runnableThree);
        resultOne.blockingPoll();
        Assertions.assertEquals((Object)"a", (Object)resultOne.read());
        resultThree.blockingPoll();
        Assertions.assertEquals((Object)"ac", (Object)resultThree.read());
        executor.destroy();
    }

    @Test
    public void testCancellableScheduledTasks() {
        ScheduledExecutorService scheduler = ThreadTools.newSingleDaemonThreadScheduledExecutor((String)"Test");
        StringBuilder output = new StringBuilder();
        ScheduledFuture<StringBuilder> scheduledFuture1 = scheduler.schedule(() -> output.append("A"), 400L, TimeUnit.MILLISECONDS);
        ThreadTools.sleep((long)200L);
        scheduledFuture1.cancel(false);
        scheduler.schedule(() -> output.append("B"), 400L, TimeUnit.MILLISECONDS);
        ThreadTools.sleep((long)600L);
        ScheduledFuture<StringBuilder> scheduledFuture2 = scheduler.schedule(() -> output.append("C"), 400L, TimeUnit.MILLISECONDS);
        ThreadTools.sleep((long)200L);
        scheduledFuture2.cancel(false);
        ThreadTools.sleep((long)600L);
        scheduler.schedule(() -> output.append("D"), 400L, TimeUnit.MILLISECONDS);
        ThreadTools.sleep((long)600L);
        scheduler.schedule(() -> ExceptionTools.handle(() -> {
            output.append("E");
            throw new NullPointerException();
        }, (ExceptionHandler)DefaultExceptionHandler.PRINT_MESSAGE), 400L, TimeUnit.MILLISECONDS);
        ThreadTools.sleep((long)600L);
        ScheduledFuture<StringBuilder> scheduledFuture3 = scheduler.schedule(() -> output.append("F"), 400L, TimeUnit.MILLISECONDS);
        ThreadTools.sleep((long)200L);
        scheduledFuture3.cancel(false);
        ThreadTools.sleep((long)600L);
        String recordedOutput = output.toString();
        Assertions.assertEquals((Object)"BDE", (Object)recordedOutput);
        LogTools.info((String)recordedOutput);
        scheduler.shutdown();
    }
}

