/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io;

import java.nio.file.Path;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.log.LogTools;
import us.ihmc.tools.io.HybridDirectoryTest;
import us.ihmc.tools.io.WorkspaceDirectory;
import us.ihmc.tools.io.WorkspaceJavaDirectory;
import us.ihmc.tools.io.WorkspaceResourceDirectory;
import us.ihmc.tools.io.WorkspaceResourceFile;

public class WorkspaceDirectoryTest {
    @Test
    public void testWorkspaceDirectory() {
        WorkspaceDirectory workspaceDirectory = new WorkspaceDirectory("ihmc-open-robotics-software");
        LogTools.info((String)"File access available: {}", (Object)(workspaceDirectory.isFileAccessAvailable() ? "Yes" : "No"));
        if (workspaceDirectory.isFileAccessAvailable()) {
            Path directoryPath = workspaceDirectory.getFilesystemDirectory();
            LogTools.info((String)"Directory path: {}", (Object)directoryPath);
            Assertions.assertNotNull((Object)directoryPath, (String)"Directory path is null");
        }
    }

    @Test
    public void testWorkspaceResourceDirectory() {
        WorkspaceResourceDirectory workspaceDirectory = new WorkspaceResourceDirectory(WorkspaceDirectoryTest.class);
        LogTools.info((String)"File access available: {}", (Object)(workspaceDirectory.isFileAccessAvailable() ? "Yes" : "No"));
        if (workspaceDirectory.isFileAccessAvailable()) {
            Path directoryPath = workspaceDirectory.getFilesystemDirectory();
            LogTools.info((String)"Directory path: {}", (Object)directoryPath);
            Assertions.assertNotNull((Object)directoryPath, (String)"Directory path is null");
        }
        WorkspaceResourceDirectory directory = new WorkspaceResourceDirectory(HybridDirectoryTest.class);
        WorkspaceDirectoryTest.printDirectoryInfo(directory);
        Assertions.assertEquals((Object)"/us/ihmc/tools/io", (Object)directory.getPathNecessaryForClasspathLoading());
        Assertions.assertEquals((Object)"us.ihmc.tools.io", (Object)directory.getPathNecessaryForResourceExploring());
        WorkspaceResourceFile file = new WorkspaceResourceFile(directory, "classLocatedResource.txt");
        WorkspaceDirectoryTest.printFileInfo(file);
        Assertions.assertNotNull((Object)file.getClasspathResource());
        directory = new WorkspaceResourceDirectory(HybridDirectoryTest.class);
        WorkspaceDirectoryTest.printDirectoryInfo(directory);
        Assertions.assertEquals((Object)"/us/ihmc/tools/io", (Object)directory.getPathNecessaryForClasspathLoading());
        Assertions.assertEquals((Object)"us.ihmc.tools.io", (Object)directory.getPathNecessaryForResourceExploring());
        file = new WorkspaceResourceFile(directory, "testRootResource.txt");
        WorkspaceDirectoryTest.printFileInfo(file);
        Assertions.assertNull((Object)file.getClasspathResource());
        directory = new WorkspaceResourceDirectory(HybridDirectoryTest.class, "/");
        WorkspaceDirectoryTest.printDirectoryInfo(directory);
        Assertions.assertEquals((Object)"/", (Object)directory.getPathNecessaryForClasspathLoading());
        Assertions.assertEquals((Object)"", (Object)directory.getPathNecessaryForResourceExploring());
        file = new WorkspaceResourceFile(directory, "testRootResource.txt");
        WorkspaceDirectoryTest.printFileInfo(file);
        Assertions.assertNotNull((Object)file.getClasspathResource());
        directory = new WorkspaceResourceDirectory(HybridDirectoryTest.class, "subsequent");
        WorkspaceDirectoryTest.printDirectoryInfo(directory);
        Assertions.assertEquals((Object)"/us/ihmc/tools/io/subsequent", (Object)directory.getPathNecessaryForClasspathLoading());
        Assertions.assertEquals((Object)"us.ihmc.tools.io.subsequent", (Object)directory.getPathNecessaryForResourceExploring());
        file = new WorkspaceResourceFile(directory, "classSubsequentResource.txt");
        WorkspaceDirectoryTest.printFileInfo(file);
        Assertions.assertNotNull((Object)file.getClasspathResource());
        directory = new WorkspaceResourceDirectory(HybridDirectoryTest.class, "subsequent/further");
        WorkspaceDirectoryTest.printDirectoryInfo(directory);
        Assertions.assertEquals((Object)"/us/ihmc/tools/io/subsequent/further", (Object)directory.getPathNecessaryForClasspathLoading());
        Assertions.assertEquals((Object)"us.ihmc.tools.io.subsequent.further", (Object)directory.getPathNecessaryForResourceExploring());
        file = new WorkspaceResourceFile(directory, "classFurtherSubsequentResource.txt");
        WorkspaceDirectoryTest.printFileInfo(file);
        Assertions.assertNotNull((Object)file.getClasspathResource());
    }

    @Test
    public void testWorkspaceJavaDirectory() {
        WorkspaceJavaDirectory workspaceJavaDirectory = new WorkspaceJavaDirectory(WorkspaceJavaDirectory.class, "java");
        WorkspaceDirectoryTest.printDirectoryInfo(workspaceJavaDirectory);
    }

    private static void printFileInfo(WorkspaceResourceFile file) {
        LogTools.info((String)"File path: {}", (Object)file.getFilesystemFile());
        LogTools.info((String)"Path for resource loading: {}", (Object)file.getPathForResourceLoadingPathFiltered());
        LogTools.info((String)"Classpath resource: {}", (Object)file.getClasspathResource());
    }

    private static void printDirectoryInfo(WorkspaceResourceDirectory directory) {
        LogTools.info((String)"File access available: {}", (Object)(directory.isFileAccessAvailable() ? "Yes" : "No"));
        LogTools.info((String)"Directory path: {}", (Object)directory.getFilesystemDirectory());
        LogTools.info((String)"Class for loading: {}", (Object)directory.getClassForLoading());
        LogTools.info((String)"Path necessary for classpath loading: {}", (Object)directory.getPathNecessaryForClasspathLoading());
        LogTools.info((String)"Path necessary for resource exploring: {}", (Object)directory.getPathNecessaryForResourceExploring());
    }

    private static void printDirectoryInfo(WorkspaceJavaDirectory directory) {
        LogTools.info((String)"File access available: {}", (Object)(directory.isFileAccessAvailable() ? "Yes" : "No"));
        LogTools.info((String)"Directory path: {}", (Object)directory.getFilesystemDirectory());
    }
}

