/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.tools.io.DatagramInputStream;
import us.ihmc.tools.io.DatagramOutputStream;

public class DatagramOutputStreamTest {
    private static final long messageSleepMillis = 200L;
    private static final boolean VERBOSE = false;

    @Disabled
    public void testDatagramOutputStreamThrowOutStalePackets() throws IOException {
        boolean throwOutStalePackets = true;
        int[] expectedMessagesToReceive = new int[]{0, 1, 2, 3, 4, 5, 15, 16, 17, 18, 19, 20};
        this.runATest(1776, throwOutStalePackets, expectedMessagesToReceive);
    }

    @Test
    public void testDatagramOutputStreamDoNotThrowOutStalePackets() throws IOException {
        boolean throwOutStalePackets = false;
        int[] expectedMessagesToReceive = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
        this.runATest(1984, throwOutStalePackets, expectedMessagesToReceive);
    }

    private void runATest(int port, boolean throwOutStalePackets, int[] expectedMessagesToReceive) throws IOException {
        DatagramOutputStream datagramOutputStream = new DatagramOutputStream(port, "localhost");
        DatagramInputStream datagramInputStream = new DatagramInputStream(port);
        datagramInputStream.setThrowOutStalePackets(throwOutStalePackets);
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)datagramOutputStream);
        DataInputStream dataInputStream = new DataInputStream((InputStream)datagramInputStream);
        int messagesToSend = 50;
        int messagesToReceive = 20;
        this.startSendingRandomMessagesOnAThread(dataOutputStream, messagesToSend);
        ArrayList<Integer> messagesReceived = new ArrayList<Integer>();
        long sleepTime = 100L;
        int messageNumber = 0;
        while (messageNumber < messagesToReceive) {
            messageNumber = dataInputStream.readInt();
            double doubleValue = dataInputStream.readDouble();
            String inString = dataInputStream.readUTF();
            messagesReceived.add(messageNumber);
            if (messageNumber > 8) {
                sleepTime = 1L;
            } else if (messageNumber > 4) {
                sleepTime = 1900L;
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.verifyRecievedExpectedMessages(expectedMessagesToReceive, messagesReceived);
    }

    private void printRecievedMessages(ArrayList<Integer> messagesReceived) {
        for (int i = 0; i < messagesReceived.size(); ++i) {
            System.out.print(String.valueOf(messagesReceived.get(i)) + " ");
        }
    }

    private void verifyRecievedExpectedMessages(int[] expectedReceivedMessages, ArrayList<Integer> messagesReceived) {
        Assert.assertEquals((long)expectedReceivedMessages.length, (long)messagesReceived.size());
        for (int i = 0; i < expectedReceivedMessages.length; ++i) {
            Assert.assertEquals((long)expectedReceivedMessages[i], (long)messagesReceived.get(i).intValue());
        }
    }

    private void startSendingRandomMessagesOnAThread(final DataOutputStream dataOutputStream, final int messagesToSend) {
        Thread thread = new Thread("Random Message Sender"){

            @Override
            public void run() {
                int messageNumber = 0;
                while (messageNumber < messagesToSend) {
                    try {
                        dataOutputStream.writeInt(messageNumber);
                        dataOutputStream.writeDouble(Math.random());
                        dataOutputStream.writeUTF("Message" + messageNumber);
                        dataOutputStream.flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return;
                    }
                    ++messageNumber;
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        thread.start();
    }
}

