/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.TreeSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.nio.BasicPathVisitor;
import us.ihmc.log.LogTools;
import us.ihmc.tools.io.HybridResourceDirectory;
import us.ihmc.tools.io.HybridResourceFile;
import us.ihmc.tools.io.resources.ResourceTools;

public class HybridDirectoryTest {
    @Test
    public void testConstructors() {
        Path dotIHMC = Paths.get(System.getProperty("user.home"), new String[0]).resolve(".ihmc");
        HybridResourceDirectory directory = new HybridResourceDirectory(dotIHMC, HybridDirectoryTest.class);
        HybridDirectoryTest.printDirectoryInfo(directory);
        Assertions.assertEquals((Object)"/us/ihmc/tools/io", (Object)directory.getPathNecessaryForClasspathLoading());
        Assertions.assertEquals((Object)"us.ihmc.tools.io", (Object)directory.getPathNecessaryForResourceExploring());
        HybridResourceFile file = new HybridResourceFile(directory, "classLocatedResource.txt");
        HybridDirectoryTest.printFileInfo(file);
        Assertions.assertNotNull((Object)file.getClasspathResource());
        directory = new HybridResourceDirectory(dotIHMC, HybridDirectoryTest.class);
        HybridDirectoryTest.printDirectoryInfo(directory);
        Assertions.assertEquals((Object)"/us/ihmc/tools/io", (Object)directory.getPathNecessaryForClasspathLoading());
        Assertions.assertEquals((Object)"us.ihmc.tools.io", (Object)directory.getPathNecessaryForResourceExploring());
        file = new HybridResourceFile(directory, "testRootResource.txt");
        HybridDirectoryTest.printFileInfo(file);
        Assertions.assertNull((Object)file.getClasspathResource());
        directory = new HybridResourceDirectory(dotIHMC, HybridDirectoryTest.class, "/");
        HybridDirectoryTest.printDirectoryInfo(directory);
        Assertions.assertEquals((Object)"/", (Object)directory.getPathNecessaryForClasspathLoading());
        Assertions.assertEquals((Object)"", (Object)directory.getPathNecessaryForResourceExploring());
        file = new HybridResourceFile(directory, "testRootResource.txt");
        HybridDirectoryTest.printFileInfo(file);
        Assertions.assertNotNull((Object)file.getClasspathResource());
        directory = new HybridResourceDirectory(dotIHMC, HybridDirectoryTest.class, "subsequent");
        HybridDirectoryTest.printDirectoryInfo(directory);
        Assertions.assertEquals((Object)"/us/ihmc/tools/io/subsequent", (Object)directory.getPathNecessaryForClasspathLoading());
        Assertions.assertEquals((Object)"us.ihmc.tools.io.subsequent", (Object)directory.getPathNecessaryForResourceExploring());
        file = new HybridResourceFile(directory, "classSubsequentResource.txt");
        HybridDirectoryTest.printFileInfo(file);
        Assertions.assertNotNull((Object)file.getClasspathResource());
        directory = new HybridResourceDirectory(dotIHMC, HybridDirectoryTest.class, "subsequent/further");
        HybridDirectoryTest.printDirectoryInfo(directory);
        Assertions.assertEquals((Object)"/us/ihmc/tools/io/subsequent/further", (Object)directory.getPathNecessaryForClasspathLoading());
        Assertions.assertEquals((Object)"us.ihmc.tools.io.subsequent.further", (Object)directory.getPathNecessaryForResourceExploring());
        file = new HybridResourceFile(directory, "classFurtherSubsequentResource.txt");
        HybridDirectoryTest.printFileInfo(file);
        Assertions.assertNotNull((Object)file.getClasspathResource());
    }

    private static void printFileInfo(HybridResourceFile file) {
        LogTools.info((String)"Workspace file: {}", (Object)file.getWorkspaceFile());
        LogTools.info((String)"External file: {}", (Object)file.getExternalFile());
        LogTools.info((String)"Location of resource for reading: {}", (Object)file.getLocationOfResourceForReading());
        LogTools.info((String)"Path for resource loading: {}", (Object)file.getPathForResourceLoadingPathFiltered());
        LogTools.info((String)"Classpath resource: {}", (Object)file.getClasspathResource());
    }

    private static void printDirectoryInfo(HybridResourceDirectory directory) {
        LogTools.info((String)"Workspace directory: {}", (Object)directory.getWorkspaceDirectory());
        LogTools.info((String)"External directory: {}", (Object)directory.getExternalDirectory());
        LogTools.info((String)"Class for loading: {}", (Object)directory.getClassForLoading());
        LogTools.info((String)"Path necessary for classpath loading: {}", (Object)directory.getPathNecessaryForClasspathLoading());
        LogTools.info((String)"Path necessary for resource exploring: {}", (Object)directory.getPathNecessaryForResourceExploring());
    }

    @Test
    public void testReadResourcesFromJar() {
        Path dotIHMC = Paths.get(System.getProperty("user.home"), new String[0]).resolve(".ihmc");
        HybridResourceDirectory directory = new HybridResourceDirectory(dotIHMC, HybridDirectoryTest.class, "/");
        for (String resource : ResourceTools.listResources((String)directory.getPathNecessaryForResourceExploring(), (String)".*")) {
            LogTools.info((String)resource);
        }
        LogTools.info((String)"Walking flat");
        TreeSet directoryNames = new TreeSet();
        TreeSet fileNames = new TreeSet();
        directory.walkResourcesFlat((path, pathType) -> {
            LogTools.info((String)"{}: {}", (Object)pathType.name(), (Object)path);
            if (pathType == BasicPathVisitor.PathType.FILE) {
                fileNames.add(path);
            } else {
                directoryNames.add(path);
            }
        });
        Assertions.assertTrue((boolean)fileNames.contains("testRootResource.txt"));
        Assertions.assertTrue((boolean)directoryNames.contains("us"));
        Assertions.assertTrue((boolean)directoryNames.contains("root"));
        directory = new HybridResourceDirectory(dotIHMC, HybridDirectoryTest.class);
        directoryNames.clear();
        fileNames.clear();
        directory.walkResourcesFlat((path, pathType) -> {
            LogTools.info((String)"{}: {}", (Object)pathType.name(), (Object)path);
            if (pathType == BasicPathVisitor.PathType.FILE) {
                fileNames.add(path);
            } else {
                directoryNames.add(path);
            }
        });
        Assertions.assertTrue((boolean)fileNames.contains("classLocatedResource.txt"));
        Assertions.assertTrue((boolean)directoryNames.contains("files"));
        Assertions.assertTrue((boolean)directoryNames.contains("subsequent"));
    }
}

