/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.thread;

import org.junit.jupiter.api.Test;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.robotics.TestTools;
import us.ihmc.tools.UnitConversions;
import us.ihmc.tools.thread.Throttler;
import us.ihmc.tools.time.FrequencyCalculator;
import us.ihmc.tools.time.FrequencyStatisticPrinter;

public class ThrottlerTest {
    @Test
    public void testThrottler10Hz() {
        Throttler throttler = new Throttler();
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        double hertz = 10.0;
        FrequencyStatisticPrinter frequencyStatisticPrinter = new FrequencyStatisticPrinter();
        FrequencyCalculator frequencyCalculator = new FrequencyCalculator();
        while (stopwatch.totalElapsed() < 5.0) {
            if (!throttler.run(UnitConversions.hertzToSeconds((double)hertz))) continue;
            frequencyStatisticPrinter.ping();
            frequencyCalculator.ping();
        }
        frequencyStatisticPrinter.destroy();
        TestTools.assertEpsilonEquals((double)hertz, (double)frequencyCalculator.getFrequency(), (double)0.5, (String)"Frequency not correct");
    }

    @Test
    public void testThrottler5Hz() {
        double hertz = 5.0;
        Throttler throttler = new Throttler().setFrequency(hertz);
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        FrequencyStatisticPrinter frequencyStatisticPrinter = new FrequencyStatisticPrinter();
        FrequencyCalculator frequencyCalculator = new FrequencyCalculator();
        while (stopwatch.totalElapsed() < 5.0) {
            if (!throttler.run()) continue;
            frequencyStatisticPrinter.ping();
            frequencyCalculator.ping();
        }
        frequencyStatisticPrinter.destroy();
        TestTools.assertEpsilonEquals((double)hertz, (double)frequencyCalculator.getFrequency(), (double)0.5, (String)"Frequency not correct");
    }

    @Test
    public void testThrottler5HzSleep() {
        double hertz = 5.0;
        Throttler throttler = new Throttler().setPeriod(UnitConversions.hertzToSeconds((double)hertz));
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        FrequencyStatisticPrinter frequencyStatisticPrinter = new FrequencyStatisticPrinter();
        FrequencyCalculator frequencyCalculator = new FrequencyCalculator();
        while (stopwatch.totalElapsed() < 5.0) {
            throttler.waitAndRun();
            frequencyStatisticPrinter.ping();
            frequencyCalculator.ping();
        }
        frequencyStatisticPrinter.destroy();
        TestTools.assertEpsilonEquals((double)hertz, (double)frequencyCalculator.getFrequency(), (double)0.5, (String)"Frequency not correct");
    }
}

