/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.factories;

import org.junit.jupiter.api.Test;
import us.ihmc.commons.Assertions;
import us.ihmc.commons.RunnableThatThrows;
import us.ihmc.tools.factories.ExampleInvalidFactory;
import us.ihmc.tools.factories.ExampleValidFactory;
import us.ihmc.tools.factories.FactoryDisposedException;
import us.ihmc.tools.factories.FactoryFieldNotSetException;

public class FactoryToolsTest {
    @Test
    public void testFactoryDisposes() {
        final ExampleValidFactory exampleFactory = new ExampleValidFactory();
        exampleFactory.setRequiredField1(1.0);
        exampleFactory.setRequiredField2(1.0);
        exampleFactory.createObject();
        Assertions.assertExceptionThrown(FactoryDisposedException.class, (RunnableThatThrows)new RunnableThatThrows(){

            public void run() throws Throwable {
                exampleFactory.createObject();
            }
        });
    }

    @Test
    public void testFactoryRequiresFieldsSet() {
        final ExampleValidFactory exampleFactory = new ExampleValidFactory();
        exampleFactory.setRequiredField1(1.0);
        Assertions.assertExceptionThrown(FactoryFieldNotSetException.class, (RunnableThatThrows)new RunnableThatThrows(){

            public void run() throws Throwable {
                exampleFactory.createObject();
            }
        });
    }

    @Test
    public void testFactoryRequiresOptionalNotNull() {
        final ExampleInvalidFactory exampleFactory = new ExampleInvalidFactory();
        exampleFactory.setRequiredField1(1.0);
        exampleFactory.setRequiredField2(1.0);
        Assertions.assertExceptionThrown(NullPointerException.class, (RunnableThatThrows)new RunnableThatThrows(){

            public void run() throws Throwable {
                exampleFactory.createObject();
            }
        });
    }
}

