/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.dataSampling;

import java.util.ArrayList;
import java.util.HashMap;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.tools.dataSampling.DataSampler;

public class DataSamplerTest {
    private static double epsilon = 1.0E-10;
    DataSampler<Double> dataSampler;
    String[] variableNames = new String[]{"var1", "var2", "var3"};
    double[] variableFirstValues = new double[]{1.5, 2.5, 3.5};
    double[] variableSecondValues = new double[]{1.6, 1.6, 3.6};
    double[] variableThirdValues = new double[]{1.7, 2.7, 3.7};
    int initialTime = 1;
    int numberOfSamples = 10;
    double timeInterval = 20.5;
    HashMap<String, Double> firstData = this.createFirstData();
    HashMap<String, Double> secondData = this.createSecondData();
    HashMap<String, Double> thirdData = this.createThirdData();

    @BeforeEach
    public void createDataSampler() {
        this.dataSampler = new DataSampler();
    }

    @Test
    public void testInitialization() {
        this.dataSampler.initialize(this.variableNames, (double)this.initialTime, this.timeInterval, this.numberOfSamples);
        double detaTimeFromSampler = this.dataSampler.getDeltaTime();
        Assert.assertEquals((double)2.05, (double)detaTimeFromSampler, (double)epsilon);
        ArrayList array = this.dataSampler.getSingleVariableSamples(this.variableNames[0]);
        Assert.assertNotNull((Object)array);
        ArrayList array2 = this.dataSampler.getSingleVariableSamples(this.variableNames[1]);
        Assert.assertNotNull((Object)array2);
    }

    @Test
    public void testSampling() {
        this.dataSampler.initialize(this.variableNames, (double)this.initialTime, this.timeInterval, this.numberOfSamples);
        this.dataSampler.acquire(this.firstData.get("time").doubleValue(), this.firstData);
        this.dataSampler.acquire(this.secondData.get("time").doubleValue(), this.secondData);
        this.dataSampler.acquire(this.thirdData.get("time").doubleValue(), this.thirdData);
        ArrayList array = this.dataSampler.getSingleVariableSamples(this.variableNames[0]);
        Assert.assertEquals((double)this.variableFirstValues[0], (double)((Double)array.get(0)), (double)epsilon);
        Assert.assertEquals((double)this.variableThirdValues[0], (double)((Double)array.get(1)), (double)epsilon);
    }

    private HashMap<String, Double> createFirstData() {
        HashMap<String, Double> data = new HashMap<String, Double>();
        for (int i = 0; i < this.variableNames.length; ++i) {
            data.put(this.variableNames[i], this.variableFirstValues[i]);
        }
        data.put("time", 1.1);
        return data;
    }

    private HashMap<String, Double> createSecondData() {
        HashMap<String, Double> data = new HashMap<String, Double>();
        for (int i = 0; i < this.variableNames.length; ++i) {
            data.put(this.variableNames[i], this.variableSecondValues[i]);
        }
        data.put("time", 1.2);
        return data;
    }

    private HashMap<String, Double> createThirdData() {
        HashMap<String, Double> data = new HashMap<String, Double>();
        for (int i = 0; i < this.variableNames.length; ++i) {
            data.put(this.variableNames[i], this.variableThirdValues[i]);
        }
        data.put("time", 4.0);
        return data;
    }
}

