/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.string;

import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.tools.string.StringTools;

public class StringToolsTest {
    @Test
    public void testString() {
        String string = "YoLowLevelOneDoFJointDesiredDataHolder";
        String uppercaseLetters = StringTools.getEveryUppercaseLetter((String)string);
        Assert.assertTrue((boolean)uppercaseLetters.equals("YLLODFJDDH"));
        string = "YoLowLevelOneDoFJointDesiredDataHolderT";
        uppercaseLetters = StringTools.getEveryUppercaseLetter((String)string);
        Assert.assertTrue((boolean)uppercaseLetters.equals("YLLODFJDDHT"));
        string = "";
        uppercaseLetters = StringTools.getEveryUppercaseLetter((String)string);
        Assert.assertTrue((boolean)uppercaseLetters.equals(""));
        string = "DDFHHHDSRTRDFHNUYFRYJJ";
        uppercaseLetters = StringTools.getEveryUppercaseLetter((String)string);
        Assert.assertTrue((boolean)uppercaseLetters.equals("DDFHHHDSRTRDFHNUYFRYJJ"));
        string = "DDFHHHD7474S747R8585T88586RD685686F?HNU&)$#YFRYJJ";
        uppercaseLetters = StringTools.getEveryUppercaseLetter((String)string);
        Assert.assertTrue((boolean)uppercaseLetters.equals("DDFHHHDSRTRDFHNUYFRYJJ"));
    }

    @Test
    public void testCasingMethods() {
        Assert.assertEquals((Object)"snake", (Object)StringTools.titleToSnakeCase((String)"Snake"));
        Assert.assertEquals((Object)"snake_case", (Object)StringTools.titleToSnakeCase((String)"Snake Case"));
        Assert.assertEquals((Object)"snake_case_blep", (Object)StringTools.titleToSnakeCase((String)"snake case BLEP"));
        Assert.assertEquals((Object)"sfu_ai2_1_!!", (Object)StringTools.titleToSnakeCase((String)"     sfu ai2 1    !!"));
        Assert.assertEquals((Object)"kebab", (Object)StringTools.titleToKebabCase((String)"Kebab"));
        Assert.assertEquals((Object)"kebab-case", (Object)StringTools.titleToKebabCase((String)"Kebab Case"));
        Assert.assertEquals((Object)"hellokebab-case", (Object)StringTools.titleToKebabCase((String)"HELLOKebab Case"));
        Assert.assertEquals((Object)"hello-kebab-case", (Object)StringTools.titleToKebabCase((String)" HELLO Kebab Case"));
        Assert.assertEquals((Object)"MeepMan", (Object)StringTools.titleToPascalCase((String)"meep man"));
        Assert.assertEquals((Object)"meepMan", (Object)StringTools.titleToCamelCase((String)"meep man"));
        Assert.assertEquals((Object)"camelCase", (Object)StringTools.titleToCamelCase((String)"Camel case"));
        Assert.assertEquals((Object)"gpuPlanarRegions", (Object)StringTools.titleToCamelCase((String)"GPU planar regions"));
    }
}

