/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.robotics.Assert;
import us.ihmc.tools.io.StreamGobbler;

public class StreamGobblerTest {
    @Test
    public void testStreamGobblerWithASingleLine() throws IOException {
        String string = "This is some input! Yep, this is one fine line of input!";
        byte[] bytes = string.getBytes("UTF-8");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        Assert.assertEquals((long)bytes.length, (long)((InputStream)inputStream).available());
        StreamGobbler streamGobbler = new StreamGobbler((InputStream)inputStream, printStream);
        streamGobbler.start();
        while (streamGobbler.isAlive()) {
            ThreadTools.sleep((long)10L);
        }
        byte[] returnBytes = byteArrayOutputStream.toByteArray();
        String returnString = new String(returnBytes, "UTF-8");
        Assert.assertTrue((boolean)returnString.startsWith(string));
        Assert.assertEquals((long)0L, (long)((InputStream)inputStream).available());
    }

    @Test
    public void testStreamGobblerToGobbleMultipleLines() throws IOException {
        String string = "This is some input! \nHere's a second line of input!";
        byte[] bytes = string.getBytes("UTF-8");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        Assert.assertEquals((long)bytes.length, (long)((InputStream)inputStream).available());
        StreamGobbler streamGobbler = new StreamGobbler((InputStream)inputStream);
        streamGobbler.start();
        while (streamGobbler.isAlive()) {
            ThreadTools.sleep((long)10L);
        }
        Assert.assertEquals((long)0L, (long)((InputStream)inputStream).available());
    }
}

