/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io.files;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.nio.FileTools;
import us.ihmc.commons.nio.WriteOption;
import us.ihmc.robotics.Assert;
import us.ihmc.tools.io.files.DeprecatedFileTools;

public class DeprecatedFileToolsTest {
    private static final Path FILE_TOOLS_TEST_PATH = DeprecatedFileToolsTest.getResourcesPathForTestClass(DeprecatedFileToolsTest.class);
    private static final Path TEXT_DIRECTORY_PATH = FILE_TOOLS_TEST_PATH.resolve("exampleTextFiles");
    private static final Path JAVA_DIRECTORY_PATH = FILE_TOOLS_TEST_PATH.resolve("exampleJavaFiles");
    private static final Path EMPTY_DIRECTORY_PATH = FILE_TOOLS_TEST_PATH.resolve("exampleEmptyFiles");
    private static final String EXAMPLE_FILE_1_TEXT_LINE_1 = "This is example File 1 !!&&#))(";
    private static final String EXAMPLE_FILE_2_TEXT_LINE_1 = "This is example File 2 *@&&%*@";
    private static final String EXAMPLE_FILE_2_TEXT_LINE_2 = "It has two lines";
    private static final String EXAMPLE_JAVA_FILE1_JAVA = "ExampleJavaFile1.java.txt";
    private static final String EXAMPLE_JAVA_FILE2_JAVA = "ExampleJavaFile2.java.txt";
    private static final String TEST_FILE_BAD_TXT = "testFileBad.txt";
    private static final String FILE_TOOLS_EXAMPLE_FILE_CAT_TXT = "FileToolsExampleFileCat.txt";
    private static final String FILE_TOOLS_EXAMPLE_FILE1_TXT = "FileToolsExampleFile1.txt";
    private static final String FILE_TOOLS_EXAMPLE_FILE2_TXT = "FileToolsExampleFile2.txt";
    private static final String TEST_READ_ALL_LINES_TXT = "testReadAllLines.txt";
    private static final Path EXAMPLE_JAVA_FILE1_PATH = JAVA_DIRECTORY_PATH.resolve("ExampleJavaFile1.java.txt");
    private static final Path EXAMPLE_JAVA_FILE2_PATH = JAVA_DIRECTORY_PATH.resolve("ExampleJavaFile2.java.txt");
    private static final Path FILE_TOOLS_EXAMPLE_FILE1_PATH = TEXT_DIRECTORY_PATH.resolve("FileToolsExampleFile1.txt");
    private static final Path FILE_TOOLS_EXAMPLE_FILE2_PATH = TEXT_DIRECTORY_PATH.resolve("FileToolsExampleFile2.txt");
    private static final Path READ_ALL_LINES_PATH = FILE_TOOLS_TEST_PATH.resolve("testReadAllLines.txt");

    @BeforeEach
    public void setUp() {
        FileTools.ensureDirectoryExists((Path)FILE_TOOLS_TEST_PATH, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        FileTools.ensureDirectoryExists((Path)TEXT_DIRECTORY_PATH, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        FileTools.ensureDirectoryExists((Path)JAVA_DIRECTORY_PATH, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        FileTools.ensureDirectoryExists((Path)EMPTY_DIRECTORY_PATH, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        DeprecatedFileToolsTest.createJavaFile1();
        DeprecatedFileToolsTest.createJavaFile2();
        DeprecatedFileToolsTest.createTestFile1();
        DeprecatedFileToolsTest.createTestFile2();
        DeprecatedFileToolsTest.createReadAllLinesFile();
    }

    @AfterEach
    public void tearDown() {
        FileTools.deleteQuietly((Path)EXAMPLE_JAVA_FILE1_PATH);
        FileTools.deleteQuietly((Path)EXAMPLE_JAVA_FILE2_PATH);
        FileTools.deleteQuietly((Path)FILE_TOOLS_EXAMPLE_FILE1_PATH);
        FileTools.deleteQuietly((Path)FILE_TOOLS_EXAMPLE_FILE2_PATH);
        FileTools.deleteQuietly((Path)READ_ALL_LINES_PATH);
    }

    private static Path getResourcesPathForTestClass(Class<?> clazz) {
        ArrayList<String> pathNames = new ArrayList<String>();
        String[] packageNames = clazz.getPackage().getName().split("\\.");
        pathNames.addAll(Arrays.asList(packageNames));
        pathNames.add(StringUtils.uncapitalize((String)clazz.getSimpleName()));
        return Paths.get("testResources", pathNames.toArray(new String[0]));
    }

    private static void createTestFile1() {
        PrintWriter writer = FileTools.newPrintWriter((Path)FILE_TOOLS_EXAMPLE_FILE1_PATH, (WriteOption)WriteOption.TRUNCATE, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        writer.println(EXAMPLE_FILE_1_TEXT_LINE_1);
        writer.flush();
        writer.close();
    }

    private static void createTestFile2() {
        PrintWriter writer = FileTools.newPrintWriter((Path)FILE_TOOLS_EXAMPLE_FILE2_PATH, (WriteOption)WriteOption.TRUNCATE, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        writer.println(EXAMPLE_FILE_2_TEXT_LINE_1);
        writer.println(EXAMPLE_FILE_2_TEXT_LINE_2);
        writer.flush();
        writer.close();
    }

    private static void createJavaFile1() {
        PrintWriter writer = FileTools.newPrintWriter((Path)EXAMPLE_JAVA_FILE1_PATH, (WriteOption)WriteOption.TRUNCATE, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        writer.println("// This is a comment");
        writer.println("package us.ihmc.tools.io.files.fileToolsTest.exampleJavaFiles;");
        writer.println("public class ExampleJavaFile1");
        writer.println("{");
        writer.println("public static void main(String[] args)");
        writer.println("{");
        writer.println("System.out.println(\"Hello, World!\");");
        writer.println("}");
        writer.println("}");
        writer.println("// So is this");
        writer.flush();
        writer.close();
    }

    private static void createJavaFile2() {
        PrintWriter writer = FileTools.newPrintWriter((Path)EXAMPLE_JAVA_FILE2_PATH, (WriteOption)WriteOption.TRUNCATE, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        writer.println("package us.ihmc.tools.io.files.fileToolsTest.exampleJavaFiles;");
        writer.println("public class ExampleJavaFile2");
        writer.println("{");
        writer.println("public static void main(String[] args)");
        writer.println("{");
        writer.println("System.out.println(\"Hello, World!\");");
        writer.println("}");
        writer.println("}");
        writer.flush();
        writer.close();
    }

    private static void createReadAllLinesFile() {
        PrintWriter writer = FileTools.newPrintWriter((Path)READ_ALL_LINES_PATH, (WriteOption)WriteOption.TRUNCATE, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        writer.print("line1\r\nline2\nline3\r");
        writer.close();
    }

    @Test
    public void testGetBufferedReader() {
        File testFile1 = FILE_TOOLS_EXAMPLE_FILE1_PATH.toFile();
        if (!testFile1.exists()) {
            DeprecatedFileToolsTest.createTestFile1();
        }
        try {
            BufferedReader reader = DeprecatedFileTools.getFileReader((String)testFile1.getAbsolutePath());
            Assert.assertNotNull((Object)reader);
            reader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            Assert.fail();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testGetBufferedReaderWithFileNotFoundException() throws FileNotFoundException {
        Assertions.assertThrows(FileNotFoundException.class, () -> DeprecatedFileTools.getFileReader((String)TEST_FILE_BAD_TXT));
    }

    @Test
    public void testGetFileWriter() {
        File testFile1 = FILE_TOOLS_EXAMPLE_FILE1_PATH.toFile();
        if (!testFile1.exists()) {
            DeprecatedFileToolsTest.createTestFile1();
        }
        try {
            PrintWriter writer = DeprecatedFileTools.getFileWriter((String)testFile1.getAbsolutePath());
            Assert.assertNotNull((Object)writer);
            writer.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            Assert.fail();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail();
        }
        testFile1.delete();
        DeprecatedFileToolsTest.createTestFile1();
    }

    @Test
    public void testGetFileWriterWithAppend() {
        File testFile1 = FILE_TOOLS_EXAMPLE_FILE1_PATH.toFile();
        if (!testFile1.exists()) {
            DeprecatedFileToolsTest.createTestFile1();
        }
        try {
            PrintWriter writer = DeprecatedFileTools.getFileWriterWithAppend((String)testFile1.getAbsolutePath());
            Assert.assertNotNull((Object)writer);
            writer.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            Assert.fail();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail();
        }
        testFile1.delete();
        DeprecatedFileToolsTest.createTestFile1();
    }

    @Test
    public void testGetFileDataOutputStream() {
        File testFile1 = FILE_TOOLS_EXAMPLE_FILE1_PATH.toFile();
        if (!testFile1.exists()) {
            DeprecatedFileToolsTest.createTestFile1();
        }
        try {
            DataOutputStream outStream = DeprecatedFileTools.getFileDataOutputStream((String)testFile1.getAbsolutePath());
            Assert.assertNotNull((Object)outStream);
            outStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            Assert.fail();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail();
        }
        testFile1.delete();
        DeprecatedFileToolsTest.createTestFile1();
    }

    @Test
    public void testGetFileDataInputStream() {
        File testFile1 = FILE_TOOLS_EXAMPLE_FILE1_PATH.toFile();
        if (!testFile1.exists()) {
            DeprecatedFileToolsTest.createTestFile1();
        }
        try {
            DataInputStream inStream = DeprecatedFileTools.getFileDataInputStream((String)testFile1.getAbsolutePath());
            Assert.assertNotNull((Object)inStream);
            inStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            Assert.fail();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testGetFileDataInputStreamWithFileNotFoundException() throws FileNotFoundException, IOException {
        Assertions.assertThrows(FileNotFoundException.class, () -> {
            DataInputStream inStream = DeprecatedFileTools.getFileDataInputStream((String)TEST_FILE_BAD_TXT);
            inStream.close();
        });
    }

    @Test
    public void testGetAllFilesInDirectoryRecursive() {
        File directory = FILE_TOOLS_TEST_PATH.toFile();
        ArrayList listOfFiles = DeprecatedFileTools.getAllFilesInDirectoryRecursive((File)directory);
        ArrayList<String> listOfFileNames = new ArrayList<String>();
        Object errorMessage = "listOfFileNames that were found: ";
        for (File f : listOfFiles) {
            listOfFileNames.add(f.getName());
            errorMessage = (String)errorMessage + f.getName() + " ";
        }
        Assert.assertTrue((boolean)listOfFileNames.contains(FILE_TOOLS_EXAMPLE_FILE1_TXT));
        Assert.assertTrue((boolean)listOfFileNames.contains(FILE_TOOLS_EXAMPLE_FILE2_TXT));
        Assert.assertTrue((boolean)listOfFileNames.contains(EXAMPLE_JAVA_FILE1_JAVA));
        Assert.assertTrue((boolean)listOfFileNames.contains(EXAMPLE_JAVA_FILE2_JAVA));
        boolean thrown = false;
        File notADirectoryExceptionTestFile = EXAMPLE_JAVA_FILE1_PATH.toFile();
        try {
            DeprecatedFileTools.getAllFilesInDirectoryRecursive((File)notADirectoryExceptionTestFile);
        }
        catch (RuntimeException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown);
    }

    @Test
    public void testGetAllFilesInDirectoryWithSuffix() {
        File textFileDirectory = TEXT_DIRECTORY_PATH.toFile();
        File notADirectoryExceptionTestFile = EXAMPLE_JAVA_FILE1_PATH.toFile();
        File javaFileDirectory = JAVA_DIRECTORY_PATH.toFile();
        ArrayList textFiles = DeprecatedFileTools.getAllFilesInDirectoryWithSuffix((String)"txt", (File)textFileDirectory);
        ArrayList javaFiles = DeprecatedFileTools.getAllFilesInDirectoryWithSuffix((String)"java.txt", (File)javaFileDirectory);
        ArrayList<String> listOfTextFileNames = new ArrayList<String>();
        Object errorMessage = "listOfTextFileNames that were found: ";
        for (Object f : textFiles) {
            listOfTextFileNames.add(((File)f).getName());
            errorMessage = (String)errorMessage + ((File)f).getName() + " ";
        }
        Assert.assertEquals((String)errorMessage, (long)2L, (long)textFiles.size());
        ArrayList<String> listOfJavaFileNames = new ArrayList<String>();
        errorMessage = "listOfJavaFileNames that were found: ";
        for (File f : javaFiles) {
            listOfJavaFileNames.add(f.getName());
            errorMessage = (String)errorMessage + f.getName();
        }
        Assert.assertEquals((String)errorMessage, (long)2L, (long)javaFiles.size());
        Assert.assertTrue((boolean)listOfTextFileNames.contains(FILE_TOOLS_EXAMPLE_FILE1_TXT));
        Assert.assertTrue((boolean)listOfTextFileNames.contains(FILE_TOOLS_EXAMPLE_FILE2_TXT));
        Assert.assertTrue((boolean)listOfJavaFileNames.contains(EXAMPLE_JAVA_FILE1_JAVA));
        Assert.assertTrue((boolean)listOfJavaFileNames.contains(EXAMPLE_JAVA_FILE2_JAVA));
        boolean thrown = false;
        try {
            DeprecatedFileTools.getAllFilesInDirectoryWithSuffix((String)"txt", (File)notADirectoryExceptionTestFile);
        }
        catch (RuntimeException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown);
        File emptyDirectory = EMPTY_DIRECTORY_PATH.toFile();
        ArrayList testEmptyDir = DeprecatedFileTools.getAllFilesInDirectoryWithSuffix((String)"*", (File)emptyDirectory);
        Assert.assertEquals((long)0L, (long)testEmptyDir.size());
    }
}

