/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.vr;

import imgui.ImGui;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.rdx.imgui.ImGuiTools;
import us.ihmc.rdx.imgui.ImGuiUniqueLabelMap;
import us.ihmc.rdx.input.ImGui3DViewInput;
import us.ihmc.rdx.input.ImGui3DViewPickResult;
import us.ihmc.rdx.input.ImGuiMouseDragData;
import us.ihmc.rdx.tools.RDXModelInstance;
import us.ihmc.rdx.ui.RDX3DPanel;
import us.ihmc.rdx.ui.RDXBaseUI;
import us.ihmc.rdx.vr.RDXVRContext;
import us.ihmc.rdx.vr.RDXVRTracker;
import us.ihmc.robotics.interaction.SixDoFSelection;
import us.ihmc.robotics.interaction.SphereRayIntersection;
import us.ihmc.scs2.definition.visual.ColorDefinitions;

public class RDXVRTrackerRoleManager {
    private final RDXVRTracker tracker;
    private final RDXVRContext vrContext;
    private final Map<String, Boolean> roleActivationMap = new HashMap<String, Boolean>();
    private final ImGuiUniqueLabelMap labels = new ImGuiUniqueLabelMap(this.getClass());
    private final Map<String, Boolean> changedColorRoleButton = new HashMap<String, Boolean>();
    private boolean queuePopupToOpen = false;
    private boolean isTrackerHovered = false;
    private final ImGui3DViewPickResult pickResult = new ImGui3DViewPickResult();
    private final Point3D closestCollision = new Point3D();
    private SixDoFSelection closestCollisionSelection = null;
    private double closestCollisionDistance;
    private final SphereRayIntersection boundingSphereIntersection = new SphereRayIntersection();
    private final SphereRayIntersection modelSphereIntersection = new SphereRayIntersection();
    private final RDXModelInstance uninitializedModelInstance;

    public RDXVRTrackerRoleManager(RDXVRContext vrContext, RDXVRTracker tracker) {
        this.tracker = tracker;
        this.vrContext = vrContext;
        RDX3DPanel panel3D = RDXBaseUI.getInstance().getPrimary3DPanel();
        panel3D.addImGui3DViewPickCalculator(this::calculate3DViewPick);
        panel3D.addImGui3DViewInputProcessor(this::process3DViewInput);
        panel3D.addImGuiOverlayAddition(this::renderTooltipAndContextMenu);
        SortedSet<String> roles = vrContext.getAvailableTrackerRoles();
        roles.forEach(role -> this.roleActivationMap.put((String)role, false));
        roles.forEach(role -> this.changedColorRoleButton.put((String)role, false));
        this.uninitializedModelInstance = new RDXModelInstance(tracker.getModelInstance().model);
        this.uninitializedModelInstance.setColor(ColorDefinitions.Red());
        this.uninitializedModelInstance.setOpacity(0.5f);
    }

    public void calculate3DViewPick(ImGui3DViewInput input) {
        boolean isWindowHovered = imgui.internal.ImGui.isWindowHovered();
        ImGuiMouseDragData manipulationDragData = input.getMouseDragData(0);
        if (isWindowHovered && (!manipulationDragData.isDragging() || manipulationDragData.getDragJustStarted())) {
            Line3DReadOnly pickRay = input.getPickRayInWorld();
            this.determineCurrentSelectionFromPickRay(pickRay);
            if (this.closestCollisionSelection != null) {
                this.pickResult.setDistanceToCamera(this.closestCollisionDistance);
                input.addPickResult(this.pickResult);
            }
        }
    }

    private void determineCurrentSelectionFromPickRay(Line3DReadOnly pickRay) {
        this.closestCollisionSelection = null;
        this.closestCollisionDistance = Double.POSITIVE_INFINITY;
        this.boundingSphereIntersection.update(0.2, (RigidBodyTransformReadOnly)this.tracker.getXForwardZUpTrackerFrame().getTransformToWorldFrame());
        if (this.boundingSphereIntersection.intersect(pickRay)) {
            this.modelSphereIntersection.update(0.06, (RigidBodyTransformReadOnly)this.tracker.getXForwardZUpTrackerFrame().getTransformToWorldFrame());
            boolean hoveringCenterSphere = this.modelSphereIntersection.intersect(pickRay);
            double distance = this.modelSphereIntersection.getFirstIntersectionToPack().distance(pickRay.getPoint());
            if (hoveringCenterSphere && distance < this.closestCollisionDistance) {
                this.closestCollisionDistance = distance;
                this.closestCollisionSelection = SixDoFSelection.CENTER;
                this.closestCollision.set((Tuple3DReadOnly)this.modelSphereIntersection.getFirstIntersectionToPack());
            }
        }
    }

    public void process3DViewInput(ImGui3DViewInput input) {
        this.isTrackerHovered = this.pickResult == input.getClosestPick();
        this.uninitializedModelInstance.setOpacity(this.isTrackerHovered ? 1.0f : 0.5f);
        if (this.isTrackerHovered && input.mouseReleasedWithoutDrag(1)) {
            this.queuePopupToOpen = true;
        }
    }

    private void renderTooltipAndContextMenu() {
        if (this.queuePopupToOpen) {
            this.queuePopupToOpen = false;
            imgui.internal.ImGui.openPopup((String)this.labels.get("Popup"));
        }
        if (imgui.internal.ImGui.beginPopup((String)this.labels.get("Popup"))) {
            String formattedText = String.format("Tracker %s Role: ", this.tracker.getSerialNumber());
            ImGui.text((String)formattedText);
            for (Map.Entry<String, Boolean> role : this.roleActivationMap.entrySet()) {
                if (!this.vrContext.getAvailableTrackerRoles().contains(role.getKey()) && !this.roleActivationMap.get(role.getKey()).booleanValue()) continue;
                this.changedColorRoleButton.replace(role.getKey(), false);
                if (role.getValue().booleanValue()) {
                    ImGui.pushStyleColor((int)21, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.5f);
                    this.changedColorRoleButton.replace(role.getKey(), true);
                }
                if (ImGui.button((String)(this.labels.get(role.getKey()) + "##Role"), (float)100.0f, (float)0.0f)) {
                    role.setValue(role.getValue() == false);
                    if (role.getValue().booleanValue()) {
                        this.vrContext.setTrackerRole(role.getKey(), this.tracker.getDeviceIndex());
                        this.vrContext.setTrackerRoleAsUnavailable(role.getKey());
                        this.roleActivationMap.forEach((otherRoleKey, isActive) -> {
                            if (!otherRoleKey.equals(role.getKey()) && isActive.booleanValue()) {
                                this.roleActivationMap.put((String)otherRoleKey, false);
                                this.vrContext.setTrackerRoleAsAvailable((String)otherRoleKey);
                            }
                        });
                    } else {
                        this.vrContext.setTrackerRoleAsAvailable(role.getKey());
                    }
                }
                if (!this.changedColorRoleButton.get(role.getKey()).booleanValue()) continue;
                ImGui.popStyleColor();
            }
            imgui.internal.ImGui.separator();
            if (ImGui.button((String)this.labels.get("Reset All Roles"), (float)100.0f, (float)0.0f)) {
                this.vrContext.resetTrackerRoles();
            }
            if (imgui.internal.ImGui.menuItem((String)"Close") || imgui.internal.ImGui.isKeyPressed((int)ImGuiTools.getEscapeKey())) {
                imgui.internal.ImGui.closeCurrentPopup();
            }
            imgui.internal.ImGui.endPopup();
        }
    }

    public void setActive(String roleToSet) {
        for (String role : this.roleActivationMap.keySet()) {
            this.roleActivationMap.put(role, false);
            this.changedColorRoleButton.put(role, false);
        }
        this.roleActivationMap.put(roleToSet, true);
        this.changedColorRoleButton.put(roleToSet, true);
    }

    public void reset() {
        SortedSet<String> roles = this.vrContext.getAvailableTrackerRoles();
        roles.forEach(role -> this.roleActivationMap.put((String)role, false));
        roles.forEach(role -> this.changedColorRoleButton.put((String)role, false));
    }

    public boolean isRoleAssigned() {
        for (Map.Entry<String, Boolean> role : this.roleActivationMap.entrySet()) {
            if (!role.getValue().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public RDXModelInstance getRedModelInstance() {
        this.uninitializedModelInstance.setPoseInWorldFrame((RigidBodyTransformReadOnly)this.tracker.getDeviceYUpZBackFrame().getTransformToWorldFrame());
        return this.uninitializedModelInstance;
    }

    public String getTrackerSerialNumber() {
        return this.tracker.getSerialNumber();
    }

    public String getAssignedRole() {
        for (Map.Entry<String, Boolean> roleEntry : this.roleActivationMap.entrySet()) {
            if (!roleEntry.getValue().booleanValue()) continue;
            return roleEntry.getKey();
        }
        return null;
    }
}

