/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.vr;

import com.badlogic.gdx.math.Matrix4;
import java.util.function.Consumer;
import org.lwjgl.openvr.VRSystem;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.rdx.tools.LibGDXTools;
import us.ihmc.rdx.vr.RDXVRHardwareModel;
import us.ihmc.rdx.vr.RDXVRTrackedDevice;
import us.ihmc.rdx.vr.RDXVRTrackedDevicePose;

public class RDXVRTracker
extends RDXVRTrackedDevice {
    private final RigidBodyTransformReadOnly trackerYBackZLeftXRightToXForwardZUp;
    private final ReferenceFrame xForwardZUpTrackerFrame;
    private final FramePose3D tempFramePose = new FramePose3D();
    private final RigidBodyTransform tempRigidBodyTransform = new RigidBodyTransform();

    public RDXVRTracker(ReferenceFrame vrPlayAreaYUpZBackFrame, int deviceIndex, RDXVRHardwareModel model) {
        super(vrPlayAreaYUpZBackFrame);
        this.setDeviceIndex(deviceIndex);
        this.setConnected(true);
        switch (model) {
            case FOCUS3: {
                this.trackerYBackZLeftXRightToXForwardZUp = new RigidBodyTransform((Orientation3DReadOnly)new YawPitchRoll(Math.toRadians(90.0), Math.toRadians(0.0), Math.toRadians(180.0)), (Tuple3DReadOnly)new Point3D());
                break;
            }
            default: {
                this.trackerYBackZLeftXRightToXForwardZUp = new RigidBodyTransform((Orientation3DReadOnly)new YawPitchRoll(Math.toRadians(0.0), Math.toRadians(90.0), Math.toRadians(-90.0)), (Tuple3DReadOnly)new Point3D());
            }
        }
        this.xForwardZUpTrackerFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"xForwardZUpTrackerFrame", (ReferenceFrame)this.getDeviceYUpZBackFrame(), (RigidBodyTransformReadOnly)this.trackerYBackZLeftXRightToXForwardZUp);
    }

    @Override
    public void update(RDXVRTrackedDevicePose[] trackedDevicePoses) {
        this.setConnected(this.getDeviceIndex() != -1);
        super.update(trackedDevicePoses);
        this.xForwardZUpTrackerFrame.update();
    }

    public void runIfConnected(Consumer<RDXVRTracker> runIfConnected) {
        if (this.isConnected()) {
            runIfConnected.accept(this);
        }
    }

    public void getTransformZUpToWorld(Matrix4 transform) {
        this.xForwardZUpTrackerFrame.getTransformToDesiredFrame(this.tempRigidBodyTransform, ReferenceFrame.getWorldFrame());
        LibGDXTools.toLibGDX(this.tempRigidBodyTransform, transform);
    }

    public Pose3DReadOnly getXForwardZUpPose() {
        this.tempFramePose.setToZero(this.getXForwardZUpTrackerFrame());
        this.tempFramePose.changeFrame(ReferenceFrame.getWorldFrame());
        return this.tempFramePose;
    }

    public ReferenceFrame getXForwardZUpTrackerFrame() {
        return this.xForwardZUpTrackerFrame;
    }

    public String toString() {
        return this.getModelName() + " (" + this.getDeviceIndex() + ")";
    }

    public String getSerialNumber() {
        return VRSystem.VRSystem_GetStringTrackedDeviceProperty((int)this.getDeviceIndex(), (int)1002, null);
    }
}

