/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.vr;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import org.lwjgl.openvr.InputDigitalActionData;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.rdx.tools.LibGDXTools;
import us.ihmc.rdx.tools.RDXModelBuilder;
import us.ihmc.rdx.vr.RDXVRContext;
import us.ihmc.rdx.vr.RDXVRPickPlaneYawCalculator;
import us.ihmc.robotics.referenceFrames.ReferenceFrameMissingTools;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;

public class RDXVRTeleporter {
    private static final Vector3D CHEST_TO_VR_HOME_OFFSET = new Vector3D(0.25, 0.0, 0.55);
    private static ReferenceFrame robotVRHomeReferenceFrame;
    private boolean preparingToTeleport = false;
    private ModelInstance ring;
    private ModelInstance arrow;
    private final RigidBodyTransform tempTransform = new RigidBodyTransform();
    private final RDXVRPickPlaneYawCalculator pickPlaneYawCalculator = new RDXVRPickPlaneYawCalculator();
    private final FramePose3D proposedTeleportPose = new FramePose3D();
    private final RigidBodyTransform xyYawHeadsetToTeleportTransform = new RigidBodyTransform();
    private final Color color = Color.WHITE;
    private double lastTouchpadY = Double.NaN;
    private boolean bButtonEnabled = true;
    private boolean joysticButtonEnabled = true;
    private boolean touchpadHeightEnabled = true;
    private ReferenceFrame linkBeforeCameraReferenceFrame;
    private final SideDependentList<ReferenceFrame> robotCameraReferenceFrames = new SideDependentList();

    public void create(RDXVRContext context) {
        double ringThickness = 0.005;
        double innerRadius = 0.4;
        double outerRadius = 0.5;
        this.ring = RDXModelBuilder.buildModelInstance(meshBuilder -> meshBuilder.addHollowCylinder(ringThickness, outerRadius, innerRadius, (Tuple3DReadOnly)new Point3D(), this.color), "ring");
        this.arrow = RDXModelBuilder.buildModelInstance(meshBuilder -> {
            Point3D offset = new Point3D();
            offset.setX(outerRadius + 0.05);
            YawPitchRoll orientation = new YawPitchRoll();
            orientation.setYaw(Math.toRadians(-90.0));
            orientation.setPitch(Math.toRadians(0.0));
            orientation.setRoll(Math.toRadians(-90.0));
            meshBuilder.addIsoscelesTriangularPrism(0.2, 0.2, ringThickness, (Tuple3DReadOnly)offset, (Orientation3DReadOnly)orientation, this.color);
        }, "arrow");
        context.addVRInputProcessor(this::processVRInput);
    }

    private void processVRInput(RDXVRContext vrContext) {
        vrContext.getController(RobotSide.RIGHT).runIfConnected(controller -> {
            InputDigitalActionData bButton = controller.getBButtonActionData();
            if ((this.bButtonEnabled || this.joysticButtonEnabled || this.touchpadHeightEnabled) && controller.getSelectedPick() == null && !controller.anythingElseBeingDragged(this)) {
                controller.setBButtonText("Teleport");
                InputDigitalActionData joystickButton = controller.getJoystickPressActionData();
                if (this.bButtonEnabled) {
                    if (bButton.bChanged() && bButton.bState()) {
                        this.preparingToTeleport = true;
                    } else if (this.preparingToTeleport && bButton.bChanged() && !bButton.bState()) {
                        vrContext.teleport(teleportIHMCZUpToIHMCZUpWorld -> {
                            this.xyYawHeadsetToTeleportTransform.setIdentity();
                            vrContext.getHeadset().runIfConnected(headset -> {
                                headset.getXForwardZUpHeadsetFrame().getTransformToDesiredFrame(this.xyYawHeadsetToTeleportTransform, vrContext.getTeleportFrameIHMCZUp());
                                this.xyYawHeadsetToTeleportTransform.getTranslation().setZ(0.0);
                                this.xyYawHeadsetToTeleportTransform.getRotation().setYawPitchRoll(this.xyYawHeadsetToTeleportTransform.getRotation().getYaw(), 0.0, 0.0);
                            });
                            teleportIHMCZUpToIHMCZUpWorld.set(this.xyYawHeadsetToTeleportTransform);
                            teleportIHMCZUpToIHMCZUpWorld.invert();
                            this.proposedTeleportPose.get((RigidBodyTransformBasics)this.tempTransform);
                            this.tempTransform.transform((RigidBodyTransformBasics)teleportIHMCZUpToIHMCZUpWorld);
                        });
                    }
                }
                if (this.joysticButtonEnabled) {
                    if (this.linkBeforeCameraReferenceFrame != null && controller.getJoystickIsCentered() && joystickButton.bChanged() && !joystickButton.bState()) {
                        this.snapToVRHome(vrContext);
                    } else if (this.preparingToTeleport) {
                        this.proposedTeleportPose.set(this.pickPlaneYawCalculator.calculate(controller.getPickPoseFrame(), vrContext.getTeleportFrameIHMCZUp()));
                        controller.setPickRayColliding(controller.getPickPointPose().getPosition().distance((FramePoint3DReadOnly)this.proposedTeleportPose.getPosition()));
                        this.proposedTeleportPose.get((RigidBodyTransformBasics)this.tempTransform);
                        LibGDXTools.toLibGDX(this.tempTransform, this.ring.transform);
                        LibGDXTools.toLibGDX(this.tempTransform, this.arrow.transform);
                    }
                }
                if (this.touchpadHeightEnabled) {
                    if (controller.getTouchpadTouchedActionData().bState()) {
                        double y = controller.getTouchpadActionData().y();
                        if (!Double.isNaN(this.lastTouchpadY)) {
                            double delta = y - this.lastTouchpadY;
                            vrContext.teleport(teleportIHMCZUpToIHMCZUpWorld -> teleportIHMCZUpToIHMCZUpWorld.getTranslation().addZ(delta * 0.3));
                        }
                        this.lastTouchpadY = y;
                    } else {
                        this.lastTouchpadY = Double.NaN;
                    }
                }
            }
            if (this.bButtonEnabled) {
                if (!bButton.bState()) {
                    this.preparingToTeleport = false;
                }
            } else {
                this.preparingToTeleport = false;
            }
        });
    }

    public void snapToCameraView(RDXVRContext vrContext) {
        RigidBodyTransform leftCameraFrameTransform = new RigidBodyTransform((RigidBodyTransformReadOnly)((ReferenceFrame)this.robotCameraReferenceFrames.get((Enum)RobotSide.LEFT)).getTransformToParent());
        RigidBodyTransform rightCameraFrameTransform = new RigidBodyTransform((RigidBodyTransformReadOnly)((ReferenceFrame)this.robotCameraReferenceFrames.get((Enum)RobotSide.RIGHT)).getTransformToParent());
        RigidBodyTransform leftToMidCamerasFrameTransform = new RigidBodyTransform((RigidBodyTransformReadOnly)leftCameraFrameTransform);
        rightCameraFrameTransform.getTranslation().sub((Tuple3DReadOnly)leftCameraFrameTransform.getTranslation());
        rightCameraFrameTransform.getTranslation().scale(0.5);
        leftToMidCamerasFrameTransform.getTranslation().add((Tuple3DReadOnly)rightCameraFrameTransform.getTranslation());
        leftToMidCamerasFrameTransform.getTranslation().addX(0.1);
        ReferenceFrame robotCameraReferenceFrame = ReferenceFrameMissingTools.constructFrameWithUnchangingTransformToParent((ReferenceFrame)((ReferenceFrame)this.robotCameraReferenceFrames.get((Enum)RobotSide.LEFT)).getParent(), (RigidBodyTransformReadOnly)leftToMidCamerasFrameTransform);
        vrContext.teleport(teleportIHMCZUpToIHMCZUpWorld -> {
            this.xyYawHeadsetToTeleportTransform.setIdentity();
            vrContext.getHeadset().runIfConnected(headset -> {
                headset.getXForwardZUpHeadsetFrame().getTransformToDesiredFrame(this.xyYawHeadsetToTeleportTransform, vrContext.getTeleportFrameIHMCZUp());
                this.xyYawHeadsetToTeleportTransform.getRotation().setYawPitchRoll(this.xyYawHeadsetToTeleportTransform.getRotation().getYaw(), 0.0, 0.0);
            });
            teleportIHMCZUpToIHMCZUpWorld.set(this.xyYawHeadsetToTeleportTransform);
            teleportIHMCZUpToIHMCZUpWorld.invert();
            RigidBodyTransform cameraFramePlanarTransformToWorld = new RigidBodyTransform((RigidBodyTransformReadOnly)robotCameraReferenceFrame.getTransformToWorldFrame());
            cameraFramePlanarTransformToWorld.getRotation().setYawPitchRoll(cameraFramePlanarTransformToWorld.getRotation().getYaw(), 0.0, 0.0);
            this.tempTransform.set(cameraFramePlanarTransformToWorld);
            this.tempTransform.transform((RigidBodyTransformBasics)teleportIHMCZUpToIHMCZUpWorld);
        });
    }

    public void snapToVRHome(RDXVRContext vrContext) {
        vrContext.teleport(teleportIHMCZUpToIHMCZUpWorld -> {
            this.xyYawHeadsetToTeleportTransform.setIdentity();
            vrContext.getHeadset().runIfConnected(headset -> {
                headset.getXForwardZUpHeadsetFrame().getTransformToDesiredFrame(this.xyYawHeadsetToTeleportTransform, vrContext.getTeleportFrameIHMCZUp());
                this.xyYawHeadsetToTeleportTransform.getRotation().setYawPitchRoll(this.xyYawHeadsetToTeleportTransform.getRotation().getYaw(), 0.0, 0.0);
            });
            teleportIHMCZUpToIHMCZUpWorld.set(this.xyYawHeadsetToTeleportTransform);
            teleportIHMCZUpToIHMCZUpWorld.invert();
            RigidBodyTransform vrHomeFramePlanarTransformToWorld = new RigidBodyTransform((RigidBodyTransformReadOnly)robotVRHomeReferenceFrame.getTransformToWorldFrame());
            vrHomeFramePlanarTransformToWorld.getRotation().setYawPitchRoll(vrHomeFramePlanarTransformToWorld.getRotation().getYaw(), 0.0, 0.0);
            this.tempTransform.set(vrHomeFramePlanarTransformToWorld);
            this.tempTransform.transform((RigidBodyTransformBasics)teleportIHMCZUpToIHMCZUpWorld);
        });
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        if (this.preparingToTeleport) {
            this.ring.getRenderables(renderables, pool);
            this.arrow.getRenderables(renderables, pool);
        }
    }

    public void setLinkBeforeCameraReferenceFrame(ReferenceFrame referenceFrame) {
        this.linkBeforeCameraReferenceFrame = referenceFrame;
        RigidBodyTransform chestToVRHomeTransform = new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)CHEST_TO_VR_HOME_OFFSET);
        robotVRHomeReferenceFrame = ReferenceFrameMissingTools.constructFrameWithUnchangingTransformToParent((ReferenceFrame)this.linkBeforeCameraReferenceFrame, (RigidBodyTransformReadOnly)chestToVRHomeTransform);
    }

    public void setRobotCameraReferenceFrames(ReferenceFrame leftCameraReferenceFrame, ReferenceFrame rightCameraReferenceFrame) {
        this.robotCameraReferenceFrames.put((Enum)RobotSide.LEFT, (Object)leftCameraReferenceFrame);
        this.robotCameraReferenceFrames.put((Enum)RobotSide.RIGHT, (Object)rightCameraReferenceFrame);
    }

    public static ReferenceFrame getRobotVRHomeFrame() {
        return robotVRHomeReferenceFrame;
    }

    public void setBButtonEnabled(boolean bButtonEnabled) {
        this.bButtonEnabled = bButtonEnabled;
    }

    public void setJoysticButtonEnabled(boolean joysticButtonEnabled) {
        this.joysticButtonEnabled = joysticButtonEnabled;
    }

    public void setTouchpadHeightEnabled(boolean touchpadHeightEnabled) {
        this.touchpadHeightEnabled = touchpadHeightEnabled;
    }
}

