/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.vr;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.referenceFrame.FrameLine3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.referenceFrames.MutableReferenceFrame;

public class RDXVRPickPlaneYawCalculator {
    private final FrameVector3D controllerZAxisVector = new FrameVector3D();
    private final FrameLine3D pickRay = new FrameLine3D();
    private final FramePose3D xyPlanePose = new FramePose3D();
    private final Plane3D plane = new Plane3D();
    private final Point3D planeRayIntesection = new Point3D();
    private final Point3D controllerZAxisProjectedToPlanePoint = new Point3D();
    private final Vector3D orientationDeterminationVector = new Vector3D();
    private final FramePose3D yawPose = new FramePose3D();
    private final MutableReferenceFrame yawReferenceFrame = new MutableReferenceFrame();

    public FramePose3DReadOnly calculate(ReferenceFrame controllerPickFrame, ReferenceFrame xyPlaneFrame) {
        this.controllerZAxisVector.setIncludingFrame(controllerPickFrame, (Tuple3DReadOnly)Axis3D.Z);
        this.controllerZAxisVector.changeFrame(ReferenceFrame.getWorldFrame());
        this.pickRay.setToZero(controllerPickFrame);
        this.pickRay.getDirection().set((UnitVector3DReadOnly)Axis3D.X);
        this.pickRay.changeFrame(ReferenceFrame.getWorldFrame());
        this.xyPlanePose.setToZero(xyPlaneFrame);
        this.xyPlanePose.changeFrame(ReferenceFrame.getWorldFrame());
        this.plane.getNormal().set((UnitVector3DReadOnly)Axis3D.Z);
        this.plane.getPoint().set((Tuple3DReadOnly)this.xyPlanePose.getPosition());
        this.plane.intersectionWith((Line3DReadOnly)this.pickRay, (Point3DBasics)this.planeRayIntesection);
        this.controllerZAxisProjectedToPlanePoint.set(this.planeRayIntesection);
        this.controllerZAxisProjectedToPlanePoint.add((Tuple3DReadOnly)this.controllerZAxisVector);
        this.plane.orthogonalProjection((Point3DBasics)this.controllerZAxisProjectedToPlanePoint);
        this.orientationDeterminationVector.sub((Tuple3DReadOnly)this.controllerZAxisProjectedToPlanePoint, (Tuple3DReadOnly)this.planeRayIntesection);
        this.yawPose.getPosition().set((Tuple3DReadOnly)this.planeRayIntesection);
        EuclidGeometryTools.orientation3DFromFirstToSecondVector3D((Vector3DReadOnly)Axis3D.X, (Vector3DReadOnly)this.orientationDeterminationVector, (Orientation3DBasics)this.yawPose.getOrientation());
        this.yawPose.get((RigidBodyTransformBasics)this.yawReferenceFrame.getTransformToParent());
        this.yawReferenceFrame.getReferenceFrame().update();
        return this.yawPose;
    }

    public ReferenceFrame getYawReferenceFrame() {
        return this.yawReferenceFrame.getReferenceFrame();
    }
}

