/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.vr;

import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.graphics.g3d.model.NodePart;
import com.badlogic.gdx.graphics.glutils.PixmapTextureData;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.ObjectMap;
import net.mgsx.gltf.scene3d.attributes.PBRTextureAttribute;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openvr.RenderModel;
import org.lwjgl.openvr.RenderModelTextureMap;
import org.lwjgl.openvr.RenderModelVertex;
import org.lwjgl.openvr.VRRenderModels;

public class RDXVRModelLoader {
    private static final ObjectMap<String, Model> models = new ObjectMap();

    public static Model loadRenderModel(String name) {
        if (models.containsKey((Object)name)) {
            return (Model)models.get((Object)name);
        }
        int error = 0;
        PointerBuffer modelPointer = PointerBuffer.allocateDirect((int)1);
        while ((error = VRRenderModels.VRRenderModels_LoadRenderModel_Async((CharSequence)name, (PointerBuffer)modelPointer)) == 100) {
        }
        if (error != 0) {
            return null;
        }
        RenderModel renderModel = new RenderModel(modelPointer.getByteBuffer(RenderModel.SIZEOF));
        error = 0;
        PointerBuffer texturePointer = PointerBuffer.allocateDirect((int)1);
        while ((error = VRRenderModels.VRRenderModels_LoadTexture_Async((int)renderModel.diffuseTextureId(), (PointerBuffer)texturePointer)) == 100) {
        }
        if (error != 0) {
            VRRenderModels.VRRenderModels_FreeRenderModel((RenderModel)renderModel);
            return null;
        }
        RenderModelTextureMap renderModelTexture = new RenderModelTextureMap(texturePointer.getByteBuffer(RenderModelTextureMap.SIZEOF));
        Mesh mesh = new Mesh(true, renderModel.unVertexCount(), renderModel.unTriangleCount() * 3, new VertexAttribute[]{VertexAttribute.Position(), VertexAttribute.Normal(), VertexAttribute.TexCoords((int)0)});
        MeshPart meshPart = new MeshPart(name, mesh, 0, renderModel.unTriangleCount() * 3, 4);
        RenderModelVertex.Buffer vertices = renderModel.rVertexData();
        float[] packedVertices = new float[8 * renderModel.unVertexCount()];
        int i = 0;
        while (vertices.remaining() > 0) {
            RenderModelVertex v = (RenderModelVertex)vertices.get();
            packedVertices[i++] = v.vPosition().v(0);
            packedVertices[i++] = v.vPosition().v(1);
            packedVertices[i++] = v.vPosition().v(2);
            packedVertices[i++] = v.vNormal().v(0);
            packedVertices[i++] = v.vNormal().v(1);
            packedVertices[i++] = v.vNormal().v(2);
            packedVertices[i++] = v.rfTextureCoord().get(0);
            packedVertices[i++] = v.rfTextureCoord().get(1);
        }
        mesh.setVertices(packedVertices);
        short[] indices = new short[renderModel.unTriangleCount() * 3];
        renderModel.IndexData().get(indices);
        mesh.setIndices(indices);
        Pixmap pixmap = new Pixmap((int)renderModelTexture.unWidth(), (int)renderModelTexture.unHeight(), Pixmap.Format.RGBA8888);
        byte[] pixels = new byte[renderModelTexture.unWidth() * renderModelTexture.unHeight() * 4];
        renderModelTexture.rubTextureMapData(pixels.length).get(pixels);
        pixmap.getPixels().put(pixels);
        pixmap.getPixels().position(0);
        Texture texture = new Texture((TextureData)new PixmapTextureData(pixmap, pixmap.getFormat(), true, true));
        Material material = new Material(new Attribute[]{PBRTextureAttribute.createBaseColorTexture((Texture)texture)});
        Model model = new Model();
        model.meshes.add((Object)mesh);
        model.meshParts.add((Object)meshPart);
        model.materials.add((Object)material);
        Node node = new Node();
        node.id = name;
        node.parts.add((Object)new NodePart(meshPart, material));
        model.nodes.add((Object)node);
        model.manageDisposable((Disposable)mesh);
        model.manageDisposable((Disposable)texture);
        VRRenderModels.VRRenderModels_FreeRenderModel((RenderModel)renderModel);
        VRRenderModels.VRRenderModels_FreeTexture((RenderModelTextureMap)renderModelTexture);
        models.put((Object)name, (Object)model);
        return model;
    }
}

