/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.vr;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.Pool;
import java.nio.LongBuffer;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.lwjgl.openvr.InputAnalogActionData;
import org.lwjgl.openvr.InputDigitalActionData;
import org.lwjgl.openvr.InputOriginInfo;
import org.lwjgl.openvr.VRInput;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameLine3D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.rdx.imgui.ImGuiRigidBodyTransformTuner;
import us.ihmc.rdx.tools.LibGDXTools;
import us.ihmc.rdx.tools.RDXModelBuilder;
import us.ihmc.rdx.tools.RDXModelInstance;
import us.ihmc.rdx.vr.RDXVRControllerButtonLabel;
import us.ihmc.rdx.vr.RDXVRControllerRadialMenu;
import us.ihmc.rdx.vr.RDXVRDragData;
import us.ihmc.rdx.vr.RDXVRHardwareModel;
import us.ihmc.rdx.vr.RDXVRPickResult;
import us.ihmc.rdx.vr.RDXVRTrackedDevice;
import us.ihmc.rdx.vr.RDXVRTrackedDevicePose;
import us.ihmc.robotics.referenceFrames.MutableReferenceFrame;
import us.ihmc.robotics.robotSide.RobotSide;

public class RDXVRController
extends RDXVRTrackedDevice {
    public static final double GRIP_AS_BUTTON_THRESHOLD = 0.7;
    public static final double JOYSTICK_ZERO_THRESHOLD = 0.3;
    private final RobotSide side;
    private RDXVRHardwareModel model;
    private final LongBuffer inputSourceHandle = BufferUtils.newLongBuffer((int)1);
    private InputOriginInfo.Buffer inputOriginInfo;
    private final LongBuffer clickTriggerActionHandle = BufferUtils.newLongBuffer((int)1);
    private InputDigitalActionData clickTriggerActionData;
    private final LongBuffer triggerTouchedActionHandle = BufferUtils.newLongBuffer((int)1);
    private InputDigitalActionData triggerTouchedActionData;
    private final LongBuffer triggerActionHandle = BufferUtils.newLongBuffer((int)1);
    private InputAnalogActionData triggerActionData;
    private final LongBuffer aButtonActionHandle = BufferUtils.newLongBuffer((int)1);
    private InputDigitalActionData aButtonActionData;
    private final LongBuffer aTouchedActionHandle = BufferUtils.newLongBuffer((int)1);
    private InputDigitalActionData aTouchedActionData;
    private final LongBuffer bButtonActionHandle = BufferUtils.newLongBuffer((int)1);
    private InputDigitalActionData bButtonActionData;
    private final LongBuffer bButtonDoubleClickActionHandle = BufferUtils.newLongBuffer((int)1);
    private InputDigitalActionData bButtonDoubleClickActionData;
    private final LongBuffer bTouchedActionHandle = BufferUtils.newLongBuffer((int)1);
    private InputDigitalActionData bTouchedActionData;
    private final LongBuffer joystickPressActionHandle = BufferUtils.newLongBuffer((int)1);
    private InputDigitalActionData joystickPressActionData;
    private final LongBuffer touchpadTouchedActionHandle = BufferUtils.newLongBuffer((int)1);
    private InputDigitalActionData touchpadTouchedActionData;
    private final LongBuffer touchpadActionHandle = BufferUtils.newLongBuffer((int)1);
    private InputAnalogActionData touchpadActionData;
    private final LongBuffer joystickActionHandle = BufferUtils.newLongBuffer((int)1);
    private InputAnalogActionData joystickActionData;
    private boolean joystickIsCentered = false;
    private final RDXVRControllerRadialMenu radialMenu;
    private final LongBuffer gripActionHandle = BufferUtils.newLongBuffer((int)1);
    private InputAnalogActionData gripActionData;
    private boolean gripAsButtonDown = false;
    private static final RigidBodyTransformReadOnly controllerYBackZLeftXRightToXForwardZUp = new RigidBodyTransform((Orientation3DReadOnly)new YawPitchRoll(Math.toRadians(90.0), Math.toRadians(135.0), Math.toRadians(0.0)), (Tuple3DReadOnly)new Point3D());
    private final ReferenceFrame xForwardZUpControllerFrame;
    private final FramePose3D tempFramePose = new FramePose3D();
    private final RigidBodyTransform tempRigidBodyTransform = new RigidBodyTransform();
    private final FramePose3D pickPoseFramePose = new FramePose3D();
    private final MutableReferenceFrame pickPoseFrame;
    private final ImGuiRigidBodyTransformTuner pickPoseTransformTuner;
    private final ArrayList<RDXVRPickResult> pickResults = new ArrayList();
    private RDXVRPickResult selectedPick;
    private final FrameLine3D pickRay = new FrameLine3D();
    private final FramePoint3D pickCollisionPoint = new FramePoint3D();
    private RDXModelInstance pickPoseSphere;
    private RDXModelInstance pickRayGraphic;
    private RDXModelInstance pickRayCollisionPointGraphic;
    private RDXVRControllerButtonLabel aButtonLabel;
    private RDXVRControllerButtonLabel bButtonLabel;
    private RDXVRControllerButtonLabel selectedPickLabel;
    private RDXVRControllerButtonLabel gripAmountLabel;
    private final RDXVRDragData triggerDragData;
    private final RDXVRDragData gripDragData;

    public RDXVRController(RDXVRHardwareModel model, RobotSide side, ReferenceFrame vrPlayAreaYUpZBackFrame) {
        super(vrPlayAreaYUpZBackFrame);
        this.model = model;
        this.side = side;
        this.xForwardZUpControllerFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)(side.getLowerCaseName() + "_xForwardZUpControllerFrame"), (ReferenceFrame)this.getDeviceYUpZBackFrame(), (RigidBodyTransformReadOnly)controllerYBackZLeftXRightToXForwardZUp);
        this.pickPoseFrame = new MutableReferenceFrame(this.xForwardZUpControllerFrame);
        this.pickPoseFrame.getTransformToParent().getTranslation().setX(0.029);
        this.pickPoseFrame.getTransformToParent().getTranslation().setY(side.negateIfLeftSide(0.02));
        this.pickPoseFrame.getTransformToParent().getTranslation().setZ(-0.017);
        this.pickPoseFrame.getReferenceFrame().update();
        this.pickPoseTransformTuner = new ImGuiRigidBodyTransformTuner(this.pickPoseFrame.getTransformToParent());
        this.triggerDragData = new RDXVRDragData(() -> this.getClickTriggerActionData().bState(), this.pickPoseFrame.getReferenceFrame());
        this.gripDragData = new RDXVRDragData(this::getGripAsButtonDown, this.pickPoseFrame.getReferenceFrame());
        this.radialMenu = new RDXVRControllerRadialMenu(side, this.xForwardZUpControllerFrame);
    }

    public void initSystem() {
        this.inputOriginInfo = InputOriginInfo.create((int)1);
        VRInput.VRInput_GetInputSourceHandle((CharSequence)("/user/hand/" + this.side.getLowerCaseName()), (LongBuffer)this.inputSourceHandle);
        VRInput.VRInput_GetActionHandle((CharSequence)("/actions/main/in/" + this.side.getLowerCaseName() + "_clicktrigger"), (LongBuffer)this.clickTriggerActionHandle);
        this.clickTriggerActionData = InputDigitalActionData.create();
        VRInput.VRInput_GetActionHandle((CharSequence)("/actions/main/in/" + this.side.getLowerCaseName() + "_triggertouched"), (LongBuffer)this.triggerTouchedActionHandle);
        this.triggerTouchedActionData = InputDigitalActionData.create();
        VRInput.VRInput_GetActionHandle((CharSequence)("/actions/main/in/" + this.side.getLowerCaseName() + "_trigger"), (LongBuffer)this.triggerActionHandle);
        this.triggerActionData = InputAnalogActionData.create();
        VRInput.VRInput_GetActionHandle((CharSequence)("/actions/main/in/" + this.side.getLowerCaseName() + "_abutton"), (LongBuffer)this.aButtonActionHandle);
        this.aButtonActionData = InputDigitalActionData.create();
        VRInput.VRInput_GetActionHandle((CharSequence)("/actions/main/in/" + this.side.getLowerCaseName() + "_atouched"), (LongBuffer)this.aTouchedActionHandle);
        this.aTouchedActionData = InputDigitalActionData.create();
        VRInput.VRInput_GetActionHandle((CharSequence)("/actions/main/in/" + this.side.getLowerCaseName() + "_bbutton"), (LongBuffer)this.bButtonActionHandle);
        this.bButtonActionData = InputDigitalActionData.create();
        VRInput.VRInput_GetActionHandle((CharSequence)("/actions/main/in/" + this.side.getLowerCaseName() + "_bbuttondoubleclick"), (LongBuffer)this.bButtonDoubleClickActionHandle);
        this.bButtonDoubleClickActionData = InputDigitalActionData.create();
        VRInput.VRInput_GetActionHandle((CharSequence)("/actions/main/in/" + this.side.getLowerCaseName() + "_btouched"), (LongBuffer)this.bTouchedActionHandle);
        this.bTouchedActionData = InputDigitalActionData.create();
        VRInput.VRInput_GetActionHandle((CharSequence)("/actions/main/in/" + this.side.getLowerCaseName() + "_joystickpress"), (LongBuffer)this.joystickPressActionHandle);
        this.joystickPressActionData = InputDigitalActionData.create();
        VRInput.VRInput_GetActionHandle((CharSequence)("/actions/main/in/" + this.side.getLowerCaseName() + "_touchpadtouched"), (LongBuffer)this.touchpadTouchedActionHandle);
        this.touchpadTouchedActionData = InputDigitalActionData.create();
        VRInput.VRInput_GetActionHandle((CharSequence)("/actions/main/in/" + this.side.getLowerCaseName() + "_touchpad"), (LongBuffer)this.touchpadActionHandle);
        this.touchpadActionData = InputAnalogActionData.create();
        VRInput.VRInput_GetActionHandle((CharSequence)("/actions/main/in/" + this.side.getLowerCaseName() + "_joystick"), (LongBuffer)this.joystickActionHandle);
        this.joystickActionData = InputAnalogActionData.create();
        VRInput.VRInput_GetActionHandle((CharSequence)("/actions/main/in/" + this.side.getLowerCaseName() + "_grip"), (LongBuffer)this.gripActionHandle);
        this.gripActionData = InputAnalogActionData.create();
    }

    @Override
    public void update(RDXVRTrackedDevicePose[] trackedDevicePoses) {
        VRInput.VRInput_GetOriginTrackedDeviceInfo((long)this.inputSourceHandle.get(0), (InputOriginInfo)((InputOriginInfo)this.inputOriginInfo.get(0)));
        this.setDeviceIndex(this.inputOriginInfo.trackedDeviceIndex());
        this.setConnected(this.getDeviceIndex() != -1);
        super.update(trackedDevicePoses);
        if (this.isConnected()) {
            if (this.pickPoseSphere == null) {
                this.pickPoseSphere = new RDXModelInstance(RDXModelBuilder.createSphere(0.0025f, new Color(-2029582337)));
                this.pickRayCollisionPointGraphic = new RDXModelInstance(RDXModelBuilder.createSphere(0.0015f, new Color(Color.WHITE)));
                LibGDXTools.hideGraphic(this.pickRayCollisionPointGraphic);
                Point3D aButtonOffset = this.side == RobotSide.LEFT ? new Point3D(-0.085, -0.01, -0.02) : new Point3D(-0.082, -0.01, -0.017);
                Point3D bButtonOffset = this.side == RobotSide.LEFT ? new Point3D(-0.07, -0.013, -0.015) : new Point3D(-0.07, -0.007, -0.008);
                Point3D selectedPickLabelOffset = this.side == RobotSide.LEFT ? new Point3D(-0.03, 0.07, -0.004) : new Point3D(-0.04, 0.04, -0.004);
                Point3D gripAmountOffset = this.side == RobotSide.LEFT ? new Point3D(-0.1, -0.0, -0.07) : new Point3D(-0.1, 0.0, -0.07);
                YawPitchRoll gripAmountOrientation = this.side == RobotSide.LEFT ? new YawPitchRoll(Math.toRadians(90.0), Math.toRadians(-37.0), Math.toRadians(90.0)) : new YawPitchRoll(Math.toRadians(-90.0), Math.toRadians(37.0), Math.toRadians(90.0));
                this.aButtonLabel = new RDXVRControllerButtonLabel(this.pickPoseFrame.getReferenceFrame(), this.side, aButtonOffset, new YawPitchRoll());
                this.bButtonLabel = new RDXVRControllerButtonLabel(this.pickPoseFrame.getReferenceFrame(), this.side, bButtonOffset, new YawPitchRoll());
                this.selectedPickLabel = new RDXVRControllerButtonLabel(this.pickPoseFrame.getReferenceFrame(), this.side, selectedPickLabelOffset, new YawPitchRoll());
                this.gripAmountLabel = new RDXVRControllerButtonLabel(this.pickPoseFrame.getReferenceFrame(), this.side, gripAmountOffset, gripAmountOrientation);
                this.radialMenu.create(this.joystickActionData, this.joystickPressActionData);
            }
            this.pickPoseFrame.getReferenceFrame().update();
            this.pickPoseFramePose.setToZero(this.pickPoseFrame.getReferenceFrame());
            this.pickPoseFramePose.changeFrame(ReferenceFrame.getWorldFrame());
            this.pickPoseSphere.setPoseInWorldFrame((RigidBodyTransformReadOnly)this.pickPoseFramePose);
            this.pickRay.setToZero(this.getPickPoseFrame());
            this.pickRay.getDirection().set((UnitVector3DReadOnly)Axis3D.X);
            this.pickRay.changeFrame(ReferenceFrame.getWorldFrame());
            this.aButtonLabel.setText("");
            this.bButtonLabel.setText("");
            this.selectedPickLabel.setText("");
            this.gripAmountLabel.setText("%.1f".formatted(Float.valueOf(this.gripActionData.x())));
            this.radialMenu.update();
        }
        VRInput.VRInput_GetDigitalActionData((long)this.clickTriggerActionHandle.get(0), (InputDigitalActionData)this.clickTriggerActionData, (long)0L);
        VRInput.VRInput_GetDigitalActionData((long)this.triggerTouchedActionHandle.get(0), (InputDigitalActionData)this.triggerTouchedActionData, (long)0L);
        VRInput.VRInput_GetAnalogActionData((long)this.triggerActionHandle.get(0), (InputAnalogActionData)this.triggerActionData, (long)0L);
        VRInput.VRInput_GetDigitalActionData((long)this.aButtonActionHandle.get(0), (InputDigitalActionData)this.aButtonActionData, (long)0L);
        VRInput.VRInput_GetDigitalActionData((long)this.aTouchedActionHandle.get(0), (InputDigitalActionData)this.aTouchedActionData, (long)0L);
        VRInput.VRInput_GetDigitalActionData((long)this.bButtonActionHandle.get(0), (InputDigitalActionData)this.bButtonActionData, (long)0L);
        VRInput.VRInput_GetDigitalActionData((long)this.bButtonDoubleClickActionHandle.get(0), (InputDigitalActionData)this.bButtonDoubleClickActionData, (long)0L);
        VRInput.VRInput_GetDigitalActionData((long)this.bTouchedActionHandle.get(0), (InputDigitalActionData)this.bTouchedActionData, (long)0L);
        VRInput.VRInput_GetDigitalActionData((long)this.joystickPressActionHandle.get(0), (InputDigitalActionData)this.joystickPressActionData, (long)0L);
        VRInput.VRInput_GetAnalogActionData((long)this.touchpadActionHandle.get(0), (InputAnalogActionData)this.touchpadActionData, (long)0L);
        VRInput.VRInput_GetDigitalActionData((long)this.touchpadTouchedActionHandle.get(0), (InputDigitalActionData)this.touchpadTouchedActionData, (long)0L);
        VRInput.VRInput_GetAnalogActionData((long)this.joystickActionHandle.get(0), (InputAnalogActionData)this.joystickActionData, (long)0L);
        VRInput.VRInput_GetAnalogActionData((long)this.gripActionHandle.get(0), (InputAnalogActionData)this.gripActionData, (long)0L);
        this.gripAsButtonDown = (double)this.gripActionData.x() > 0.7;
        this.joystickIsCentered = (double)Math.abs(this.joystickActionData.x()) < 0.3 && (double)Math.abs(this.joystickActionData.y()) < 0.3;
        this.triggerDragData.update();
        this.gripDragData.update();
        this.pickRayGraphic = null;
        if (this.pickRayCollisionPointGraphic != null) {
            LibGDXTools.hideGraphic(this.pickRayCollisionPointGraphic);
        }
        this.pickResults.clear();
    }

    public void updatePickResults() {
        this.selectedPick = null;
        for (RDXVRPickResult pickResult : this.pickResults) {
            if (this.selectedPick == null) {
                this.selectedPick = pickResult;
                continue;
            }
            if (!(pickResult.getDistanceToControllerPickPoint() < this.selectedPick.getDistanceToControllerPickPoint())) continue;
            this.selectedPick = pickResult;
        }
        if (this.selectedPick != null) {
            String pickedObjectName = this.selectedPick.getPickedObjectName();
            String labelText = !pickedObjectName.isEmpty() ? pickedObjectName : (this.selectedPick.getObjectBeingPicked() == null ? "null" : this.selectedPick.getObjectBeingPicked().getClass().getSimpleName());
            this.selectedPickLabel.setText(labelText);
            if (this.selectedPick.isHoveringNotPointingAt()) {
                this.setPickPointColliding((Point3DReadOnly)this.selectedPick.getClosestPointOnSurface());
            } else {
                this.setPickRayColliding(this.selectedPick.getDistanceToControllerPickPoint());
            }
        }
    }

    public void renderImGuiTunerWidgets() {
        this.pickPoseTransformTuner.renderTunerWithYawPitchRoll(0.001);
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        if (this.getModelInstance() != null) {
            this.getModelInstance().getRenderables(renderables, pool);
            this.pickPoseSphere.getRenderables(renderables, pool);
            this.radialMenu.getRenderables(renderables, pool);
            if (this.pickRayGraphic != null) {
                this.pickRayGraphic.getRenderables(renderables, pool);
            }
            if (this.pickRayCollisionPointGraphic != null) {
                this.pickRayCollisionPointGraphic.getRenderables(renderables, pool);
            }
            if (this.aButtonLabel != null) {
                this.aButtonLabel.getRenderables(renderables, pool);
            }
            if (this.bButtonLabel != null) {
                this.bButtonLabel.getRenderables(renderables, pool);
            }
            if (this.selectedPickLabel != null) {
                this.selectedPickLabel.getRenderables(renderables, pool);
            }
            if (this.gripAmountLabel != null) {
                this.gripAmountLabel.getRenderables(renderables, pool);
            }
        }
    }

    public void setPickRayColliding(double distance) {
        Point3D offset = new Point3D(distance / 2.0, 0.0, 0.0);
        ModelInstance pickRayBox = RDXModelBuilder.buildModelInstance(meshBuilder -> meshBuilder.addBox((float)distance, 0.001f, 0.001f, (Tuple3DReadOnly)offset, new Color(Color.WHITE)), "box");
        this.pickRayGraphic = new RDXModelInstance(pickRayBox);
        this.pickRayGraphic.setPoseInWorldFrame((RigidBodyTransformReadOnly)this.getPickPointPose());
        this.pickCollisionPoint.setToZero(this.pickPoseFrame.getReferenceFrame());
        this.pickCollisionPoint.setX(distance);
        this.pickCollisionPoint.changeFrame(ReferenceFrame.getWorldFrame());
        LibGDXTools.toLibGDX((Point3DReadOnly)this.pickCollisionPoint, this.pickRayCollisionPointGraphic.transform);
    }

    public void setPickPointColliding(Point3DReadOnly closestPointOnSurface) {
        LibGDXTools.toLibGDX(closestPointOnSurface, this.pickRayCollisionPointGraphic.transform);
    }

    public RDXVRHardwareModel getModel() {
        return this.model;
    }

    public void setModel(RDXVRHardwareModel model) {
        this.model = model;
    }

    public RDXModelInstance getPickPoseSphere() {
        return this.pickPoseSphere;
    }

    public InputDigitalActionData getClickTriggerActionData() {
        return this.clickTriggerActionData;
    }

    public InputDigitalActionData getTriggerTouchedActionData() {
        return this.triggerTouchedActionData;
    }

    public InputAnalogActionData getTriggerActionData() {
        return this.triggerActionData;
    }

    public RDXVRDragData getTriggerDragData() {
        return this.triggerDragData;
    }

    public boolean getTriggerClickReleasedWithoutDrag() {
        return this.clickTriggerActionData.bChanged() && !this.clickTriggerActionData.bState() && this.triggerDragData.isClickValid();
    }

    public InputDigitalActionData getAButtonActionData() {
        return this.aButtonActionData;
    }

    public InputDigitalActionData getATouchedActionData() {
        return this.aTouchedActionData;
    }

    public InputDigitalActionData getBButtonActionData() {
        return this.bButtonActionData;
    }

    public InputDigitalActionData getBButtonDoubleClickActionData() {
        return this.bButtonDoubleClickActionData;
    }

    public InputDigitalActionData getBTouchedActionData() {
        return this.bTouchedActionData;
    }

    public InputDigitalActionData getJoystickPressActionData() {
        return this.joystickPressActionData;
    }

    public InputAnalogActionData getTouchpadActionData() {
        return this.touchpadActionData;
    }

    public InputDigitalActionData getTouchpadTouchedActionData() {
        return this.touchpadTouchedActionData;
    }

    public InputAnalogActionData getJoystickActionData() {
        return this.joystickActionData;
    }

    public boolean getJoystickIsCentered() {
        return this.joystickIsCentered;
    }

    public InputAnalogActionData getGripActionData() {
        return this.gripActionData;
    }

    public boolean getGripAsButtonDown() {
        return this.gripAsButtonDown;
    }

    public RDXVRDragData getGripDragData() {
        return this.gripDragData;
    }

    public ReferenceFrame getXForwardZUpControllerFrame() {
        return this.xForwardZUpControllerFrame;
    }

    public void getTransformZUpToWorld(Matrix4 transform) {
        this.xForwardZUpControllerFrame.getTransformToDesiredFrame(this.tempRigidBodyTransform, ReferenceFrame.getWorldFrame());
        LibGDXTools.toLibGDX(this.tempRigidBodyTransform, transform);
    }

    public Pose3DReadOnly getXForwardZUpPose() {
        this.tempFramePose.setToZero(this.getXForwardZUpControllerFrame());
        this.tempFramePose.changeFrame(ReferenceFrame.getWorldFrame());
        return this.tempFramePose;
    }

    public void runIfConnected(Consumer<RDXVRController> runIfConnected) {
        if (this.isConnected()) {
            runIfConnected.accept(this);
        }
    }

    public void addPickResult(RDXVRPickResult pickResult) {
        this.pickResults.add(pickResult);
    }

    public RDXVRPickResult getSelectedPick() {
        return this.selectedPick;
    }

    public boolean anythingElseBeingDragged(Object callersObject) {
        boolean anythingElseBeingDragged = false;
        anythingElseBeingDragged |= this.gripDragData.isDraggingSomething() && this.gripDragData.getObjectBeingDragged() != callersObject;
        return anythingElseBeingDragged |= this.triggerDragData.isDraggingSomething() && this.triggerDragData.getObjectBeingDragged() != callersObject;
    }

    public FramePose3DReadOnly getPickPointPose() {
        return this.pickPoseFramePose;
    }

    public ReferenceFrame getPickPoseFrame() {
        return this.pickPoseFrame.getReferenceFrame();
    }

    public FrameLine3DReadOnly getPickRay() {
        return this.pickRay;
    }

    public void setAButtonText(String text) {
        this.aButtonLabel.setText(text);
    }

    public void setBButtonText(String text) {
        this.bButtonLabel.setText(text);
    }

    public RDXVRControllerRadialMenu getRadialMenu() {
        return this.radialMenu;
    }

    public String toString() {
        return this.side.getSideNameFirstLetter() + ":" + String.valueOf((Object)this.getModel());
    }
}

