/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.vr;

import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Pool;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.lwjgl.opengl.GL41;
import org.lwjgl.openvr.CompositorFrameTiming;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.openvr.Texture;
import org.lwjgl.openvr.TrackedDevicePose;
import org.lwjgl.openvr.VR;
import org.lwjgl.openvr.VRActiveActionSet;
import org.lwjgl.openvr.VRCompositor;
import org.lwjgl.openvr.VREvent;
import org.lwjgl.openvr.VRInput;
import org.lwjgl.openvr.VRSystem;
import sun.misc.Unsafe;
import us.ihmc.commons.thread.Notification;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.log.LogTools;
import us.ihmc.rdx.sceneManager.RDX3DScene;
import us.ihmc.rdx.vr.RDXVRBaseStation;
import us.ihmc.rdx.vr.RDXVRController;
import us.ihmc.rdx.vr.RDXVREye;
import us.ihmc.rdx.vr.RDXVRHardwareModel;
import us.ihmc.rdx.vr.RDXVRHeadset;
import us.ihmc.rdx.vr.RDXVRTrackedDevicePose;
import us.ihmc.rdx.vr.RDXVRTracker;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.tools.io.JSONFileTools;
import us.ihmc.tools.io.WorkspaceFile;
import us.ihmc.tools.io.WorkspaceResourceDirectory;
import us.ihmc.tools.io.WorkspaceResourceFile;

public class RDXVRContext {
    private final IntBuffer errorPointer = BufferUtils.newIntBuffer((int)1);
    private final IntBuffer widthPointer = BufferUtils.newIntBuffer((int)1);
    private final IntBuffer heightPointer = BufferUtils.newIntBuffer((int)1);
    private final SideDependentList<RDXVREye> eyes = new SideDependentList();
    private final AtomicReference<RDXVRTrackedDevicePose[]> trackedDevicePosesParsedRef = new AtomicReference();
    private TrackedDevicePose.Buffer trackedDevicePoses;
    private TrackedDevicePose.Buffer trackedDeviceGamePoses;
    private final LongBuffer mainActionSetHandle = BufferUtils.newLongBuffer((int)1);
    private VRActiveActionSet.Buffer activeActionSets;
    private VREvent event;
    private int width;
    private int height;
    private final ArrayList<Consumer<RDXVRContext>> vrPickCalculators = new ArrayList();
    private final ArrayList<Consumer<RDXVRContext>> vrInputProcessors = new ArrayList();
    private final Map<Object, Consumer<RDXVRContext>> vrPickCalculatorOwnerKeyMap = new HashMap<Object, Consumer<RDXVRContext>>();
    private final Map<Object, Consumer<RDXVRContext>> vrInputProcessorOwnerKeyMap = new HashMap<Object, Consumer<RDXVRContext>>();
    public static final RigidBodyTransformReadOnly openVRYUpToIHMCZUpSpace = new RigidBodyTransform((Orientation3DReadOnly)new YawPitchRoll(Math.toRadians(-90.0), Math.toRadians(0.0), Math.toRadians(90.0)), (Tuple3DReadOnly)new Point3D());
    private final RigidBodyTransform teleportIHMCZUpToIHMCZUpWorld = new RigidBodyTransform();
    private final ReferenceFrame teleportFrameIHMCZUp = ReferenceFrameTools.constructFrameWithChangingTransformToParent((String)"teleportFrame", (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)this.teleportIHMCZUpToIHMCZUpWorld);
    private final ReferenceFrame vrPlayAreaYUpZBackFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"vrPlayAreaFrame", (ReferenceFrame)this.teleportFrameIHMCZUp, (RigidBodyTransformReadOnly)openVRYUpToIHMCZUpSpace);
    private RDXVRHardwareModel vrModel = RDXVRHardwareModel.UNKNOWN;
    private final RDXVRHeadset headset = new RDXVRHeadset(this.vrPlayAreaYUpZBackFrame);
    private final SideDependentList<RDXVRController> controllers = new SideDependentList((Object)new RDXVRController(RDXVRHardwareModel.UNKNOWN, RobotSide.LEFT, this.vrPlayAreaYUpZBackFrame), (Object)new RDXVRController(RDXVRHardwareModel.UNKNOWN, RobotSide.RIGHT, this.vrPlayAreaYUpZBackFrame));
    private final Map<Integer, RDXVRBaseStation> baseStations = new HashMap<Integer, RDXVRBaseStation>();
    private final Map<String, RDXVRTracker> trackers = new HashMap<String, RDXVRTracker>();
    private final Map<String, String> savedTrackersRoleMap = new HashMap<String, String>();
    private final Map<String, String> trackersRoleMap = new HashMap<String, String>();
    private final SortedSet<String> availableTrackerRoles = new TreeSet<String>(){
        {
            this.add("Chest");
            this.add("Waist");
            this.add("Left Wrist");
            this.add("Right Wrist");
            this.add("Left Ankle");
            this.add("Right Ankle");
        }
    };
    private final List<String> newTrackerSerialNumber = new ArrayList<String>();
    private final List<String> removedTrackerSerialNumber = new ArrayList<String>();
    private final Notification rolesResetNotification = new Notification();
    private final Notification loadingRolesNotification = new Notification();
    private WorkspaceResourceFile trackerRolesFile;
    private double openvrInitialTime = 0.0;
    private double systemInitialTime = Double.NaN;
    private CompositorFrameTiming.Buffer latestFrameTimingBuffer = CompositorFrameTiming.create((int)1);

    public RDXVRContext() {
        RDXVRContext.getUnsafeInstance().putInt(null, this.latestFrameTimingBuffer.address() + (long)CompositorFrameTiming.M_NSIZE, this.latestFrameTimingBuffer.sizeof());
    }

    public void initSystem() {
        LogTools.info((String)"Initializing");
        this.event = VREvent.create();
        this.trackedDevicePoses = TrackedDevicePose.create((int)64);
        this.trackedDeviceGamePoses = TrackedDevicePose.create((int)64);
        int token = VR.VR_InitInternal((IntBuffer)this.errorPointer, (int)1);
        this.checkInitError(this.errorPointer);
        OpenVR.create((int)token);
        VR.VR_GetGenericInterface((CharSequence)"IVRCompositor_027", (IntBuffer)this.errorPointer);
        this.checkInitError(this.errorPointer);
        VR.VR_GetGenericInterface((CharSequence)"IVRRenderModels_006", (IntBuffer)this.errorPointer);
        this.checkInitError(this.errorPointer);
        VRSystem.VRSystem_GetRecommendedRenderTargetSize((IntBuffer)this.widthPointer, (IntBuffer)this.heightPointer);
        float renderTargetMultiplier = 1.0f;
        this.width = (int)((float)this.widthPointer.get(0) * renderTargetMultiplier);
        this.height = (int)((float)this.heightPointer.get(0) * renderTargetMultiplier);
        WorkspaceResourceDirectory directory = new WorkspaceResourceDirectory(this.getClass(), "/vr");
        WorkspaceResourceFile actionManifestFile = new WorkspaceResourceFile(directory, "actions.json");
        VRInput.VRInput_SetActionManifestPath((CharSequence)actionManifestFile.getFilesystemFile().toString());
        VRInput.VRInput_GetActionSetHandle((CharSequence)"/actions/main", (LongBuffer)this.mainActionSetHandle);
        this.headset.initSystem();
        this.trackerRolesFile = new WorkspaceResourceFile(directory, "tracker_roles.json");
        JSONFileTools.load((WorkspaceResourceFile)this.trackerRolesFile, node -> {
            for (String role : this.availableTrackerRoles) {
                this.savedTrackersRoleMap.put(role, node.get(role).asText());
            }
        });
        int[] deviceIndices = new int[64];
        for (int i = 0; i < deviceIndices.length; ++i) {
            deviceIndices[i] = i;
        }
        String modelNumber = VRSystem.VRSystem_GetStringTrackedDeviceProperty((int)0, (int)1001, null);
        this.vrModel = modelNumber.toLowerCase().contains("focus3") ? RDXVRHardwareModel.FOCUS3 : RDXVRHardwareModel.INDEX;
        LogTools.info((String)"Using VR headset/controller model: {}", (Object)((Object)this.vrModel));
        for (RDXVRController controller : this.controllers) {
            controller.setModel(this.vrModel);
            controller.initSystem();
        }
        for (Object deviceIndex : (Object)deviceIndices) {
            int deviceClass = VRSystem.VRSystem_GetTrackedDeviceClass((int)deviceIndex);
            if (deviceClass != 3 || this.trackers.containsKey(this.getSerialNumber((int)deviceIndex))) continue;
            this.trackers.put(this.getSerialNumber((int)deviceIndex), new RDXVRTracker(this.vrPlayAreaYUpZBackFrame, (int)deviceIndex, this.vrModel));
            this.newTrackerSerialNumber.add(this.getSerialNumber((int)deviceIndex));
            LogTools.info((String)"Tracker {} connected", (Object)this.getSerialNumber((int)deviceIndex));
        }
        if (!this.trackers.isEmpty()) {
            this.loadTrackerRolesFromFile();
        }
        this.activeActionSets = VRActiveActionSet.create((int)1);
        this.activeActionSets.ulActionSet(this.mainActionSetHandle.get(0));
        this.activeActionSets.ulRestrictedToDevice(0L);
    }

    public void setupEyes() {
        LogTools.info((String)"VR per eye render size: {} x {}", (Object)this.width, (Object)this.height);
        for (RobotSide side : RobotSide.values) {
            this.eyes.set((Enum)side, (Object)new RDXVREye(side, this.headset, this.width, this.height));
        }
    }

    private void checkInitError(IntBuffer errorBuffer) {
        if (errorBuffer.get(0) != 0) {
            int error = errorBuffer.get(0);
            throw new GdxRuntimeException("VR Initialization error: " + VR.VR_GetVRInitErrorAsEnglishDescription((int)error));
        }
    }

    public void waitGetPoses() {
        VRCompositor.VRCompositor_WaitGetPoses((TrackedDevicePose.Buffer)this.trackedDevicePoses, (TrackedDevicePose.Buffer)this.trackedDeviceGamePoses);
        int nRead = VRCompositor.VRCompositor_GetFrameTimings((CompositorFrameTiming.Buffer)this.latestFrameTimingBuffer);
        CompositorFrameTiming compositorFrameTiming = (CompositorFrameTiming)this.latestFrameTimingBuffer.get(0);
        double systemTimeInSeconds = compositorFrameTiming.m_flSystemTimeInSeconds();
        double newPosesReadyMs = compositorFrameTiming.m_flNewPosesReadyMs();
        double openvrTime = systemTimeInSeconds + newPosesReadyMs * 0.001;
        double systemTime = 1.0E-9 * (double)System.nanoTime();
        if (this.openvrInitialTime == 0.0) {
            this.systemInitialTime = systemTime;
            this.openvrInitialTime = openvrTime;
        }
        systemTime -= this.systemInitialTime;
        long measurementTimestamp = (long)((openvrTime -= this.openvrInitialTime) * 1.0E9);
        RDXVRTrackedDevicePose[] temp = new RDXVRTrackedDevicePose[64];
        for (int i = 0; i < temp.length; ++i) {
            temp[i] = new RDXVRTrackedDevicePose(measurementTimestamp, this.trackedDevicePoses, i);
        }
        this.trackedDevicePosesParsedRef.set(temp);
    }

    public void pollEvents() {
        RDXVRTrackedDevicePose[] newTrackedDevicePosesParsed = this.trackedDevicePosesParsedRef.getAndSet(null);
        if (newTrackedDevicePosesParsed == null) {
            return;
        }
        VRInput.VRInput_UpdateActionState((VRActiveActionSet.Buffer)this.activeActionSets, (int)VRActiveActionSet.SIZEOF);
        this.headset.update(newTrackedDevicePosesParsed);
        for (Object side : RobotSide.values) {
            ((RDXVRController)this.controllers.get((Enum)side)).update(newTrackedDevicePosesParsed);
        }
        while (VRSystem.VRSystem_PollNextEvent((VREvent)this.event)) {
            int deviceIndex = this.event.trackedDeviceIndex();
            int n = VRSystem.VRSystem_GetTrackedDeviceClass((int)deviceIndex);
            if (n != 3) continue;
            if (this.event.eventType() == 100) {
                if (this.trackers.containsKey(this.getSerialNumber(deviceIndex))) continue;
                this.trackers.put(this.getSerialNumber(deviceIndex), new RDXVRTracker(this.vrPlayAreaYUpZBackFrame, deviceIndex, this.vrModel));
                this.newTrackerSerialNumber.add(this.getSerialNumber(deviceIndex));
                LogTools.info((String)"Tracker {} connected", (Object)this.getSerialNumber(deviceIndex));
                this.loadTrackerRolesFromFile();
                continue;
            }
            if (this.event.eventType() != 101 || !this.trackers.containsKey(this.getSerialNumber(this.event.trackedDeviceIndex()))) continue;
            this.removedTrackerSerialNumber.add(this.getSerialNumber(deviceIndex));
            LogTools.warn((String)"Tracker {} disconnected", (Object)this.getSerialNumber(deviceIndex));
        }
        for (Map.Entry entry : this.trackers.entrySet()) {
            ((RDXVRTracker)entry.getValue()).update(newTrackedDevicePosesParsed);
        }
        for (Consumer consumer : this.vrPickCalculators) {
            consumer.accept(this);
        }
        for (Object side : RobotSide.values) {
            ((RDXVRController)this.controllers.get((Enum)side)).updatePickResults();
        }
        for (Consumer consumer : this.vrInputProcessors) {
            consumer.accept(this);
        }
    }

    public void renderEyes(RDX3DScene scene) {
        for (RobotSide side : RobotSide.values) {
            ((RDXVREye)((Object)this.eyes.get((Enum)side))).render(scene);
        }
        VRCompositor.VRCompositor_Submit((int)0, (Texture)((RDXVREye)((Object)this.eyes.get((Enum)RobotSide.LEFT))).getOpenVRTexture(), null, (int)0);
        VRCompositor.VRCompositor_Submit((int)1, (Texture)((RDXVREye)((Object)this.eyes.get((Enum)RobotSide.RIGHT))).getOpenVRTexture(), null, (int)0);
        GL41.glFlush();
    }

    public void dispose() {
        for (RDXVREye eyeData : this.eyes) {
            eyeData.getFrameBuffer().dispose();
        }
        VR.VR_ShutdownInternal();
    }

    public void teleport(Consumer<RigidBodyTransform> teleportIHMCZUpToIHMCZUpWorldConsumer) {
        teleportIHMCZUpToIHMCZUpWorldConsumer.accept(this.teleportIHMCZUpToIHMCZUpWorld);
        this.teleportFrameIHMCZUp.update();
    }

    public void addVRPickCalculator(Consumer<RDXVRContext> calculateVRPick) {
        this.vrPickCalculators.add(calculateVRPick);
    }

    public void addVRInputProcessor(Consumer<RDXVRContext> processVRInput) {
        this.vrInputProcessors.add(processVRInput);
    }

    public void addVRPickCalculator(Object ownerKey, Consumer<RDXVRContext> calculateVRPick) {
        this.vrPickCalculatorOwnerKeyMap.put(ownerKey, calculateVRPick);
        this.vrPickCalculators.add(calculateVRPick);
    }

    public void addVRInputProcessor(Object ownerKey, Consumer<RDXVRContext> processVRInput) {
        this.vrInputProcessorOwnerKeyMap.put(ownerKey, processVRInput);
        this.vrInputProcessors.add(processVRInput);
    }

    public void removeVRPickCalculator(Object ownerKey) {
        this.vrPickCalculators.remove(this.vrPickCalculatorOwnerKeyMap.remove(ownerKey));
    }

    public void removeVRInputProcessor(Object ownerKey) {
        this.vrInputProcessors.remove(this.vrInputProcessorOwnerKeyMap.remove(ownerKey));
    }

    public void getHeadsetRenderable(Array<Renderable> renderables, Pool<Renderable> pool) {
        ModelInstance modelInstance;
        if (this.headset.isConnected() && (modelInstance = this.headset.getModelInstance()) != null) {
            modelInstance.getRenderables(renderables, pool);
        }
    }

    public void getControllerRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        for (RobotSide side : RobotSide.values) {
            RDXVRController controller = (RDXVRController)this.controllers.get((Enum)side);
            if (!controller.isConnected()) continue;
            controller.getRenderables(renderables, pool);
        }
    }

    public void getTrackerRenderables(String serialNumber, Array<Renderable> renderables, Pool<Renderable> pool) {
        ModelInstance modelInstance = this.trackers.get(serialNumber).getModelInstance();
        if (modelInstance != null) {
            modelInstance.getRenderables(renderables, pool);
        }
    }

    public void getTrackersRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        for (Map.Entry<String, RDXVRTracker> tracker : this.trackers.entrySet()) {
            ModelInstance modelInstance = tracker.getValue().getModelInstance();
            if (modelInstance == null) continue;
            modelInstance.getRenderables(renderables, pool);
        }
    }

    public RDXVRController getController(RobotSide side) {
        return (RDXVRController)this.controllers.get((Enum)side);
    }

    public SideDependentList<RDXVRController> getControllers() {
        return this.controllers;
    }

    public RDXVRHeadset getHeadset() {
        return this.headset;
    }

    private String getSerialNumber(int index) {
        return VRSystem.VRSystem_GetStringTrackedDeviceProperty((int)index, (int)1002, null);
    }

    public void setTrackerRole(String role, int index) {
        this.trackersRoleMap.put(role, this.getSerialNumber(index));
    }

    public RDXVRTracker getTracker(String role) {
        return this.trackers.get(this.trackersRoleMap.get(role));
    }

    public Map<String, RDXVRTracker> getTrackers() {
        return this.trackers;
    }

    public Set<String> getAssignedTrackerRoles() {
        return this.trackersRoleMap.keySet();
    }

    public SortedSet<String> getAvailableTrackerRoles() {
        return this.availableTrackerRoles;
    }

    public void setTrackerRoleAsUnavailable(String role) {
        this.availableTrackerRoles.remove(role);
    }

    public void setTrackerRoleAsAvailable(String role) {
        this.availableTrackerRoles.add(role);
        this.trackersRoleMap.remove(role);
    }

    public void resetTrackerRoles() {
        this.trackersRoleMap.clear();
        this.availableTrackerRoles.clear();
        this.availableTrackerRoles.add("Chest");
        this.availableTrackerRoles.add("Waist");
        this.availableTrackerRoles.add("Left Wrist");
        this.availableTrackerRoles.add("Right Wrist");
        this.availableTrackerRoles.add("Left Ankle");
        this.availableTrackerRoles.add("Right Ankle");
        this.rolesResetNotification.set();
    }

    public void saveTrackerRolesToFile() {
        if (this.trackerRolesFile.isFileAccessAvailable()) {
            LogTools.info((String)"Saving tracker roles to file ...");
            JSONFileTools.save((WorkspaceFile)this.trackerRolesFile, jsonNode -> {
                for (String role : this.savedTrackersRoleMap.keySet()) {
                    jsonNode.put(role, this.trackersRoleMap.getOrDefault(role, ""));
                }
            });
            LogTools.info((String)"Saved to file");
        }
    }

    public void loadTrackerRolesFromFile() {
        LogTools.info((String)"Loading tracker roles from file");
        this.resetTrackerRoles();
        for (Map.Entry<String, String> roleMap : this.savedTrackersRoleMap.entrySet()) {
            if (roleMap.getValue().isEmpty() || !this.trackers.containsKey(roleMap.getValue())) continue;
            this.trackersRoleMap.put(roleMap.getKey(), roleMap.getValue());
            this.availableTrackerRoles.remove(roleMap.getKey());
        }
        this.loadingRolesNotification.set();
    }

    public Notification getRolesResetNotification() {
        return this.rolesResetNotification;
    }

    public Notification getLoadingRolesNotification() {
        return this.loadingRolesNotification;
    }

    public List<String> getNewTrackersSerialNumbers() {
        ArrayList<String> serialNumbers = new ArrayList<String>(this.newTrackerSerialNumber);
        this.newTrackerSerialNumber.clear();
        return serialNumbers;
    }

    public List<String> getRemovedTrackersSerialNumbers() {
        ArrayList<String> serialNumbers = new ArrayList<String>(this.removedTrackerSerialNumber);
        this.removedTrackerSerialNumber.clear();
        return serialNumbers;
    }

    public Map<String, String> getTrackersRoleMap() {
        return this.trackersRoleMap;
    }

    public Collection<RDXVRBaseStation> getBaseStations() {
        return this.baseStations.values();
    }

    public SideDependentList<RDXVREye> getEyes() {
        return this.eyes;
    }

    public ReferenceFrame getPlayAreaYUpFrame() {
        return this.vrPlayAreaYUpZBackFrame;
    }

    public ReferenceFrame getTeleportFrameIHMCZUp() {
        return this.teleportFrameIHMCZUp;
    }

    public RigidBodyTransform getTeleportIHMCZUpToIHMCZUpWorld() {
        return this.teleportIHMCZUpToIHMCZUpWorld;
    }

    public RDXVRHardwareModel getVRModel() {
        return this.vrModel;
    }

    private static Unsafe getUnsafeInstance() {
        Field[] fields;
        for (Field field : fields = Unsafe.class.getDeclaredFields()) {
            int modifiers;
            if (!field.getType().equals(Unsafe.class) || !Modifier.isStatic(modifiers = field.getModifiers()) || !Modifier.isFinal(modifiers)) continue;
            try {
                field.setAccessible(true);
                return (Unsafe)field.get(null);
            }
            catch (Exception exception) {
                break;
            }
        }
        throw new UnsupportedOperationException("LWJGL requires sun.misc.Unsafe to be available.");
    }
}

