/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.visualizers;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.graphics.g3d.utils.MeshBuilder;
import com.badlogic.gdx.graphics.g3d.utils.MeshPartBuilder;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import java.util.ArrayList;
import net.mgsx.gltf.scene3d.attributes.PBRColorAttribute;
import net.mgsx.gltf.scene3d.attributes.PBRTextureAttribute;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.rdx.mesh.RDXMultiColorMeshBuilder;
import us.ihmc.rdx.visualizers.RDXSplineBody;

public class RDXEdgeDefinedShapeGraphic
implements RenderableProvider {
    private ModelInstance modelInstance;
    private Model lastModel;
    private final ModelBuilder modelBuilder = new ModelBuilder();
    private volatile Runnable buildMesh = null;
    private final Material material = new Material();
    private final Point3D[][] edges;
    private final Point3D[] startPoints;
    private final Point3D[] endPoints;
    private final int numberOfSplines;
    private final int numberPointsPerSpline;
    private final ArrayList<RDXSplineBody> edgeLines = new ArrayList();
    private final Color edgeColor;
    private final float opacity;

    public RDXEdgeDefinedShapeGraphic(Point3D[][] edges, Color color, Color edgeColor, float opacity) {
        this.edges = edges;
        this.numberOfSplines = edges.length;
        this.numberPointsPerSpline = edges[0].length;
        this.startPoints = new Point3D[this.numberOfSplines];
        this.endPoints = new Point3D[this.numberOfSplines];
        for (int i = 0; i < this.numberOfSplines; ++i) {
            this.startPoints[i] = edges[i][0];
            this.endPoints[i] = edges[i][this.numberPointsPerSpline - 1];
        }
        this.opacity = opacity;
        this.edgeColor = edgeColor;
        Texture paletteTexture = RDXMultiColorMeshBuilder.loadPaletteTexture();
        this.material.set((Attribute)PBRTextureAttribute.createBaseColorTexture((Texture)paletteTexture));
        this.material.set((Attribute)PBRColorAttribute.createBaseColorFactor((Color)new Color(color.r, color.g, color.b, 1.0f)));
        this.material.set((Attribute)new BlendingAttribute(true, 770, 771, opacity));
    }

    public void update() {
        if (this.buildMesh != null) {
            this.buildMesh.run();
            this.buildMesh = null;
        }
    }

    public void generateMesh() {
        this.lastModel = this.modelBuilder.end();
        this.modelInstance = new ModelInstance(this.lastModel);
    }

    public synchronized void createMainShape() {
        this.buildMesh = () -> {
            if (this.lastModel != null) {
                this.lastModel.dispose();
            }
            this.modelBuilder.begin();
            MeshPartBuilder meshBuilder = this.modelBuilder.part("mainShape", 4, 9L, this.material);
            for (int i = 0; i < this.numberOfSplines; ++i) {
                this.edgeLines.add(new RDXSplineBody(0.01f, this.opacity));
                this.edgeLines.get(i).setColor(this.edgeColor);
                int j = (i + 1) % this.numberOfSplines;
                for (int k = 0; k < this.numberPointsPerSpline - 1; ++k) {
                    this.edgeLines.get(i).generateMeshes((Point3DReadOnly)this.edges[i][k], (Point3DReadOnly)this.edges[i][k + 1]);
                    Point3D p1 = this.edges[i][k];
                    Point3D p2 = this.edges[i][k + 1];
                    Point3D p3 = this.edges[j][k + 1];
                    Point3D p4 = this.edges[j][k];
                    this.addRectangleToMesh(meshBuilder, p1, p2, p3, p4);
                }
            }
        };
    }

    private void addRectangleToMesh(MeshPartBuilder meshBuilder, Point3D p1, Point3D p2, Point3D p3, Point3D p4) {
        double nx = (p2.getY() - p1.getY()) * (p4.getZ() - p1.getZ()) - (p2.getZ() - p1.getZ()) * (p4.getY() - p1.getY());
        double ny = (p2.getZ() - p1.getZ()) * (p4.getX() - p1.getX()) - (p2.getX() - p1.getX()) * (p4.getZ() - p1.getZ());
        double nz = (p2.getX() - p1.getX()) * (p4.getY() - p1.getY()) - (p2.getY() - p1.getY()) * (p4.getX() - p1.getX());
        double length = Math.sqrt(nx * nx + ny * ny + nz * nz);
        meshBuilder.rect((float)p1.getX(), (float)p1.getY(), (float)p1.getZ(), (float)p2.getX(), (float)p2.getY(), (float)p2.getZ(), (float)p3.getX(), (float)p3.getY(), (float)p3.getZ(), (float)p4.getX(), (float)p4.getY(), (float)p4.getZ(), (float)(nx /= length), (float)(ny /= length), (float)(nz /= length));
        meshBuilder.rect((float)p4.getX(), (float)p4.getY(), (float)p4.getZ(), (float)p3.getX(), (float)p3.getY(), (float)p3.getZ(), (float)p2.getX(), (float)p2.getY(), (float)p2.getZ(), (float)p1.getX(), (float)p1.getY(), (float)p1.getZ(), (float)(-nx), (float)(-ny), (float)(-nz));
    }

    public void addRectangularPatch(Point3D p1, Point3D p2, Point3D p3, Point3D p4) {
        MeshPartBuilder meshBuilder = this.modelBuilder.part("patches", 4, 9L, this.material);
        this.addRectangleToMesh(meshBuilder, p1, p2, p3, p4);
    }

    public void closeShape() {
        if (this.startPoints.length > 2) {
            this.modelBuilder.part(this.createPolygonalPatch(this.startPoints, false), this.material);
        }
        if (this.endPoints.length > 2) {
            this.modelBuilder.part(this.createPolygonalPatch(this.endPoints, true), this.material);
        }
    }

    private MeshPart createPolygonalPatch(Point3D[] points, boolean reverseVertexOrder) {
        float[] vertices = new float[points.length * 3];
        short[] indices = new short[(points.length - 2) * 3];
        for (int i = 0; i < points.length; ++i) {
            Point3D p = reverseVertexOrder ? points[points.length - 1 - i] : points[i];
            vertices[i * 3] = (float)p.getX();
            vertices[i * 3 + 1] = (float)p.getY();
            vertices[i * 3 + 2] = (float)p.getZ();
        }
        int numTriangles = points.length - 2;
        for (int i = 0; i < numTriangles; ++i) {
            indices[i * 3] = 0;
            indices[i * 3 + 1] = (short)(i + 1);
            indices[i * 3 + 2] = (short)(i + 2);
        }
        Mesh mesh = new Mesh(true, vertices.length, indices.length, MeshBuilder.createAttributes((long)1L));
        mesh.setVertices(vertices);
        mesh.setIndices(indices);
        return new MeshPart(null, mesh, 0, mesh.getNumIndices(), 4);
    }

    public void clear() {
        if (this.lastModel != null) {
            this.lastModel.dispose();
            this.lastModel = null;
        }
        this.modelInstance = null;
        for (RDXSplineBody edgeLine : this.edgeLines) {
            edgeLine.clear();
        }
        this.edgeLines.clear();
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        if (this.modelInstance != null) {
            this.modelInstance.getRenderables(renderables, pool);
        }
        if (!this.edgeLines.isEmpty()) {
            for (RDXSplineBody edgeLine : this.edgeLines) {
                edgeLine.getRenderables(renderables, pool);
            }
        }
    }

    public Point3D[] getStartPoints() {
        return this.startPoints;
    }

    public Point3D[] getEndPoints() {
        return this.endPoints;
    }
}

