/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.ui.gizmo;

import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import imgui.ImGui;
import imgui.type.ImBoolean;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.rdx.input.ImGui3DViewInput;
import us.ihmc.rdx.sceneManager.RDXSceneLevel;
import us.ihmc.rdx.ui.RDX3DPanel;
import us.ihmc.rdx.ui.RDXBaseUI;
import us.ihmc.rdx.ui.gizmo.RDXPathControlRingGizmo;
import us.ihmc.rdx.vr.RDXVRContext;
import us.ihmc.robotics.robotSide.RobotSide;

public class RDXSelectablePathControlRingGizmo {
    private final RDXPathControlRingGizmo pathControlRingGizmo;
    private boolean selectable = true;
    private boolean modified = false;
    private final ImBoolean selected;

    public RDXSelectablePathControlRingGizmo() {
        this.selected = new ImBoolean(false);
        this.pathControlRingGizmo = new RDXPathControlRingGizmo();
    }

    public RDXSelectablePathControlRingGizmo(ReferenceFrame parentReferenceFrame) {
        this.selected = new ImBoolean(false);
        this.pathControlRingGizmo = new RDXPathControlRingGizmo(parentReferenceFrame);
    }

    public RDXSelectablePathControlRingGizmo(ReferenceFrame gizmoFrame, RigidBodyTransform gizmoTransformToParentFrameToModify) {
        this(gizmoFrame, gizmoTransformToParentFrameToModify, new ImBoolean(false));
    }

    public RDXSelectablePathControlRingGizmo(ReferenceFrame gizmoFrame, RigidBodyTransform gizmoTransformToParentFrameToModify, ImBoolean selected) {
        this.selected = selected;
        this.pathControlRingGizmo = new RDXPathControlRingGizmo(gizmoFrame, gizmoTransformToParentFrameToModify);
    }

    public void create(RDX3DPanel panel3D) {
        this.pathControlRingGizmo.create(panel3D);
    }

    public void createAndSetupDefault(RDXBaseUI baseUI) {
        this.create(baseUI.getPrimary3DPanel());
        baseUI.getVRManager().getContext().addVRPickCalculator(this::calculateVRPick);
        baseUI.getVRManager().getContext().addVRPickCalculator(this::processVRInput);
        baseUI.getPrimary3DPanel().addImGui3DViewPickCalculator(this::calculate3DViewPick);
        baseUI.getPrimary3DPanel().addImGui3DViewInputProcessor(this::process3DViewInput);
        baseUI.getPrimary3DPanel().getScene().addRenderableProvider(this::getVirtualRenderables, RDXSceneLevel.VIRTUAL);
    }

    public void calculateVRPick(RDXVRContext vrContext) {
        this.pathControlRingGizmo.calculateVRPick(vrContext);
    }

    public void processVRInput(RDXVRContext vrContext) {
        this.pathControlRingGizmo.processVRInput(vrContext);
        if (this.selectable && (((Boolean)this.pathControlRingGizmo.getIsRingBeingDraggedVR().get((Enum)RobotSide.LEFT)).booleanValue() || ((Boolean)this.pathControlRingGizmo.getIsRingBeingDraggedVR().get((Enum)RobotSide.RIGHT)).booleanValue())) {
            this.selected.set(true);
        }
        this.pathControlRingGizmo.setShowArrows(this.selected.get());
        this.pathControlRingGizmo.setHighlightingEnabled(this.modified);
    }

    public void calculate3DViewPick(ImGui3DViewInput input) {
        if (input.isWindowHovered()) {
            this.pathControlRingGizmo.calculate3DViewPick(input);
        }
    }

    public void process3DViewInput(ImGui3DViewInput input) {
        this.pathControlRingGizmo.calculateHovered(input);
        if (input.isWindowHovered()) {
            boolean leftMouseReleasedWithoutDrag = input.mouseReleasedWithoutDrag(0);
            boolean isClickedOn = this.pathControlRingGizmo.getRingHovered() && leftMouseReleasedWithoutDrag;
            boolean somethingElseIsClickedOn = !this.pathControlRingGizmo.getAnyPartHovered() && leftMouseReleasedWithoutDrag;
            boolean isCtrlPressed = ImGui.getIO().getKeyCtrl();
            if (this.selectable && isClickedOn) {
                this.selected.set(true);
            }
            if (somethingElseIsClickedOn && !isCtrlPressed) {
                this.selected.set(false);
            }
        }
        this.pathControlRingGizmo.setShowArrows(this.selected.get());
        this.pathControlRingGizmo.setHighlightingEnabled(this.modified);
        if (this.selected.get()) {
            this.pathControlRingGizmo.process3DViewInputModification(input);
        } else if (this.selectable) {
            this.pathControlRingGizmo.update();
        }
    }

    public void getVirtualRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        if (this.selectable && this.pathControlRingGizmo.getRingHovered() || ((Boolean)this.pathControlRingGizmo.getIsGizmoHoveredVR().get((Enum)RobotSide.RIGHT)).booleanValue() || ((Boolean)this.pathControlRingGizmo.getIsGizmoHoveredVR().get((Enum)RobotSide.LEFT)).booleanValue() || this.modified || this.selected.get()) {
            this.pathControlRingGizmo.getRenderables(renderables, pool);
        }
    }

    public RDXPathControlRingGizmo getPathControlRingGizmo() {
        return this.pathControlRingGizmo;
    }

    public boolean getSelected() {
        return this.selected.get();
    }

    public ImBoolean getImSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected.set(selected);
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public boolean getModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }
}

