/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.ui.gizmo;

import imgui.internal.ImGui;
import java.util.function.Supplier;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.rdx.RDXFocusBasedCamera;
import us.ihmc.rdx.imgui.ImGuiInputDouble;
import us.ihmc.rdx.imgui.ImGuiInputDoubleForRotations;
import us.ihmc.rdx.imgui.ImGuiUniqueLabelMap;
import us.ihmc.rdx.ui.gizmo.RDXPose3DGizmoAdjustmentFrame;
import us.ihmc.robotics.referenceFrames.MutableReferenceFrame;

public class FrameBasedGizmoModification {
    private static final boolean SET_ABSOLUTE = false;
    public static final boolean PREPEND = true;
    private static final double TRANSLATION_EPSILON = 1.0E-8;
    private static final double ROTATION_EPSILON = 1.0E-4;
    private final ImGuiUniqueLabelMap labels = new ImGuiUniqueLabelMap(this.getClass());
    private final boolean yawOnly;
    private final Supplier<ReferenceFrame> gizmoFrameSupplier;
    private final Supplier<ReferenceFrame> parentReferenceFrameSupplier;
    private final RDXFocusBasedCamera camera3D;
    private final FramePose3D adjustmentPose3D = new FramePose3D();
    private final FrameQuaternion rotationAdjustmentQuaternion = new FrameQuaternion();
    private final MutableReferenceFrame cameraZUpFrameForAdjustment = new MutableReferenceFrame(ReferenceFrame.getWorldFrame());
    private final ImGuiInputDouble translationStepSizeInput;
    private final ImGuiInputDouble positionXImGuiInput;
    private final ImGuiInputDouble positionYImGuiInput;
    private final ImGuiInputDouble positionZImGuiInput;
    private final ImGuiInputDouble rotationStepSizeInput;
    private final ImGuiInputDoubleForRotations yawImGuiInput;
    private final ImGuiInputDoubleForRotations pitchImGuiInput;
    private final ImGuiInputDoubleForRotations rollImGuiInput;
    private boolean adjustmentNeedsToBeApplied = false;
    private RDXPose3DGizmoAdjustmentFrame translationAdjustmentFrame = RDXPose3DGizmoAdjustmentFrame.CAMERA_ZUP;
    private RDXPose3DGizmoAdjustmentFrame rotationAdjustmentFrame = RDXPose3DGizmoAdjustmentFrame.CAMERA_ZUP;

    public FrameBasedGizmoModification(Supplier<ReferenceFrame> gizmoFrameSupplier, Supplier<ReferenceFrame> parentReferenceFrameSupplier, RDXFocusBasedCamera camera3D) {
        this(gizmoFrameSupplier, parentReferenceFrameSupplier, camera3D, false);
    }

    public FrameBasedGizmoModification(Supplier<ReferenceFrame> gizmoFrameSupplier, Supplier<ReferenceFrame> parentReferenceFrameSupplier, RDXFocusBasedCamera camera3D, boolean yawOnly) {
        this.yawOnly = yawOnly;
        this.gizmoFrameSupplier = gizmoFrameSupplier;
        this.parentReferenceFrameSupplier = parentReferenceFrameSupplier;
        this.camera3D = camera3D;
        this.translationStepSizeInput = new ImGuiInputDouble("Translation step size", "%.5f", 0.01);
        this.positionXImGuiInput = new ImGuiInputDouble("X", "%.5f");
        this.positionYImGuiInput = new ImGuiInputDouble("Y", "%.5f");
        this.positionZImGuiInput = new ImGuiInputDouble("Z", "%.5f");
        this.rotationStepSizeInput = new ImGuiInputDouble("Rotation step size \u00b0", "%.5f", 0.5);
        this.yawImGuiInput = new ImGuiInputDoubleForRotations("Yaw \u00b0", "%.5f");
        if (!yawOnly) {
            this.pitchImGuiInput = new ImGuiInputDoubleForRotations("Pitch \u00b0", "%.5f");
            this.rollImGuiInput = new ImGuiInputDoubleForRotations("Roll \u00b0", "%.5f");
        } else {
            this.pitchImGuiInput = null;
            this.rollImGuiInput = null;
        }
    }

    public void translateInWorld(Vector3DReadOnly translation) {
        if (translation.normSquared() > 1.0E-8) {
            this.adjustmentPose3D.changeFrame(this.adjustmentPose3D.getReferenceFrame().getRootFrame());
            this.adjustmentPose3D.getPosition().add((Tuple3DReadOnly)translation);
            this.adjustmentNeedsToBeApplied = true;
        }
    }

    public void rotateInWorld(AxisAngleReadOnly rotationInWorld) {
        if (Math.abs(rotationInWorld.angle()) > 1.0E-4) {
            this.adjustmentPose3D.changeFrame(this.adjustmentPose3D.getReferenceFrame().getRootFrame());
            rotationInWorld.transform((Orientation3DBasics)this.adjustmentPose3D.getOrientation());
            this.adjustmentNeedsToBeApplied = true;
        }
    }

    public void yawInWorld(double yaw) {
        if (Math.abs(yaw) > 1.0E-4) {
            Orientation3DBasics orientationToAdjust = this.beforeForRotationAdjustment();
            orientationToAdjust.appendYawRotation(yaw);
            this.afterRotationAdjustment(true);
            this.adjustmentNeedsToBeApplied = true;
        }
    }

    public boolean applyAdjustmentIfNeeded(RigidBodyTransform transformToParentToPack) {
        boolean adjustmentApplied = this.adjustmentNeedsToBeApplied;
        if (this.adjustmentNeedsToBeApplied) {
            this.adjustmentNeedsToBeApplied = false;
            this.adjustmentPose3D.changeFrame(this.parentReferenceFrameSupplier.get());
            this.adjustmentPose3D.get((RigidBodyTransformBasics)transformToParentToPack);
        }
        return adjustmentApplied;
    }

    public void setToZeroGizmoFrame() {
        this.adjustmentPose3D.setToZero(this.gizmoFrameSupplier.get());
    }

    public void renderImGuiTunerWidgets() {
        ReferenceFrame parentReferenceFrame = this.parentReferenceFrameSupplier.get();
        ImGui.text((String)("Parent frame: " + parentReferenceFrame.getName()));
        ImGui.text((String)"Translation adjustment frame:");
        if (ImGui.radioButton((String)this.labels.get("Camera Z Up", 0), (this.translationAdjustmentFrame == RDXPose3DGizmoAdjustmentFrame.CAMERA_ZUP ? 1 : 0) != 0)) {
            this.translationAdjustmentFrame = RDXPose3DGizmoAdjustmentFrame.CAMERA_ZUP;
        }
        ImGui.sameLine();
        if (ImGui.radioButton((String)this.labels.get("Camera", 0), (this.translationAdjustmentFrame == RDXPose3DGizmoAdjustmentFrame.CAMERA ? 1 : 0) != 0)) {
            this.translationAdjustmentFrame = RDXPose3DGizmoAdjustmentFrame.CAMERA;
        }
        ImGui.sameLine();
        if (ImGui.radioButton((String)this.labels.get("World", 0), (this.translationAdjustmentFrame == RDXPose3DGizmoAdjustmentFrame.WORLD ? 1 : 0) != 0)) {
            this.translationAdjustmentFrame = RDXPose3DGizmoAdjustmentFrame.WORLD;
        }
        ImGui.sameLine();
        if (ImGui.radioButton((String)this.labels.get("Parent", 0), (this.translationAdjustmentFrame == RDXPose3DGizmoAdjustmentFrame.PARENT ? 1 : 0) != 0)) {
            this.translationAdjustmentFrame = RDXPose3DGizmoAdjustmentFrame.PARENT;
        }
        ImGui.sameLine();
        if (ImGui.radioButton((String)this.labels.get("Local", 0), (this.translationAdjustmentFrame == RDXPose3DGizmoAdjustmentFrame.LOCAL ? 1 : 0) != 0)) {
            this.translationAdjustmentFrame = RDXPose3DGizmoAdjustmentFrame.LOCAL;
        }
        ImGui.text((String)"Rotation adjustment frame:");
        if (ImGui.radioButton((String)this.labels.get("Camera Z Up", 1), (this.rotationAdjustmentFrame == RDXPose3DGizmoAdjustmentFrame.CAMERA_ZUP ? 1 : 0) != 0)) {
            this.rotationAdjustmentFrame = RDXPose3DGizmoAdjustmentFrame.CAMERA_ZUP;
        }
        ImGui.sameLine();
        if (ImGui.radioButton((String)this.labels.get("Camera", 1), (this.rotationAdjustmentFrame == RDXPose3DGizmoAdjustmentFrame.CAMERA ? 1 : 0) != 0)) {
            this.rotationAdjustmentFrame = RDXPose3DGizmoAdjustmentFrame.CAMERA;
        }
        ImGui.sameLine();
        if (ImGui.radioButton((String)this.labels.get("World", 1), (this.rotationAdjustmentFrame == RDXPose3DGizmoAdjustmentFrame.WORLD ? 1 : 0) != 0)) {
            this.rotationAdjustmentFrame = RDXPose3DGizmoAdjustmentFrame.WORLD;
        }
        ImGui.sameLine();
        if (ImGui.radioButton((String)this.labels.get("Parent", 1), (this.rotationAdjustmentFrame == RDXPose3DGizmoAdjustmentFrame.PARENT ? 1 : 0) != 0)) {
            this.rotationAdjustmentFrame = RDXPose3DGizmoAdjustmentFrame.PARENT;
        }
        ImGui.sameLine();
        if (ImGui.radioButton((String)this.labels.get("Local", 1), (this.rotationAdjustmentFrame == RDXPose3DGizmoAdjustmentFrame.LOCAL ? 1 : 0) != 0)) {
            this.rotationAdjustmentFrame = RDXPose3DGizmoAdjustmentFrame.LOCAL;
        }
        this.beforeForTranslationAdjustment();
        this.translationStepSizeInput.render(0.01, 0.1);
        this.positionXImGuiInput.setDoubleValue(this.adjustmentPose3D.getPosition().getX());
        this.positionYImGuiInput.setDoubleValue(this.adjustmentPose3D.getPosition().getY());
        this.positionZImGuiInput.setDoubleValue(this.adjustmentPose3D.getPosition().getZ());
        this.adjustmentNeedsToBeApplied |= this.positionXImGuiInput.render(this.translationStepSizeInput.getDoubleValue(), 10.0 * this.translationStepSizeInput.getDoubleValue());
        this.adjustmentNeedsToBeApplied |= this.positionYImGuiInput.render(this.translationStepSizeInput.getDoubleValue(), 10.0 * this.translationStepSizeInput.getDoubleValue());
        this.adjustmentNeedsToBeApplied |= this.positionZImGuiInput.render(this.translationStepSizeInput.getDoubleValue(), 10.0 * this.translationStepSizeInput.getDoubleValue());
        this.adjustmentPose3D.getPosition().set(this.positionXImGuiInput.getDoubleValue(), this.positionYImGuiInput.getDoubleValue(), this.positionZImGuiInput.getDoubleValue());
        this.rotationStepSizeInput.render(0.5, 5.0);
        Orientation3DBasics orientationToPrint = this.getOrientationInAdjustmentFrame();
        this.yawImGuiInput.setDoubleValue(Math.toDegrees(orientationToPrint.getYaw()));
        if (!this.yawOnly) {
            this.pitchImGuiInput.setDoubleValue(Math.toDegrees(orientationToPrint.getPitch()));
            this.rollImGuiInput.setDoubleValue(Math.toDegrees(orientationToPrint.getRoll()));
        }
        this.yawImGuiInput.render(this.rotationStepSizeInput.getDoubleValue(), 10.0 * this.rotationStepSizeInput.getDoubleValue());
        if (!this.yawOnly) {
            this.pitchImGuiInput.render(this.rotationStepSizeInput.getDoubleValue(), 10.0 * this.rotationStepSizeInput.getDoubleValue());
            this.rollImGuiInput.render(this.rotationStepSizeInput.getDoubleValue(), 10.0 * this.rotationStepSizeInput.getDoubleValue());
        }
        boolean inputChanged = this.yawImGuiInput.getInputChanged();
        if (!this.yawOnly) {
            inputChanged |= this.pitchImGuiInput.getInputChanged();
            inputChanged |= this.rollImGuiInput.getInputChanged();
        }
        this.adjustmentNeedsToBeApplied |= inputChanged;
        if (inputChanged) {
            Orientation3DBasics orientationToAdjust = this.beforeForRotationAdjustment();
            orientationToAdjust.setYawPitchRoll(Math.toRadians(this.yawImGuiInput.getDoubleValue()), this.yawOnly ? 0.0 : Math.toRadians(this.pitchImGuiInput.getDoubleValue()), this.yawOnly ? 0.0 : Math.toRadians(this.rollImGuiInput.getDoubleValue()));
            this.afterRotationAdjustment(false);
        }
        boolean rotationStepped = this.yawImGuiInput.getStepButtonClicked();
        if (!this.yawOnly) {
            rotationStepped |= this.pitchImGuiInput.getStepButtonClicked();
            rotationStepped |= this.rollImGuiInput.getStepButtonClicked();
        }
        this.adjustmentNeedsToBeApplied |= rotationStepped;
        if (rotationStepped) {
            Orientation3DBasics orientationToAdjust = this.beforeForRotationAdjustment();
            orientationToAdjust.setYawPitchRoll(Math.toRadians(this.yawImGuiInput.getSteppedAmount()), this.yawOnly ? 0.0 : Math.toRadians(this.pitchImGuiInput.getSteppedAmount()), this.yawOnly ? 0.0 : Math.toRadians(this.rollImGuiInput.getSteppedAmount()));
            this.afterRotationAdjustment(true);
        }
        ImGui.text((String)"Set to zero in:");
        ImGui.sameLine();
        if (ImGui.button((String)"World")) {
            this.adjustmentPose3D.setToZero(ReferenceFrame.getWorldFrame());
            this.adjustmentNeedsToBeApplied = true;
        }
        ImGui.sameLine();
        if (ImGui.button((String)"Parent")) {
            this.adjustmentPose3D.setToZero(parentReferenceFrame);
            this.adjustmentNeedsToBeApplied = true;
        }
    }

    public Point3DBasics beforeForTranslationAdjustment() {
        ReferenceFrame parentReferenceFrame = this.parentReferenceFrameSupplier.get();
        switch (this.translationAdjustmentFrame) {
            case WORLD: {
                this.adjustmentPose3D.changeFrame(ReferenceFrame.getWorldFrame());
                break;
            }
            case PARENT: {
                this.adjustmentPose3D.changeFrame(parentReferenceFrame);
                break;
            }
            case CAMERA_ZUP: {
                this.prepareCameraZUpFrameForAdjustment();
                this.adjustmentPose3D.changeFrame(this.cameraZUpFrameForAdjustment.getReferenceFrame());
                break;
            }
            case CAMERA: {
                this.adjustmentPose3D.changeFrame(this.camera3D.getCameraFrame());
            }
        }
        return this.adjustmentPose3D.getPosition();
    }

    private Orientation3DBasics getOrientationInAdjustmentFrame() {
        switch (this.rotationAdjustmentFrame) {
            case WORLD: 
            case PARENT: 
            case CAMERA_ZUP: 
            case CAMERA: {
                if (this.rotationAdjustmentFrame == RDXPose3DGizmoAdjustmentFrame.WORLD) {
                    this.adjustmentPose3D.changeFrame(ReferenceFrame.getWorldFrame());
                    break;
                }
                if (this.rotationAdjustmentFrame == RDXPose3DGizmoAdjustmentFrame.PARENT) {
                    this.adjustmentPose3D.changeFrame(this.parentReferenceFrameSupplier.get());
                    break;
                }
                if (this.rotationAdjustmentFrame == RDXPose3DGizmoAdjustmentFrame.CAMERA_ZUP) {
                    this.prepareCameraZUpFrameForAdjustment();
                    this.adjustmentPose3D.changeFrame(this.cameraZUpFrameForAdjustment.getReferenceFrame());
                    break;
                }
                this.adjustmentPose3D.changeFrame(this.camera3D.getCameraFrame());
                break;
            }
            default: {
                this.adjustmentPose3D.changeFrame(this.gizmoFrameSupplier.get());
            }
        }
        return this.adjustmentPose3D.getOrientation();
    }

    public Orientation3DBasics beforeForRotationAdjustment() {
        switch (this.rotationAdjustmentFrame) {
            case WORLD: 
            case PARENT: 
            case CAMERA_ZUP: 
            case CAMERA: {
                if (this.rotationAdjustmentFrame == RDXPose3DGizmoAdjustmentFrame.WORLD) {
                    this.rotationAdjustmentQuaternion.setToZero(ReferenceFrame.getWorldFrame());
                } else if (this.rotationAdjustmentFrame == RDXPose3DGizmoAdjustmentFrame.PARENT) {
                    this.rotationAdjustmentQuaternion.setToZero(this.parentReferenceFrameSupplier.get());
                } else if (this.rotationAdjustmentFrame == RDXPose3DGizmoAdjustmentFrame.CAMERA_ZUP) {
                    this.prepareCameraZUpFrameForAdjustment();
                    this.rotationAdjustmentQuaternion.setToZero(this.cameraZUpFrameForAdjustment.getReferenceFrame());
                } else {
                    this.rotationAdjustmentQuaternion.setToZero(this.camera3D.getCameraFrame());
                }
                return this.rotationAdjustmentQuaternion;
            }
        }
        this.adjustmentPose3D.changeFrame(this.gizmoFrameSupplier.get());
        return this.adjustmentPose3D.getOrientation();
    }

    private void prepareCameraZUpFrameForAdjustment() {
        this.cameraZUpFrameForAdjustment.getTransformToParent().getTranslation().set((Tuple3DReadOnly)this.camera3D.getCameraPose().getPosition());
        this.cameraZUpFrameForAdjustment.getTransformToParent().getRotation().setToYawOrientation(this.camera3D.getCameraPose().getYaw());
        this.cameraZUpFrameForAdjustment.getReferenceFrame().update();
    }

    public void afterRotationAdjustment(boolean prepend) {
        switch (this.rotationAdjustmentFrame) {
            case WORLD: 
            case PARENT: 
            case CAMERA_ZUP: 
            case CAMERA: {
                if (this.rotationAdjustmentFrame == RDXPose3DGizmoAdjustmentFrame.WORLD) {
                    this.rotationAdjustmentQuaternion.changeFrame(ReferenceFrame.getWorldFrame());
                    this.adjustmentPose3D.changeFrame(ReferenceFrame.getWorldFrame());
                } else if (this.rotationAdjustmentFrame == RDXPose3DGizmoAdjustmentFrame.PARENT) {
                    ReferenceFrame parentReferenceFrame = this.parentReferenceFrameSupplier.get();
                    this.rotationAdjustmentQuaternion.changeFrame(parentReferenceFrame);
                    this.adjustmentPose3D.changeFrame(parentReferenceFrame);
                } else if (this.rotationAdjustmentFrame == RDXPose3DGizmoAdjustmentFrame.CAMERA_ZUP) {
                    this.rotationAdjustmentQuaternion.changeFrame(this.cameraZUpFrameForAdjustment.getReferenceFrame());
                    this.adjustmentPose3D.changeFrame(this.cameraZUpFrameForAdjustment.getReferenceFrame());
                } else {
                    this.rotationAdjustmentQuaternion.changeFrame(this.camera3D.getCameraFrame());
                    this.adjustmentPose3D.changeFrame(this.camera3D.getCameraFrame());
                }
                if (prepend) {
                    this.adjustmentPose3D.getOrientation().prepend((FrameOrientation3DReadOnly)this.rotationAdjustmentQuaternion);
                    break;
                }
                this.adjustmentPose3D.getOrientation().set((FrameQuaternionReadOnly)this.rotationAdjustmentQuaternion);
            }
        }
    }

    public void setAdjustmentNeedsToBeApplied() {
        this.adjustmentNeedsToBeApplied = true;
    }
}

