/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.ui.gizmo;

import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.graphics.g3d.model.NodePart;
import java.util.function.Consumer;
import java.util.function.Supplier;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.rdx.mesh.RDXMultiColorMeshBuilder;
import us.ihmc.rdx.tools.RDXModelInstance;

public class DynamicLibGDXModel {
    private Model model;
    private final Node node;
    private MeshPart meshPart;
    private ModelInstance modelInstance;
    private Material material;
    private Supplier<Mesh> buildMesh;
    private Mesh mesh;
    private boolean needsRebuild = true;
    private boolean customModel = false;
    private final RigidBodyTransform localTransform = new RigidBodyTransform();

    public DynamicLibGDXModel() {
        this.model = new Model();
        this.node = new Node();
        this.model.nodes.add((Object)this.node);
        this.node.id = "node" + this.model.nodes.size;
    }

    public void setModel(Model model) {
        this.model = model;
        this.customModel = true;
    }

    public void setMesh(Consumer<RDXMultiColorMeshBuilder> buildMesh) {
        this.buildMesh = () -> {
            RDXMultiColorMeshBuilder meshBuilder = new RDXMultiColorMeshBuilder();
            buildMesh.accept(meshBuilder);
            return meshBuilder.generateMesh();
        };
        this.needsRebuild = true;
    }

    public void setMesh(Supplier<Mesh> buildMesh) {
        this.buildMesh = buildMesh;
        this.needsRebuild = true;
    }

    public void setMesh(Mesh mesh) {
        this.mesh = mesh;
        this.buildMesh = null;
        this.needsRebuild = true;
    }

    public void invalidateMesh() {
        this.needsRebuild = true;
    }

    public void setMaterial(Material material) {
        if (this.material == null || !this.material.equals((Object)material)) {
            this.material = material;
            this.needsRebuild = true;
        }
    }

    public void buildIfNeeded() {
        if (this.needsRebuild && !this.customModel) {
            this.needsRebuild = false;
            if (this.mesh != null && this.buildMesh != null) {
                this.node.parts.removeIndex(0);
                this.dispose();
            }
            if (this.buildMesh != null) {
                this.mesh = this.buildMesh.get();
            }
            if (this.mesh != null) {
                this.meshPart = new MeshPart("xyz", this.mesh, 0, this.mesh.getNumIndices(), 4);
                this.node.parts.add((Object)new NodePart(this.meshPart, this.material));
            }
        }
    }

    public void dispose() {
        if (this.mesh != null) {
            this.mesh.dispose();
        }
    }

    public ModelInstance newModelInstance() {
        this.buildIfNeeded();
        return new RDXModelInstance(this.model);
    }

    public Model getModel() {
        return this.model;
    }

    public ModelInstance getOrCreateModelInstance() {
        if (this.needsRebuild || this.modelInstance == null) {
            this.modelInstance = this.newModelInstance();
        }
        return this.modelInstance;
    }

    public RigidBodyTransform getLocalTransform() {
        return this.localTransform;
    }

    public ModelInstance getModelInstance() {
        return this.modelInstance;
    }
}

