/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Graphics;
import com.badlogic.gdx.graphics.profiling.GLProfiler;
import imgui.internal.ImGui;
import imgui.type.ImBoolean;
import imgui.type.ImDouble;
import imgui.type.ImInt;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import us.ihmc.commons.FormattingTools;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.log.LogTools;
import us.ihmc.rdx.Lwjgl3ApplicationAdapter;
import us.ihmc.rdx.RDXKeyBindings;
import us.ihmc.rdx.RDXSettings;
import us.ihmc.rdx.imgui.ImGuiFrequencyDisplay;
import us.ihmc.rdx.imgui.ImGuiLabelledWidgetAligner;
import us.ihmc.rdx.imgui.ImGuiSliderDoubleWrapper;
import us.ihmc.rdx.imgui.ImGuiTools;
import us.ihmc.rdx.imgui.ImGuiUniqueLabelMap;
import us.ihmc.rdx.imgui.RDXImGuiWindowAndDockSystem;
import us.ihmc.rdx.imgui.RDXPanelManager;
import us.ihmc.rdx.input.RDXInputMode;
import us.ihmc.rdx.sceneManager.RDX3DScene;
import us.ihmc.rdx.sceneManager.RDXSceneLevel;
import us.ihmc.rdx.tools.LibGDXApplicationCreator;
import us.ihmc.rdx.tools.LibGDXTools;
import us.ihmc.rdx.ui.RDX3DPanel;
import us.ihmc.rdx.ui.RDXImGuiLayoutManager;
import us.ihmc.rdx.vr.RDXVRManager;
import us.ihmc.tools.IHMCCommonPaths;
import us.ihmc.tools.io.HybridDirectory;
import us.ihmc.tools.io.HybridResourceDirectory;

public class RDXBaseUI {
    public static final int ANTI_ALIASING = 2;
    private static final String VIEW_3D_WINDOW_NAME = "3D View";
    private static RDXBaseUI instance;
    private GLProfiler glProfiler;
    private RDXSettings settings;
    private final RDX3DScene primaryScene = new RDX3DScene();
    private final RDX3DPanel primary3DPanel;
    private final ArrayList<RDX3DPanel> additional3DPanels = new ArrayList();
    private final RDXVRManager vrManager = new RDXVRManager();
    private final RDXImGuiWindowAndDockSystem imGuiWindowAndDockSystem;
    private final ArrayList<Runnable> onCloseRequestListeners = new ArrayList();
    private final String windowTitle;
    private final String configurationExtraPath;
    private final HybridResourceDirectory configurationBaseDirectory;
    private final ImGuiFrequencyDisplay frameRateDisplay = new ImGuiFrequencyDisplay("frameRateDisplay");
    private final Stopwatch runTime = new Stopwatch().start();
    private String statusText = "";
    private final ImGuiUniqueLabelMap labels = new ImGuiUniqueLabelMap(this.getClass());
    private final ImInt foregroundFPSLimit = new ImInt(240);
    private final ImBoolean plotFrameRate = new ImBoolean(false);
    private final ImBoolean vsync = new ImBoolean(false);
    private final ImBoolean lockPanelsWithinWindows = new ImBoolean(true);
    private final ImBoolean middleClickOrbit = new ImBoolean(false);
    private final ImBoolean modelSceneMouseCollisionEnabled = new ImBoolean(false);
    private final ImDouble view3DBackgroundShade = new ImDouble(0.501960813999176);
    private final ImInt libGDXLogLevel = new ImInt(LibGDXTools.toLibGDX(LogTools.getLevel()));
    private final ImInt imguiFontSize = new ImInt(ImGuiTools.DEFAULT_FONT_SIZE);
    private ImGuiSliderDoubleWrapper ambientLightIntensitySlider;
    private ImGuiSliderDoubleWrapper pointLightIntensitySlider;
    private ImGuiSliderDoubleWrapper directionalLightIntensitySlider;
    private final RDXImGuiLayoutManager layoutManager;
    private final RDXKeyBindings keyBindings = new RDXKeyBindings();
    private long renderIndex = 0L;
    private final double isoZoomOut = 0.7;
    private Theme theme = Theme.LIGHT;

    public static RDXBaseUI getInstance() {
        return instance;
    }

    public RDXBaseUI() {
        this(0, null);
    }

    public RDXBaseUI(String windowTitle) {
        this(0, windowTitle);
    }

    RDXBaseUI(int additionalStackHeightForFindingCaller, String windowTitle) {
        instance = this;
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        Class classForLoading = (Class)ExceptionTools.handle(() -> Class.forName(stackTraceElements[3 + additionalStackHeightForFindingCaller].getClassName()), (ExceptionHandler)DefaultExceptionHandler.RUNTIME_EXCEPTION);
        LogTools.info((String)"Using class for loading resources: {}", (Object)classForLoading.getName());
        windowTitle = windowTitle == null ? classForLoading.getSimpleName() : windowTitle;
        this.windowTitle = windowTitle;
        this.configurationExtraPath = "configurations/" + windowTitle.replaceAll(" ", "");
        this.configurationBaseDirectory = new HybridResourceDirectory(IHMCCommonPaths.DOT_IHMC_DIRECTORY, classForLoading, "/").resolve(this.configurationExtraPath);
        if (!this.configurationBaseDirectory.isWorkspaceFileAccessAvailable()) {
            LogTools.warn((String)"We won't be able to write files to version controlled resources, because we probably aren't in a workspace.");
        }
        this.layoutManager = new RDXImGuiLayoutManager(classForLoading, this.configurationExtraPath, this.configurationBaseDirectory);
        this.imGuiWindowAndDockSystem = new RDXImGuiWindowAndDockSystem(this.layoutManager);
        this.layoutManager.getLayoutDirectoryUpdatedListeners().add(this.imGuiWindowAndDockSystem::setDirectory);
        this.layoutManager.getLoadListeners().add(this.imGuiWindowAndDockSystem::loadConfiguration);
        this.layoutManager.getLoadListeners().add(loadConfigurationLocation -> {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ThreadTools.sleep((long)1L);
                    int width = RDXBaseUI.this.imGuiWindowAndDockSystem.getCalculatedPrimaryWindowSize().getWidth();
                    int height = RDXBaseUI.this.imGuiWindowAndDockSystem.getCalculatedPrimaryWindowSize().getHeight();
                    Gdx.graphics.setWindowedMode(width, height);
                    int x = RDXBaseUI.this.imGuiWindowAndDockSystem.getPrimaryWindowContentAreaPosition().getX();
                    int y = RDXBaseUI.this.imGuiWindowAndDockSystem.getPrimaryWindowContentAreaPosition().getY();
                    ((Lwjgl3Graphics)Gdx.graphics).getWindow().setPosition(x, y);
                }
            }, this.getClass().getSimpleName() + "SetWindowSize").start();
            return true;
        });
        this.layoutManager.getSaveListeners().add(this.imGuiWindowAndDockSystem::saveConfiguration);
        this.layoutManager.applyLayoutDirectory();
        this.primary3DPanel = new RDX3DPanel(VIEW_3D_WINDOW_NAME, 2, true);
        this.primary3DPanel.setBackgroundShade((float)this.view3DBackgroundShade.get());
    }

    public synchronized void loadSettings() {
        this.settings = new RDXSettings();
        try {
            this.settings.load();
        }
        catch (IOException e) {
            LogTools.error((String)"Unable to load RDXSettings.ini", (Object)e);
        }
        this.plotFrameRate.set(this.settings.plotFrameRateEnabled());
        this.setVsync(this.settings.vsyncEnabled());
        this.lockPanelsWithinWindows.set(this.settings.getlockPanelsWithinWindows());
        this.setForegroundFPSLimit(this.settings.getForegroundFPSLimit());
        this.libGDXLogLevel.set(this.settings.getLibGDXLogLevel());
        this.imguiFontSize.set(this.settings.getFontSize());
        ImGuiTools.CURRENT_FONT_SIZE = this.imguiFontSize.get();
        try {
            this.setTheme(Theme.valueOf(this.settings.getThemeName()));
        }
        catch (IllegalArgumentException e) {
            LogTools.error((String)"Invalid theme name in RDXSettings.ini");
        }
        this.view3DBackgroundShade.set((double)this.settings.getView3DBackgroundShade());
    }

    public void launchRDXApplication(Lwjgl3ApplicationAdapter applicationAdapter) {
        LogTools.info((String)"Launching RDX application");
        Lwjgl3ApplicationConfiguration applicationConfiguration = LibGDXApplicationCreator.getDefaultConfiguration(this.windowTitle);
        applicationConfiguration.setInitialVisible(false);
        LibGDXApplicationCreator.launchGDXApplication(applicationConfiguration, applicationAdapter);
    }

    public void create() {
        this.create(RDXSceneLevel.MODEL, RDXSceneLevel.VIRTUAL);
    }

    public void create(RDXSceneLevel ... sceneLevels) {
        LogTools.info((String)"Creating...");
        LibGDXTools.printGLVersion();
        if (LibGDXTools.ENABLE_OPENGL_DEBUGGER) {
            this.glProfiler = LibGDXTools.createGLProfiler();
        }
        this.primaryScene.create(sceneLevels);
        this.primaryScene.addDefaultLighting();
        this.primary3DPanel.create(RDXInputMode.ImGui, this.glProfiler, this.primaryScene);
        this.imGuiWindowAndDockSystem.getPanelManager().addPanel(this.primary3DPanel);
        this.primary3DPanel.getIsShowing().set(true);
        Gdx.input.setInputProcessor(null);
        this.primary3DPanel.getCamera3D().changeCameraPosition(-0.7, -0.7, 0.7);
        this.primaryScene.addCoordinateFrame(0.3);
        this.imGuiWindowAndDockSystem.create(((Lwjgl3Graphics)Gdx.graphics).getWindow().getWindowHandle());
        ImGuiTools.CURRENT_FONT_SIZE = this.imguiFontSize.get();
        ImGuiLabelledWidgetAligner widgetAligner = new ImGuiLabelledWidgetAligner();
        this.ambientLightIntensitySlider = new ImGuiSliderDoubleWrapper("Ambient light intensity", "%.2f", 0.0, 0.05, () -> this.primaryScene.getAmbientLightIntensity(), value -> this.primaryScene.setAmbientLightIntensity((float)value));
        this.ambientLightIntensitySlider.addWidgetAligner(widgetAligner);
        this.pointLightIntensitySlider = new ImGuiSliderDoubleWrapper("Point light intensity", "%.1f", 0.0, 1000.0, () -> this.primaryScene.getPointLightIntensity(), value -> this.primaryScene.setPointLightIntensity((float)value));
        this.pointLightIntensitySlider.addWidgetAligner(widgetAligner);
        this.directionalLightIntensitySlider = new ImGuiSliderDoubleWrapper("Directional light intensity", "%.1f", 0.0, 10.0, () -> this.primaryScene.getDirectionalLightIntensity(), value -> this.primaryScene.setDirectionalLightIntensity((float)value));
        this.directionalLightIntensitySlider.addWidgetAligner(widgetAligner);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> Gdx.app.exit(), "Exit" + this.getClass().getSimpleName()));
        this.vrManager.create();
        this.primaryScene.addRenderableProvider(this.vrManager::getVirtualRenderables, RDXSceneLevel.VIRTUAL);
        this.primary3DPanel.addImGui3DViewPickCalculator(this.vrManager::calculate3DViewPick);
        this.primary3DPanel.addImGui3DViewInputProcessor(this.vrManager::process3DViewInput);
        this.loadSettings();
        this.keyBindings.register("Show key bindings", "Tab");
    }

    public void renderBeforeOnScreenUI() {
        this.vrManager.pollEventsAndRender(this, this.primaryScene);
        Gdx.graphics.setTitle(this.windowTitle);
        this.imGuiWindowAndDockSystem.beforeWindowManagement(this.settings.getlockPanelsWithinWindows());
        this.primary3DPanel.render();
        for (RDX3DPanel additional3DPanel : this.additional3DPanels) {
            additional3DPanel.render();
        }
        this.renderMenuBar();
        this.keyBindings.renderKeyBindingsTable();
    }

    public void renderEnd() {
        this.imGuiWindowAndDockSystem.afterWindowManagement();
        ++this.renderIndex;
        if (this.renderIndex == 2L) {
            ((Lwjgl3Graphics)Gdx.graphics).getWindow().setVisible(true);
        }
    }

    private void renderMenuBar() {
        ImGui.beginMainMenuBar();
        this.layoutManager.renderImGuiLayoutMenu();
        if (ImGui.beginMenu((String)"Panels")) {
            this.imGuiWindowAndDockSystem.renderMenuDockPanelItems();
            ImGui.endMenu();
        }
        if (ImGui.beginMenu((String)"Settings")) {
            if (ImGui.beginTable((String)"settingsTable", (int)2, (int)0)) {
                int i;
                ImGui.tableNextRow();
                ImGui.tableSetColumnIndex((int)0);
                ImGui.alignTextToFramePadding();
                ImGui.text((String)"LibGDX log level: ");
                ImGui.tableSetColumnIndex((int)1);
                for (i = 0; i <= 3; ++i) {
                    String logLevelName = "";
                    switch (i) {
                        case 0: {
                            logLevelName = "None";
                            break;
                        }
                        case 1: {
                            logLevelName = "Error";
                            break;
                        }
                        case 2: {
                            logLevelName = "Info";
                            break;
                        }
                        case 3: {
                            logLevelName = "Debug";
                        }
                    }
                    if (ImGui.radioButton((String)this.labels.get(logLevelName), (Gdx.app.getLogLevel() == i ? 1 : 0) != 0)) {
                        this.settings.setLibGDXLogLevel(i);
                        Gdx.app.setLogLevel(i);
                        ImGui.closeCurrentPopup();
                    }
                    ImGui.sameLine();
                }
                ImGui.tableNextRow();
                ImGui.tableSetColumnIndex((int)0);
                ImGui.alignTextToFramePadding();
                ImGui.text((String)"Theme: ");
                ImGui.tableSetColumnIndex((int)1);
                for (i = 0; i < Theme.values().length; ++i) {
                    if (ImGui.radioButton((String)this.labels.get(StringUtils.capitalize((String)Theme.values()[i].name().toLowerCase())), (this.theme == Theme.values()[i] ? 1 : 0) != 0)) {
                        Theme newTheme = Theme.values()[i];
                        this.setTheme(newTheme);
                        ImGui.closeCurrentPopup();
                    }
                    if (i >= Theme.values().length - 1) continue;
                    ImGui.sameLine();
                }
                ImGui.tableNextRow();
                ImGui.tableSetColumnIndex((int)0);
                ImGui.alignTextToFramePadding();
                ImGui.text((String)"Background shade: ");
                ImGui.tableSetColumnIndex((int)1);
                if (ImGuiTools.sliderDouble(this.labels.get("##view3DBackgroundShadeSlider"), this.view3DBackgroundShade, 0.0, 1.0)) {
                    this.setView3DBackgroundShade((float)this.view3DBackgroundShade.get());
                }
                if (ImGui.isItemDeactivatedAfterEdit()) {
                    this.settings.setView3DBackgroundShade((float)this.view3DBackgroundShade.get());
                }
                ImGui.sameLine();
                if (ImGui.button((String)this.labels.get("Reset##BackgroundShade"))) {
                    this.view3DBackgroundShade.set(0.501960813999176);
                    this.settings.setView3DBackgroundShade((float)this.view3DBackgroundShade.get());
                    this.setView3DBackgroundShade((float)this.view3DBackgroundShade.get());
                }
                ImGui.tableNextRow();
                ImGui.tableSetColumnIndex((int)0);
                ImGui.alignTextToFramePadding();
                ImGui.text((String)"FPS limit: ");
                if (this.vsync.get()) {
                    ImGui.pushItemFlag((int)4, (boolean)true);
                    ImGui.pushStyleVar((int)0, (float)(ImGui.getStyle().getAlpha() * 0.5f));
                }
                ImGui.tableSetColumnIndex((int)1);
                if (this.foregroundFPSLimit.get() < 15) {
                    this.foregroundFPSLimit.set(15);
                }
                if (!ImGuiTools.sliderInt(this.labels.get("##foregroundFPSLimitSlider"), this.foregroundFPSLimit, 15, 240) && !ImGui.isItemActive() && this.settings.getForegroundFPSLimit() != this.foregroundFPSLimit.get()) {
                    this.settings.setForegroundFPSLimit(this.foregroundFPSLimit.get());
                    this.setForegroundFPSLimit(this.foregroundFPSLimit.get());
                }
                if (this.vsync.get()) {
                    ImGui.popStyleVar();
                    ImGui.popItemFlag();
                }
                ImGui.tableNextRow();
                ImGui.tableSetColumnIndex((int)0);
                ImGui.alignTextToFramePadding();
                ImGui.text((String)"Font size: ");
                ImGui.tableSetColumnIndex((int)1);
                if (ImGui.sliderInt((String)this.labels.getHidden("fontSize"), (int[])this.imguiFontSize.getData(), (int)ImGuiTools.SMALLEST_FONT_SIZE, (int)ImGuiTools.LARGEST_FONT_SIZE, (String)"%d")) {
                    // empty if block
                }
                if (ImGui.isItemDeactivatedAfterEdit()) {
                    this.settings.setFontSize(this.imguiFontSize.get());
                    ImGuiTools.CURRENT_FONT_SIZE = this.imguiFontSize.get();
                }
                ImGui.sameLine();
                if (ImGui.button((String)this.labels.get("Reset##FontSize"))) {
                    this.imguiFontSize.set(ImGuiTools.DEFAULT_FONT_SIZE);
                    this.settings.setFontSize(this.imguiFontSize.get());
                    ImGuiTools.CURRENT_FONT_SIZE = this.imguiFontSize.get();
                }
                ImGui.endTable();
            }
            if (ImGui.menuItem((String)this.labels.get("Frame rate plot"), null, (ImBoolean)this.plotFrameRate)) {
                this.settings.setPlotFrameRate(this.plotFrameRate.get());
            }
            if (ImGui.menuItem((String)this.labels.get("Vsync"), null, (ImBoolean)this.vsync)) {
                this.settings.setVsync(this.vsync.get());
                Gdx.graphics.setForegroundFPS(Integer.MAX_VALUE);
                Gdx.graphics.setVSync(this.vsync.get());
            }
            if (ImGui.menuItem((String)this.labels.get("Lock panels within windows"), null, (ImBoolean)this.lockPanelsWithinWindows)) {
                this.settings.setlockPanelsWithinWindows(this.lockPanelsWithinWindows.get());
            }
            ImGui.separator();
            boolean renderingGroundTruthEnvironment = this.primaryScene.getSceneLevelsToRender().contains((Object)RDXSceneLevel.GROUND_TRUTH);
            if (ImGui.menuItem((String)this.labels.get("Render Ground Truth Environment"), null, (boolean)renderingGroundTruthEnvironment)) {
                if (renderingGroundTruthEnvironment) {
                    this.primaryScene.getSceneLevelsToRender().remove((Object)RDXSceneLevel.GROUND_TRUTH);
                } else {
                    this.primaryScene.getSceneLevelsToRender().add(RDXSceneLevel.GROUND_TRUTH);
                }
            }
            boolean renderingModelEnvironment = this.primaryScene.getSceneLevelsToRender().contains((Object)RDXSceneLevel.MODEL);
            if (ImGui.menuItem((String)this.labels.get("Render Model Environment"), null, (boolean)renderingModelEnvironment)) {
                if (renderingModelEnvironment) {
                    this.primaryScene.getSceneLevelsToRender().remove((Object)RDXSceneLevel.MODEL);
                } else {
                    this.primaryScene.getSceneLevelsToRender().add(RDXSceneLevel.MODEL);
                }
            }
            boolean renderingVirtualEnvironment = this.primaryScene.getSceneLevelsToRender().contains((Object)RDXSceneLevel.VIRTUAL);
            if (ImGui.menuItem((String)this.labels.get("Render Virtual Environment"), null, (boolean)renderingVirtualEnvironment)) {
                if (renderingVirtualEnvironment) {
                    this.primaryScene.getSceneLevelsToRender().remove((Object)RDXSceneLevel.VIRTUAL);
                } else {
                    this.primaryScene.getSceneLevelsToRender().add(RDXSceneLevel.VIRTUAL);
                }
            }
            ImGui.separator();
            this.ambientLightIntensitySlider.renderImGuiWidget();
            this.pointLightIntensitySlider.renderImGuiWidget();
            this.directionalLightIntensitySlider.renderImGuiWidget();
            ImGui.separator();
            if (ImGui.menuItem((String)this.labels.get("Model scene mouse collision enabled"), null, (ImBoolean)this.modelSceneMouseCollisionEnabled)) {
                this.setModelSceneMouseCollisionEnabled(this.modelSceneMouseCollisionEnabled.get());
            }
            if (ImGui.menuItem((String)this.labels.get("Middle-click view orbit"), null, (ImBoolean)this.middleClickOrbit)) {
                this.setUseMiddleClickViewOrbit(this.middleClickOrbit.get());
            }
            if (ImGui.menuItem((String)"Show key bindings...")) {
                this.keyBindings.showKeybindings();
            }
            ImGui.endMenu();
        }
        this.vrManager.renderMenuBar();
        this.frameRateDisplay.ping();
        if (this.plotFrameRate.get()) {
            float menuBarStatusWidth = 212.0f;
            ImGui.sameLine((float)(ImGui.getWindowSizeX() - menuBarStatusWidth));
            this.frameRateDisplay.renderPlot();
        } else {
            float menuBarStatusWidth = 110.0f;
            ImGui.sameLine((float)(ImGui.getWindowSizeX() - menuBarStatusWidth));
        }
        this.frameRateDisplay.renderHz();
        ImGui.text((String)(FormattingTools.getFormattedDecimal2D((double)this.runTime.totalElapsed()) + " s"));
        ImGui.endMainMenuBar();
    }

    public void dispose() {
        this.imGuiWindowAndDockSystem.dispose();
        this.vrManager.dispose();
        this.primaryScene.dispose();
        instance = null;
    }

    public void add3DPanel(RDX3DPanel panel3D) {
        this.add3DPanel(panel3D, this.primaryScene);
    }

    public void add3DPanel(RDX3DPanel panel3D, RDX3DScene scene3D) {
        panel3D.create(RDXInputMode.ImGui, this.glProfiler, scene3D);
        panel3D.getCamera3D().changeCameraPosition(-0.7, -0.7, 0.7);
        this.imGuiWindowAndDockSystem.getPanelManager().addPanel(panel3D);
        this.additional3DPanels.add(panel3D);
    }

    public void addOnCloseRequestListener(Runnable onCloseRequest) {
        this.onCloseRequestListeners.add(onCloseRequest);
    }

    public void setStatus(String statusText) {
        this.statusText = statusText;
    }

    public void setVsync(boolean enabled) {
        this.vsync.set(enabled);
        Gdx.graphics.setVSync(enabled);
    }

    public void setForegroundFPSLimit(int foregroundFPSLimit) {
        this.foregroundFPSLimit.set(foregroundFPSLimit);
        Gdx.graphics.setForegroundFPS(foregroundFPSLimit);
    }

    public RDXPanelManager getImGuiPanelManager() {
        return this.imGuiWindowAndDockSystem.getPanelManager();
    }

    public RDXImGuiLayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    public RDXKeyBindings getKeyBindings() {
        return this.keyBindings;
    }

    public RDX3DScene getPrimaryScene() {
        return this.primaryScene;
    }

    public RDX3DPanel getPrimary3DPanel() {
        return this.primary3DPanel;
    }

    public RDXVRManager getVRManager() {
        return this.vrManager;
    }

    public RDXImGuiWindowAndDockSystem getImGuiWindowAndDockSystem() {
        return this.imGuiWindowAndDockSystem;
    }

    public HybridDirectory getConfigurationBaseDirectory() {
        return this.configurationBaseDirectory;
    }

    public long getRenderIndex() {
        return this.renderIndex;
    }

    public void setUseMiddleClickViewOrbit(boolean useMiddleClickViewOrbit) {
        this.middleClickOrbit.set(useMiddleClickViewOrbit);
        this.primary3DPanel.getCamera3D().setUseMiddleClickViewOrbit(useMiddleClickViewOrbit);
        for (RDX3DPanel additional3DPanel : this.additional3DPanels) {
            additional3DPanel.getCamera3D().setUseMiddleClickViewOrbit(useMiddleClickViewOrbit);
        }
    }

    public void setView3DBackgroundShade(float shade) {
        this.view3DBackgroundShade.set((double)shade);
        this.primary3DPanel.setBackgroundShade(shade);
        for (RDX3DPanel additional3DPanel : this.additional3DPanels) {
            additional3DPanel.setBackgroundShade(shade);
        }
    }

    public void setModelSceneMouseCollisionEnabled(boolean modelSceneMouseCollisionEnabled) {
        this.modelSceneMouseCollisionEnabled.set(modelSceneMouseCollisionEnabled);
        this.primary3DPanel.setModelSceneMouseCollisionEnabled(modelSceneMouseCollisionEnabled);
        for (RDX3DPanel additional3DPanel : this.additional3DPanels) {
            additional3DPanel.setModelSceneMouseCollisionEnabled(modelSceneMouseCollisionEnabled);
        }
    }

    public void setTheme(Theme theme) {
        this.settings.setThemeName(theme.name());
        switch (theme) {
            case LIGHT: {
                ImGui.styleColorsLight();
                break;
            }
            case DARK: {
                ImGui.styleColorsDark();
                break;
            }
            case CLASSIC: {
                ImGui.styleColorsClassic();
            }
        }
        this.theme = theme;
    }

    public Theme getTheme() {
        return this.theme;
    }

    public static void pushNotification(String text) {
        instance.getPrimary3DPanel().getNotificationManager().pushNotification(2, text);
    }

    private static enum Theme {
        LIGHT,
        DARK,
        CLASSIC;

    }
}

