/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.ui;

import com.badlogic.gdx.graphics.Color;
import imgui.ImFont;
import imgui.ImGui;
import imgui.ImVec2;
import us.ihmc.rdx.imgui.ImGuiTools;
import us.ihmc.rdx.input.ImGui3DViewInput;
import us.ihmc.rdx.ui.RDX3DPanel;

public class RDX3DPanelTooltip {
    private final RDX3DPanel panel3D;
    private ImGui3DViewInput latestInput;
    private final Color color = new Color(0.2f, 0.2f, 0.2f, 0.7f);
    private final ImVec2 textSize = new ImVec2();

    public RDX3DPanelTooltip(RDX3DPanel panel3D) {
        this.panel3D = panel3D;
    }

    public void setInput(ImGui3DViewInput latestInput) {
        this.latestInput = latestInput;
    }

    public void render(String text) {
        this.render(text, 0);
    }

    public void render(String text, int linesOfSpaceToGiveAbove) {
        if (this.latestInput != null) {
            float lineHeight = ImGui.getFrameHeight();
            ImFont font = ImGuiTools.getSmallFont();
            ImGui.pushFont((ImFont)font);
            ImGui.calcTextSize((ImVec2)this.textSize, (String)text);
            ImGui.popFont();
            float marginLeft = 10.0f;
            float marginRight = 10.0f;
            float marginTop = 10.0f;
            float marginBottom = 6.0f;
            float mousePosX = this.latestInput.getMousePosX();
            float mousePosY = this.latestInput.getMousePosY();
            float drawStartX = this.panel3D.getWindowDrawMinX() + mousePosX + marginLeft;
            float drawStartY = this.panel3D.getWindowDrawMinY() + mousePosY + marginTop + (float)linesOfSpaceToGiveAbove * lineHeight;
            float drawEndX = drawStartX + this.textSize.x + marginRight;
            float drawEndY = drawStartY + this.textSize.y + marginBottom;
            ImGui.getWindowDrawList().addRectFilled(drawStartX, drawStartY, drawEndX, drawEndY, this.color.toIntBits());
            float textPositionX = drawStartX + 5.0f;
            float textPositionY = drawStartY + 2.0f;
            ImGui.getWindowDrawList().addText(font, font.getFontSize(), textPositionX, textPositionY, Color.WHITE.toIntBits(), text);
        }
    }
}

