/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.SensorFrameBuffer;
import com.badlogic.gdx.graphics.glutils.SensorFrameBufferBuilder;
import com.badlogic.gdx.graphics.profiling.GLProfiler;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import imgui.ImGui;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.lwjgl.opengl.GL41;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.rdx.RDXFocusBasedCamera;
import us.ihmc.rdx.imgui.ImGuiTools;
import us.ihmc.rdx.imgui.RDXPanel;
import us.ihmc.rdx.imgui.RDXPanelSizeHandler;
import us.ihmc.rdx.input.ImGui3DViewInput;
import us.ihmc.rdx.input.RDXInputMode;
import us.ihmc.rdx.sceneManager.RDX3DScene;
import us.ihmc.rdx.sceneManager.RDX3DSceneTools;
import us.ihmc.rdx.sceneManager.RDXSceneLevel;
import us.ihmc.rdx.tools.LibGDXTools;
import us.ihmc.rdx.ui.RDX3DOverlayPanel;
import us.ihmc.rdx.ui.RDX3DPanelNotificationManager;
import us.ihmc.rdx.ui.RDX3DPanelToolbar;
import us.ihmc.rdx.ui.RDX3DPanelToolbarButton;

public class RDX3DPanel
extends RDXPanel {
    public static final int OVERLAY_BACKGROUND_COLOR = new Color(1.0f, 1.0f, 1.0f, 0.5f).toIntBits();
    private final RDXPanelSizeHandler view3DPanelSizeHandler = new RDXPanelSizeHandler();
    private final String panelName;
    private final int antiAliasing;
    private RDX3DScene scene;
    private boolean modelSceneMouseCollisionEnabled = false;
    private GLProfiler glProfiler;
    private SensorFrameBuffer frameBuffer;
    private float windowSizeX;
    private float windowSizeY;
    private ImGui3DViewInput inputCalculator;
    private final ArrayList<Consumer<ImGui3DViewInput>> imgui3DViewPickCalculators = new ArrayList();
    private final ArrayList<Consumer<ImGui3DViewInput>> imgui3DViewInputProcessors = new ArrayList();
    private final Map<Object, Consumer<ImGui3DViewInput>> imgui3DViewPickCalculatorOwnerKeyMap = new HashMap<Object, Consumer<ImGui3DViewInput>>();
    private final Map<Object, Consumer<ImGui3DViewInput>> imgui3DViewInputProcessorOwnerKeyMap = new HashMap<Object, Consumer<ImGui3DViewInput>>();
    private final RDX3DPanelToolbar toolbar = new RDX3DPanelToolbar();
    private final ArrayList<Runnable> imGuiOverlayAdditions = new ArrayList();
    private final TreeMap<String, RDX3DOverlayPanel> overlayPanels = new TreeMap();
    private final Map<Object, Runnable> imGuiOverlayAdditionOwnerKeyMap = new HashMap<Object, Runnable>();
    private InputMultiplexer inputMultiplexer;
    private RDXFocusBasedCamera camera3D;
    private ScreenViewport viewport;
    private int x = 0;
    private int y = 0;
    private int width = -1;
    private int height = -1;
    private boolean firstRenderStarted = false;
    private boolean addFocusSphere;
    private Runnable backgroundRenderer;
    private float backgroundShade = 0.5019608f;
    private ByteBuffer normalizedDeviceCoordinateDepthDirectByteBuffer;
    private float renderSizeX;
    private float renderSizeY;
    private float windowDrawMinX;
    private float windowDrawMinY;
    private float windowDrawMaxX;
    private float windowDrawMaxY;
    private float windowPositionX;
    private float windowPositionY;
    private final RDX3DPanelNotificationManager notificationManager = new RDX3DPanelNotificationManager(this);

    public RDX3DPanel(String panelName) {
        this(panelName, 2, true);
    }

    public RDX3DPanel(String panelName, boolean addFocusSphere) {
        this(panelName, 2, addFocusSphere);
    }

    public RDX3DPanel(String panelName, int antiAliasing, boolean addFocusSphere) {
        super(panelName);
        super.setRenderMethod(null);
        this.panelName = panelName;
        this.antiAliasing = antiAliasing;
        this.addFocusSphere = addFocusSphere;
    }

    public void create(RDXInputMode inputMode, GLProfiler glProfiler, RDX3DScene scene) {
        this.glProfiler = glProfiler;
        this.scene = scene;
        this.camera3D = new RDXFocusBasedCamera();
        if (inputMode == RDXInputMode.libGDX) {
            this.inputMultiplexer = new InputMultiplexer();
            Gdx.input.setInputProcessor((InputProcessor)this.inputMultiplexer);
            this.inputMultiplexer.addProcessor(this.camera3D.setInputForLibGDX());
        }
        this.inputCalculator = new ImGui3DViewInput(this);
        this.imgui3DViewInputProcessors.add(this.camera3D::processImGuiInput);
        if (this.addFocusSphere) {
            scene.addModelInstance(this.camera3D.getFocusPointSphere(), RDXSceneLevel.VIRTUAL);
        }
        this.viewport = new ScreenViewport((Camera)this.camera3D);
        this.viewport.setUnitsPerPixel(1.0f);
        this.addImGuiOverlayAddition(this.notificationManager::render);
    }

    public void render() {
        if (this.getIsShowing().get() && ImGuiTools.getCurrentContext() != 0L) {
            this.view3DPanelSizeHandler.handleSizeBeforeBegin();
            ImGui.pushStyleVar((int)2, (float)0.0f, (float)0.0f);
            int flags = 0;
            ImGui.begin((String)this.panelName, (int)flags);
            this.view3DPanelSizeHandler.handleSizeAfterBegin();
            ImGui.popStyleVar();
            this.windowPositionX = ImGui.getWindowPosX();
            this.windowPositionY = ImGui.getWindowPosY() + ImGuiTools.TAB_BAR_HEIGHT;
            this.windowSizeX = ImGui.getWindowSizeX();
            this.windowSizeY = ImGui.getWindowSizeY() - ImGuiTools.TAB_BAR_HEIGHT;
            this.renderSizeX = this.windowSizeX * (float)this.antiAliasing;
            this.renderSizeY = this.windowSizeY * (float)this.antiAliasing;
            this.inputCalculator.compute();
            if (this.inputCalculator.isWindowHovered()) {
                for (Consumer<ImGui3DViewInput> imgui3DViewPickCalculator : this.imgui3DViewPickCalculators) {
                    imgui3DViewPickCalculator.accept(this.inputCalculator);
                }
                this.inputCalculator.calculateClosestPick();
            }
            for (Consumer<ImGui3DViewInput> imGuiInputProcessor : this.imgui3DViewInputProcessors) {
                imGuiInputProcessor.accept(this.inputCalculator);
            }
            if (this.frameBuffer == null || (float)this.frameBuffer.getWidth() < this.renderSizeX || (float)this.frameBuffer.getHeight() < this.renderSizeY) {
                if (this.frameBuffer != null) {
                    this.frameBuffer.dispose();
                }
                int newWidth = this.frameBuffer == null ? Gdx.graphics.getWidth() * this.antiAliasing : this.frameBuffer.getWidth() * 2;
                int newHeight = this.frameBuffer == null ? Gdx.graphics.getHeight() * this.antiAliasing : this.frameBuffer.getHeight() * 2;
                LogTools.info((String)"Allocating framebuffer of size: {}x{}", (Object)newWidth, (Object)newHeight);
                SensorFrameBufferBuilder frameBufferBuilder = new SensorFrameBufferBuilder(newWidth, newHeight);
                frameBufferBuilder.addColorTextureAttachment(32856, 6408, 5121);
                frameBufferBuilder.addDepthTextureAttachment(36012, 5126);
                frameBufferBuilder.addColorTextureAttachment(33326, 6403, 5126);
                this.frameBuffer = frameBufferBuilder.build();
                int bytesPerPixel = 4;
                this.normalizedDeviceCoordinateDepthDirectByteBuffer = ByteBuffer.allocateDirect(newWidth * newHeight * bytesPerPixel);
                this.normalizedDeviceCoordinateDepthDirectByteBuffer.order(ByteOrder.nativeOrder());
            }
            this.setViewportBounds(0, 0, (int)this.renderSizeX, (int)this.renderSizeY);
            int frameBufferWidth = this.frameBuffer.getWidth();
            int frameBufferHeight = this.frameBuffer.getHeight();
            if (this.modelSceneMouseCollisionEnabled && this.scene.getSceneLevelsToRender().contains((Object)RDXSceneLevel.MODEL)) {
                this.frameBuffer.begin();
                this.renderScene(RDXSceneLevel.MODEL.SINGLETON_SET);
                this.normalizedDeviceCoordinateDepthDirectByteBuffer.rewind();
                GL41.glReadBuffer((int)36096);
                GL41.glPixelStorei((int)3317, (int)4);
                GL41.glReadPixels((int)0, (int)0, (int)((int)this.renderSizeX), (int)((int)this.renderSizeY), (int)6402, (int)5126, (ByteBuffer)this.normalizedDeviceCoordinateDepthDirectByteBuffer);
                GL41.glPixelStorei((int)3317, (int)1);
                this.frameBuffer.end();
            }
            this.frameBuffer.begin();
            this.renderScene(this.scene.getSceneLevelsToRender());
            this.frameBuffer.end();
            float percentOfFramebufferUsedX = this.renderSizeX / (float)frameBufferWidth;
            float percentOfFramebufferUsedY = this.renderSizeY / (float)frameBufferHeight;
            int textureID = ((Texture)this.frameBuffer.getColorBufferTexture()).getTextureObjectHandle();
            this.windowDrawMinX = this.windowPositionX;
            this.windowDrawMinY = this.windowPositionY;
            this.windowDrawMaxX = this.windowPositionX + this.windowSizeX;
            this.windowDrawMaxY = this.windowPositionY + this.windowSizeY;
            float uvMinX = 0.0f;
            float uvMinY = percentOfFramebufferUsedY;
            float uvMaxX = percentOfFramebufferUsedX;
            float uvMaxY = 0.0f;
            ImGui.getWindowDrawList().addImage(textureID, this.windowDrawMinX, this.windowDrawMinY, this.windowDrawMaxX, this.windowDrawMaxY, uvMinX, uvMinY, uvMaxX, uvMaxY);
            for (Runnable imguiOverlayAddition : this.imGuiOverlayAdditions) {
                imguiOverlayAddition.run();
            }
            float previousActiveWindowY = this.getWindowPositionY() + 10.0f;
            for (String overlayPanelName : this.overlayPanels.keySet()) {
                RDX3DOverlayPanel overlayPanel = this.overlayPanels.get(overlayPanelName);
                previousActiveWindowY = overlayPanel.render(previousActiveWindowY);
            }
            this.toolbar.render(this.windowSizeX, this.windowPositionX, this.windowPositionY);
            if (ImGui.isWindowHovered() && ImGui.isMouseDoubleClicked((int)1)) {
                this.camera3D.setCameraFocusPoint((Tuple3DReadOnly)this.inputCalculator.getPickPointInWorld());
            }
            ImGui.end();
        }
    }

    private void renderScene(Set<RDXSceneLevel> sceneLevels) {
        this.preRender();
        if (this.backgroundRenderer != null) {
            this.backgroundRenderer.run();
        }
        this.scene.render(sceneLevels);
        this.scene.postRender();
        if (LibGDXTools.ENABLE_OPENGL_DEBUGGER) {
            this.glProfiler.reset();
        }
    }

    private void preRender() {
        if (!this.firstRenderStarted) {
            this.firstRenderStarted = true;
            LogTools.info((String)"Starting first render.");
        }
        if (this.width < 0) {
            this.width = this.getCurrentWindowWidth();
        }
        if (this.height < 0) {
            this.height = this.getCurrentWindowHeight();
        }
        this.viewport.update(this.width, this.height);
        this.scene.preRender(this.camera3D);
        GL41.glViewport((int)this.x, (int)this.y, (int)this.width, (int)this.height);
        RDX3DSceneTools.glClearGray(this.backgroundShade);
    }

    public void dispose() {
        ExceptionTools.handle(() -> this.camera3D.dispose(), (ExceptionHandler)DefaultExceptionHandler.PRINT_MESSAGE);
    }

    public void setViewportBoundsToWindow() {
        this.setViewportBounds(0, 0, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
    }

    public void setViewportBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public int getCurrentWindowWidth() {
        return Gdx.graphics.getWidth();
    }

    public int getCurrentWindowHeight() {
        return Gdx.graphics.getHeight();
    }

    public RDXFocusBasedCamera getCamera3D() {
        return this.camera3D;
    }

    public void addLibGDXInputProcessor(InputProcessor inputProcessor) {
        if (this.inputMultiplexer != null) {
            this.inputMultiplexer.addProcessor(inputProcessor);
        } else {
            LogTools.error((int)1, (Object)"libGDX is not being used for input!");
        }
    }

    public RDX3DPanelToolbarButton addToolbarButton() {
        return this.toolbar.addButton();
    }

    public void setAddFocusSphere(boolean addFocusSphere) {
        this.addFocusSphere = addFocusSphere;
    }

    public void setBackgroundRenderer(Runnable backgroundRenderer) {
        this.backgroundRenderer = backgroundRenderer;
    }

    public float getViewportSizeX() {
        return this.windowSizeX;
    }

    public float getViewportSizeY() {
        return this.windowSizeY;
    }

    public void addImGui3DViewPickCalculator(Consumer<ImGui3DViewInput> calculate3DViewPick) {
        this.imgui3DViewPickCalculators.add(calculate3DViewPick);
    }

    public void addImGui3DViewInputProcessor(Consumer<ImGui3DViewInput> processImGuiInput) {
        this.imgui3DViewInputProcessors.add(processImGuiInput);
    }

    public void addImGuiOverlayAddition(Runnable imGuiOverlayAddition) {
        this.imGuiOverlayAdditions.add(imGuiOverlayAddition);
    }

    public boolean overlayPanelExists(String panelName) {
        return this.overlayPanels.containsKey(panelName);
    }

    public void addOverlayPanel(String panelName, Runnable imGuiRender) {
        RDX3DOverlayPanel panel = new RDX3DOverlayPanel(panelName, imGuiRender, this);
        this.overlayPanels.put(panelName, panel);
    }

    public void removeOverlayPanel(String panelName) {
        this.overlayPanels.remove(panelName);
    }

    public void addImGui3DViewPickCalculator(Object ownerKey, Consumer<ImGui3DViewInput> calculate3DViewPick) {
        this.imgui3DViewPickCalculatorOwnerKeyMap.put(ownerKey, calculate3DViewPick);
        this.imgui3DViewPickCalculators.add(calculate3DViewPick);
    }

    public void addImGui3DViewInputProcessor(Object ownerKey, Consumer<ImGui3DViewInput> processImGuiInput) {
        this.imgui3DViewInputProcessorOwnerKeyMap.put(ownerKey, processImGuiInput);
        this.imgui3DViewInputProcessors.add(processImGuiInput);
    }

    public void addImGuiOverlayAddition(Object ownerKey, Runnable imGuiOverlayAddition) {
        this.imGuiOverlayAdditionOwnerKeyMap.put(ownerKey, imGuiOverlayAddition);
        this.imGuiOverlayAdditions.add(imGuiOverlayAddition);
    }

    public void removeImGui3DViewPickCalculator(Object ownerKey) {
        this.imgui3DViewPickCalculators.remove(this.imgui3DViewPickCalculatorOwnerKeyMap.remove(ownerKey));
    }

    public void removeImGui3DViewInputProcessor(Object ownerKey) {
        this.imgui3DViewInputProcessors.remove(this.imgui3DViewInputProcessorOwnerKeyMap.remove(ownerKey));
    }

    public void removeImGuiOverlayAddition(Object ownerKey) {
        Runnable item = this.imGuiOverlayAdditionOwnerKeyMap.remove(ownerKey);
        this.imGuiOverlayAdditionOwnerKeyMap.remove(item);
    }

    public RDX3DScene getScene() {
        return this.scene;
    }

    public SensorFrameBuffer getFrameBuffer() {
        return this.frameBuffer;
    }

    public ByteBuffer getNormalizedDeviceCoordinateDepthDirectByteBuffer() {
        return this.normalizedDeviceCoordinateDepthDirectByteBuffer;
    }

    public int getAntiAliasing() {
        return this.antiAliasing;
    }

    public float getRenderSizeX() {
        return this.renderSizeX;
    }

    public float getRenderSizeY() {
        return this.renderSizeY;
    }

    public float getWindowDrawMinX() {
        return this.windowDrawMinX;
    }

    public float getWindowDrawMinY() {
        return this.windowDrawMinY;
    }

    public float getWindowDrawMaxX() {
        return this.windowDrawMaxX;
    }

    public float getWindowDrawMaxY() {
        return this.windowDrawMaxY;
    }

    public void setBackgroundShade(float backgroundShade) {
        this.backgroundShade = backgroundShade;
    }

    public void setModelSceneMouseCollisionEnabled(boolean modelSceneMouseCollisionEnabled) {
        this.modelSceneMouseCollisionEnabled = modelSceneMouseCollisionEnabled;
    }

    public float getWindowSizeX() {
        return this.windowSizeX;
    }

    public float getWindowPositionX() {
        return this.windowPositionX;
    }

    public float getWindowPositionY() {
        return this.windowPositionY;
    }

    public RDX3DPanelToolbar getToolbar() {
        return this.toolbar;
    }

    @Override
    public String getPanelName() {
        return this.panelName;
    }

    public RDX3DPanelNotificationManager getNotificationManager() {
        return this.notificationManager;
    }
}

