/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.ui;

import imgui.ImGui;
import us.ihmc.commons.InterpolationTools;
import us.ihmc.rdx.imgui.ImGuiUniqueLabelMap;
import us.ihmc.rdx.ui.RDX3DPanel;

public class RDX3DOverlayPanel {
    private final ImGuiUniqueLabelMap labels = new ImGuiUniqueLabelMap(this.getClass());
    private final String panelName;
    private final Runnable imGuiRender;
    private float windowActiveLerp;
    private final RDX3DPanel parent;

    public RDX3DOverlayPanel(String panelName, Runnable imGuiRender, RDX3DPanel parent) {
        this.panelName = panelName;
        this.imGuiRender = imGuiRender;
        this.parent = parent;
    }

    public float render(float previousActiveWindowY) {
        float panelWidth = 400.0f;
        float panelHeight = 300.0f * this.windowActiveLerp;
        ImGui.setNextWindowSize((float)panelWidth, (float)panelHeight);
        float startX = this.parent.getWindowPositionX() + (this.parent.getWindowSizeX() - panelWidth - 5.0f);
        float startY = previousActiveWindowY + 10.0f;
        ImGui.setNextWindowPos((float)startX, (float)startY);
        ImGui.setNextWindowBgAlpha((float)this.windowActiveLerp);
        int windowFlags = 38;
        ImGui.begin((String)this.labels.get(this.panelName), (int)windowFlags);
        this.windowActiveLerp = ImGui.isWindowHovered((int)161) ? 0.9f : (float)InterpolationTools.linearInterpolate((double)this.windowActiveLerp, (double)0.2f, (double)0.05f);
        this.imGuiRender.run();
        ImGui.end();
        return startY + panelHeight;
    }

    public String getPanelName() {
        return this.panelName;
    }
}

