/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.tools;

import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.graphics.g3d.model.NodePart;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.log.LogTools;
import us.ihmc.rdx.tools.LibGDXModelCopier;
import us.ihmc.rdx.tools.LibGDXTools;
import us.ihmc.rdx.tools.RDXModelInstance;
import us.ihmc.robotics.referenceFrames.MutableReferenceFrame;

public class RDXModelVertexScaling {
    private final Model model;
    private final Point3D32 wholeModelCentroid = new Point3D32();
    private final ArrayList<PartRecord> partRecords = new ArrayList();
    private ModelInstance modelInstance;
    private final FramePoint3D scaledVertex = new FramePoint3D();
    private final Vector3D32 centroidToVertex = new Vector3D32();
    private final MutableReferenceFrame centroidFrame = new MutableReferenceFrame(ReferenceFrame.getWorldFrame());
    private final Stopwatch stopwatch = new Stopwatch();

    public RDXModelVertexScaling(Model model) {
        this.model = LibGDXModelCopier.deepCopy(model);
        this.modelInstance = new RDXModelInstance(model);
        this.stopwatch.start();
        int totalNumberOfVertices = 0;
        for (int nodeIndex = 0; nodeIndex < model.nodes.size; ++nodeIndex) {
            Node node = (Node)model.nodes.get(nodeIndex);
            RigidBodyTransform transform = new RigidBodyTransform();
            Quaternion quaternion = new Quaternion();
            if (node.translation != null) {
                LibGDXTools.toEuclid(node.translation, transform.getTranslation());
            }
            if (node.rotation != null) {
                LibGDXTools.toEuclid(node.rotation, quaternion);
            }
            transform.getRotation().set((Orientation3DReadOnly)quaternion);
            for (int partIndex = 0; partIndex < node.parts.size; ++partIndex) {
                NodePart part = (NodePart)node.parts.get(partIndex);
                MeshPart meshPart = part.meshPart;
                Mesh mesh = meshPart.mesh;
                int vertexSize = 0;
                for (VertexAttribute attribute : meshPart.mesh.getVertexAttributes()) {
                    vertexSize += attribute.getSizeInBytes();
                }
                vertexSize /= 4;
                FloatBuffer verticesBuffer = mesh.getVerticesBuffer(false);
                ArrayList<OriginalVertexRecord> originalPartVertices = new ArrayList<OriginalVertexRecord>();
                int numVertices = mesh.getNumVertices();
                for (int i = 0; i < numVertices; ++i) {
                    float x = verticesBuffer.get(i * vertexSize);
                    float y = verticesBuffer.get(i * vertexSize + 1);
                    float z = verticesBuffer.get(i * vertexSize + 2);
                    Point3D32 originalVertex = new Point3D32(x, y, z);
                    if (System.nanoTime() % 10L == 0L) {
                        LogTools.info((String)"Original vertex: {}", (Object)originalVertex.toString());
                    }
                    transform.transform((Point3DBasics)originalVertex);
                    ++totalNumberOfVertices;
                    this.wholeModelCentroid.add((Tuple3DReadOnly)originalVertex);
                    originalPartVertices.add(new OriginalVertexRecord(originalVertex, i));
                }
                this.partRecords.add(new PartRecord(meshPart, transform, vertexSize, originalPartVertices));
            }
        }
        if (this.stopwatch.totalElapsed() > 0.5) {
            LogTools.warn((String)"Took {} s to initialize, which is a little long.", (Object)this.stopwatch.lapElapsed());
        }
        this.wholeModelCentroid.scale(1.0 / (double)totalNumberOfVertices);
        this.centroidFrame.update(transformToParent -> transformToParent.getTranslation().set((Tuple3DReadOnly)this.wholeModelCentroid));
    }

    private void scaleInternal(Model model, double scaleFactor) {
        this.stopwatch.start();
        float scaleFactorFloat = (float)scaleFactor;
        for (int j = 0; j < this.partRecords.size(); ++j) {
            PartRecord partRecord = this.partRecords.get(j);
            MeshPart meshPart = (MeshPart)model.meshParts.get(j);
            Mesh mesh = meshPart.mesh;
            FloatBuffer verticesBuffer = mesh.getVerticesBuffer(true);
            verticesBuffer.clear();
            for (int i = 0; i < mesh.getNumVertices(); ++i) {
                OriginalVertexRecord originalVertexRecord = partRecord.originalVertices().get(i);
                this.centroidToVertex.set((Tuple3DReadOnly)originalVertexRecord.originalVertex());
                this.centroidToVertex.sub((Tuple3DReadOnly)this.wholeModelCentroid);
                this.centroidToVertex.scale((double)scaleFactorFloat);
                this.scaledVertex.setIncludingFrame(this.centroidFrame.getReferenceFrame(), (Tuple3DReadOnly)this.centroidToVertex);
                this.scaledVertex.changeFrame(ReferenceFrame.getWorldFrame());
                partRecord.transform().inverseTransform((Point3DBasics)this.scaledVertex);
                if (System.nanoTime() % 10L == 0L) {
                    LogTools.info((String)"Scaled vertex: {}", (Object)this.scaledVertex.toString());
                }
                verticesBuffer.position(i * partRecord.vertexSize);
                verticesBuffer.put(this.scaledVertex.getX32());
                verticesBuffer.put(this.scaledVertex.getY32());
                verticesBuffer.put(this.scaledVertex.getZ32());
            }
        }
        if (this.stopwatch.totalElapsed() > 0.1) {
            LogTools.warn((String)"Took {} s to scale, which is a little long.", (Object)this.stopwatch.lapElapsed());
        }
    }

    public void scale(double scaleFactor) {
        this.scaleInternal(this.model, scaleFactor);
        this.modelInstance = new RDXModelInstance(this.model);
    }

    public Model getScaledDeepCopy(double scaleFactor) {
        Model copiedModel = LibGDXModelCopier.deepCopy(this.model);
        this.scaleInternal(copiedModel, scaleFactor);
        return copiedModel;
    }

    public Point3D32 getWholeModelCentroid() {
        return this.wholeModelCentroid;
    }

    public Matrix4 getPoseTransform() {
        return this.modelInstance.transform;
    }

    public ModelInstance getModelInstance() {
        return this.modelInstance;
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        this.modelInstance.getRenderables(renderables, pool);
    }

    private record OriginalVertexRecord(Point3D32 originalVertex, int index) {
    }

    private record PartRecord(MeshPart meshPart, RigidBodyTransform transform, int vertexSize, ArrayList<OriginalVertexRecord> originalVertices) {
    }
}

