/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.tools;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.loader.G3dModelLoader;
import com.badlogic.gdx.utils.BaseJsonReader;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.SerializationException;
import com.badlogic.gdx.utils.UBJsonReader;
import java.util.HashMap;
import java.util.TreeSet;
import net.mgsx.gltf.loaders.glb.GLBLoader;
import net.mgsx.gltf.loaders.gltf.GLTFLoader;
import net.mgsx.gltf.scene3d.attributes.PBRColorAttribute;
import net.mgsx.gltf.scene3d.attributes.PBRTextureAttribute;
import net.mgsx.gltf.scene3d.scene.SceneAsset;
import us.ihmc.log.LogTools;
import us.ihmc.rdx.tools.LibGDXTools;
import us.ihmc.rdx.tools.assimp.RDXAssimpModelLoader;
import us.ihmc.tools.io.resources.ResourceTools;

public class RDXModelLoader {
    private static final RDXModelLoader modelLoader = new RDXModelLoader();
    private final HashMap<String, Object> modelLoadingSynchronizers = new HashMap();
    private final HashMap<String, Model> loadedModels = new HashMap();
    private final TreeSet<String> printedWarnings = new TreeSet();

    private RDXModelLoader() {
    }

    public static Model load(String modelFileName) {
        return modelLoader.loadOrGetModel(modelFileName);
    }

    public static Model loadForce(String modelFileName) {
        return modelLoader.loadModelInternal(modelFileName);
    }

    public static void destroy() {
        modelLoader.destroyInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model loadOrGetModel(String modelFileName) {
        Model model;
        Object preventLoadingMoreThanOnceSynchronizer;
        String requestedModelFileName = modelFileName;
        modelFileName = ResourceTools.sanitizeResourcePath((String)modelFileName);
        Object object = preventLoadingMoreThanOnceSynchronizer = this.modelLoadingSynchronizers.computeIfAbsent(modelFileName, key -> new Object());
        synchronized (object) {
            model = this.loadedModels.get(modelFileName);
            if (model != null) {
                boolean shouldPrintWarnings = !this.printedWarnings.contains(requestedModelFileName);
                long numberOfVertices = LibGDXTools.countVertices(model);
                LogTools.debug((String)"Loaded {} ({} vertices)", (Object)modelFileName, (Object)numberOfVertices);
                if (shouldPrintWarnings && numberOfVertices > 15000L) {
                    LogTools.warn((String)"{} has {} vertices, which is a lot! This will begin to affect frame rate.", (Object)modelFileName, (Object)numberOfVertices);
                }
                this.printedWarnings.add(requestedModelFileName);
                return model;
            }
            model = this.loadModelInternal(requestedModelFileName);
            RDXModelLoader.ensureModelIsPBRShaderCompatible(model);
            this.loadedModels.put(modelFileName, model);
        }
        return model;
    }

    private Model loadModelInternal(String modelFileName) {
        LogTools.debug((String)"Loading {}", (Object)modelFileName);
        String requestedModelFileName = modelFileName;
        boolean shouldPrintWarnings = !this.printedWarnings.contains(requestedModelFileName);
        Model model = null;
        try {
            modelFileName = this.useABetterFormatIfAvailable(modelFileName);
            if (modelFileName.endsWith(".glb")) {
                fileHandle = Gdx.files.internal(modelFileName);
                SceneAsset sceneAsset = new GLBLoader().load(fileHandle, true);
                model = sceneAsset.scene.model;
            } else if (modelFileName.endsWith(".gltf")) {
                fileHandle = Gdx.files.internal(modelFileName);
                SceneAsset sceneAsset = new GLTFLoader().load(fileHandle, true);
                model = sceneAsset.scene.model;
            } else if (modelFileName.endsWith(".g3dj")) {
                fileHandle = Gdx.files.internal(modelFileName);
                model = new G3dModelLoader((BaseJsonReader)new JsonReader()).loadModel(fileHandle);
            } else if (modelFileName.endsWith(".g3db")) {
                fileHandle = Gdx.files.internal(modelFileName);
                model = new G3dModelLoader((BaseJsonReader)new UBJsonReader()).loadModel(fileHandle);
            } else {
                if (shouldPrintWarnings) {
                    LogTools.warn((String)"Using Assimp to load {}. It is recommended to convert to glTF binary (*.glb) for better rendering and more reliable and faster loading.", (Object)modelFileName);
                }
                model = new RDXAssimpModelLoader(modelFileName).load();
            }
            long numberOfVertices = LibGDXTools.countVertices(model);
            LogTools.debug((String)"Loaded {} ({} vertices)", (Object)modelFileName, (Object)numberOfVertices);
            if (shouldPrintWarnings && numberOfVertices > 15000L) {
                LogTools.warn((String)"{} has {} vertices, which is a lot! This will begin to affect frame rate.", (Object)modelFileName, (Object)numberOfVertices);
            }
        }
        catch (SerializationException | NullPointerException e) {
            LogTools.error((String)"Failed to load {}", (Object)modelFileName);
            e.printStackTrace();
        }
        this.printedWarnings.add(requestedModelFileName);
        return model;
    }

    public static void ensureModelIsPBRShaderCompatible(Model model) {
        for (Material material : model.materials) {
            boolean diffuseTextureNeedsReplacement;
            ColorAttribute diffuseColor = (ColorAttribute)material.get(ColorAttribute.class, ColorAttribute.Diffuse);
            TextureAttribute diffuseTexture = (TextureAttribute)material.get(TextureAttribute.class, TextureAttribute.Diffuse);
            boolean diffuseColorNeedsReplacement = diffuseColor != null && !(diffuseColor instanceof PBRColorAttribute);
            boolean bl = diffuseTextureNeedsReplacement = diffuseTexture != null && !(diffuseTexture instanceof PBRTextureAttribute);
            if (!diffuseColorNeedsReplacement && !diffuseTextureNeedsReplacement) continue;
            material.clear();
            if (diffuseTextureNeedsReplacement) {
                material.set((Attribute)PBRTextureAttribute.createBaseColorTexture((Texture)((Texture)diffuseTexture.textureDescription.texture)));
            }
            if (!diffuseColorNeedsReplacement) continue;
            material.set((Attribute)PBRColorAttribute.createBaseColorFactor((Color)diffuseColor.color));
        }
    }

    private String useABetterFormatIfAvailable(String modelFileName) {
        String modelFileNameWithoutExtension;
        FileHandle potentialFileHandle;
        boolean foundOne = false;
        if (!foundOne && !((String)modelFileName).endsWith(".glb") && (potentialFileHandle = Gdx.files.internal((modelFileNameWithoutExtension = ((String)modelFileName).substring(0, ((String)modelFileName).lastIndexOf("."))) + ".glb")).exists()) {
            LogTools.debug((String)"Found GLB file as an alternative for {}", (Object)modelFileName);
            modelFileName = modelFileNameWithoutExtension + ".glb";
            foundOne = true;
        }
        if (!foundOne && !((String)modelFileName).endsWith(".gltf") && (potentialFileHandle = Gdx.files.internal((modelFileNameWithoutExtension = ((String)modelFileName).substring(0, ((String)modelFileName).lastIndexOf("."))) + ".gltf")).exists()) {
            LogTools.debug((String)"Found GLTF file as an alternative for {}", (Object)modelFileName);
            modelFileName = modelFileNameWithoutExtension + ".gltf";
            foundOne = true;
        }
        if (!foundOne && !((String)modelFileName).endsWith(".g3db") && (potentialFileHandle = Gdx.files.internal((modelFileNameWithoutExtension = ((String)modelFileName).substring(0, ((String)modelFileName).lastIndexOf("."))) + ".g3db")).exists()) {
            LogTools.debug((String)"Found G3DB file as an alternative for {}", (Object)modelFileName);
            modelFileName = modelFileNameWithoutExtension + ".g3db";
            foundOne = true;
        }
        if (!foundOne && !((String)modelFileName).endsWith(".g3dj") && (potentialFileHandle = Gdx.files.internal((modelFileNameWithoutExtension = ((String)modelFileName).substring(0, ((String)modelFileName).lastIndexOf("."))) + ".g3dj")).exists()) {
            LogTools.debug((String)"Found G3DJ file as an alternative for {}", (Object)modelFileName);
            modelFileName = modelFileNameWithoutExtension + ".g3dj";
        }
        return modelFileName;
    }

    private void destroyInternal() {
        for (Model loadedModel : this.loadedModels.values()) {
            loadedModel.dispose();
        }
        this.loadedModels.clear();
    }
}

