/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.tools;

import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import us.ihmc.rdx.tools.LibGDXModelCopier;
import us.ihmc.rdx.tools.RDXModelInstance;
import us.ihmc.rdx.tools.RDXModelLoader;

public class RDXModelInstanceScaler {
    private final Model model;
    private RDXModelInstance modelInstance;

    public RDXModelInstanceScaler(String modelFileName) {
        this(RDXModelLoader.load(modelFileName));
    }

    public RDXModelInstanceScaler(Model model) {
        this.model = LibGDXModelCopier.deepCopy(model);
        this.modelInstance = new RDXModelInstance(model);
    }

    private void scaleInternal(Model model, double scale) {
        for (int i = 0; i < model.nodes.size; ++i) {
            ((Node)model.nodes.get((int)i)).scale.set((float)scale, (float)scale, (float)scale);
        }
    }

    public void scale(double scale) {
        this.scaleInternal(this.model, scale);
        this.modelInstance = new RDXModelInstance(this.model);
    }

    public Model getScaledDeepCopy(double scale) {
        Model copiedModel = LibGDXModelCopier.deepCopy(this.model);
        this.scaleInternal(copiedModel, scale);
        return copiedModel;
    }

    public Matrix4 getPoseTransform() {
        return this.modelInstance.transform;
    }

    public RDXModelInstance getModelInstance() {
        return this.modelInstance;
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        this.modelInstance.getRenderables(renderables, pool);
    }
}

