/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.tools;

import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.glutils.PixmapTextureData;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgcodecs;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import us.ihmc.tools.io.resources.ResourceTools;

public class RDXIconTexture {
    private final Texture texture;

    public RDXIconTexture(Path imagePath) {
        Mat readImage = opencv_imgcodecs.imread((String)imagePath.toString());
        this.texture = this.initialize(readImage);
    }

    public RDXIconTexture(String iconResourceAbsolutePath) {
        if (!((String)iconResourceAbsolutePath).startsWith("/")) {
            iconResourceAbsolutePath = "/" + (String)iconResourceAbsolutePath;
        }
        byte[] bytes = ResourceTools.readResourceToByteArray((String)iconResourceAbsolutePath);
        ByteBuffer directByteBuffer = ByteBuffer.allocateDirect(bytes.length);
        directByteBuffer.order(ByteOrder.nativeOrder());
        directByteBuffer.put(bytes);
        directByteBuffer.rewind();
        BytePointer bytePointer = new BytePointer(directByteBuffer);
        Mat encodedDataMat = new Mat(bytes.length, 1, opencv_core.CV_8UC1, (Pointer)bytePointer);
        Mat readImage = opencv_imgcodecs.imdecode((Mat)encodedDataMat, (int)-1);
        this.texture = this.initialize(readImage);
    }

    private Texture initialize(Mat readImage) {
        Pixmap pixmap = new Pixmap(readImage.cols(), readImage.rows(), Pixmap.Format.RGBA8888);
        BytePointer rgba8888BytePointer = new BytePointer(pixmap.getPixels());
        Mat rgba8Mat = new Mat(readImage.rows(), readImage.cols(), opencv_core.CV_8UC4, (Pointer)rgba8888BytePointer);
        opencv_imgproc.cvtColor((Mat)readImage, (Mat)rgba8Mat, (int)2);
        Texture texture = new Texture((TextureData)new PixmapTextureData(pixmap, null, false, false));
        return texture;
    }

    public Texture getTexture() {
        return this.texture;
    }
}

