/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.tools;

import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.model.Animation;
import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.graphics.g3d.model.NodeAnimation;
import com.badlogic.gdx.graphics.g3d.model.NodeKeyframe;
import com.badlogic.gdx.graphics.g3d.model.NodePart;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ArrayMap;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.ObjectMap;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class LibGDXModelCopier {
    public static Model deepCopy(Model model) {
        Model modelCopy = new Model();
        ObjectMap materialMap = new ObjectMap();
        ObjectMap meshMap = new ObjectMap();
        ObjectMap meshPartMap = new ObjectMap();
        ObjectMap nodeMap = new ObjectMap();
        for (Mesh originalMesh : model.meshes) {
            Mesh copiedMesh = LibGDXModelCopier.copyMesh(originalMesh);
            modelCopy.meshes.add((Object)copiedMesh);
            modelCopy.manageDisposable((Disposable)copiedMesh);
            meshMap.put((Object)originalMesh, (Object)copiedMesh);
        }
        for (Material originalMaterial : model.materials) {
            Material copiedMaterial = LibGDXModelCopier.copyMaterial(originalMaterial);
            modelCopy.materials.add((Object)copiedMaterial);
            materialMap.put((Object)originalMaterial, (Object)copiedMaterial);
        }
        for (MeshPart originalMeshPart : model.meshParts) {
            MeshPart copiedMeshPart = LibGDXModelCopier.copyMeshPart(originalMeshPart, (ObjectMap<Mesh, Mesh>)meshMap);
            modelCopy.meshParts.add((Object)copiedMeshPart);
            meshPartMap.put((Object)originalMeshPart, (Object)copiedMeshPart);
        }
        for (Node originalNode : model.nodes) {
            Node copiedNode = LibGDXModelCopier.copyNode(originalNode, (ObjectMap<Material, Material>)materialMap, (ObjectMap<MeshPart, MeshPart>)meshPartMap, (ObjectMap<Node, Node>)nodeMap);
            modelCopy.nodes.add((Object)copiedNode);
        }
        for (Animation originalAnimation : model.animations) {
            Animation copiedAnimation = LibGDXModelCopier.copyAnimation(originalAnimation, (ObjectMap<Node, Node>)nodeMap);
            modelCopy.animations.add((Object)copiedAnimation);
        }
        modelCopy.calculateTransforms();
        return modelCopy;
    }

    private static Mesh copyMesh(Mesh originalMesh) {
        VertexAttributes attributes = originalMesh.getVertexAttributes();
        int numVertices = originalMesh.getNumVertices();
        int numIndices = originalMesh.getNumIndices();
        Mesh copiedMesh = new Mesh(true, numVertices, numIndices, attributes);
        FloatBuffer originalVertices = originalMesh.getVerticesBuffer(false);
        FloatBuffer copiedVertices = copiedMesh.getVerticesBuffer(true);
        originalVertices.position(0);
        copiedVertices.clear();
        copiedVertices.put(originalVertices);
        originalVertices.position(0);
        copiedVertices.position(0);
        if (numIndices > 0) {
            ShortBuffer originalIndices = originalMesh.getIndicesBuffer(false);
            ShortBuffer copiedIndices = copiedMesh.getIndicesBuffer(true);
            originalIndices.position(0);
            copiedIndices.clear();
            copiedIndices.put(originalIndices);
            originalIndices.position(0);
            copiedIndices.position(0);
        }
        return copiedMesh;
    }

    private static Material copyMaterial(Material originalMaterial) {
        Material copiedMaterial = new Material();
        copiedMaterial.id = originalMaterial.id;
        for (Attribute attribute : originalMaterial) {
            copiedMaterial.set(attribute.copy());
        }
        return copiedMaterial;
    }

    private static MeshPart copyMeshPart(MeshPart originalMeshPart, ObjectMap<Mesh, Mesh> meshMap) {
        MeshPart copiedMeshPart = new MeshPart();
        copiedMeshPart.id = originalMeshPart.id;
        copiedMeshPart.primitiveType = originalMeshPart.primitiveType;
        copiedMeshPart.offset = originalMeshPart.offset;
        copiedMeshPart.size = originalMeshPart.size;
        copiedMeshPart.mesh = (Mesh)meshMap.get((Object)originalMeshPart.mesh);
        copiedMeshPart.update();
        return copiedMeshPart;
    }

    private static Node copyNode(Node originalNode, ObjectMap<Material, Material> materialMap, ObjectMap<MeshPart, MeshPart> meshPartMap, ObjectMap<Node, Node> nodeMap) {
        Node copiedNode = new Node();
        copiedNode.id = originalNode.id;
        copiedNode.translation.set(originalNode.translation);
        copiedNode.rotation.set(originalNode.rotation);
        copiedNode.scale.set(originalNode.scale);
        for (NodePart originalNodePart : originalNode.parts) {
            NodePart copiedNodePart = LibGDXModelCopier.copyNodePart(originalNodePart, materialMap, meshPartMap, nodeMap);
            copiedNode.parts.add((Object)copiedNodePart);
        }
        nodeMap.put((Object)originalNode, (Object)copiedNode);
        for (Node originalChild : originalNode.getChildren()) {
            Node copiedChild = (Node)nodeMap.get((Object)originalChild);
            if (copiedChild == null) {
                copiedChild = LibGDXModelCopier.copyNode(originalChild, materialMap, meshPartMap, nodeMap);
            }
            copiedNode.addChild(copiedChild);
        }
        return copiedNode;
    }

    private static NodePart copyNodePart(NodePart originalNodePart, ObjectMap<Material, Material> materialMap, ObjectMap<MeshPart, MeshPart> meshPartMap, ObjectMap<Node, Node> nodeMap) {
        NodePart copiedNodePart = new NodePart();
        copiedNodePart.meshPart = (MeshPart)meshPartMap.get((Object)originalNodePart.meshPart);
        copiedNodePart.material = (Material)materialMap.get((Object)originalNodePart.material);
        if (originalNodePart.invBoneBindTransforms != null) {
            copiedNodePart.invBoneBindTransforms = new ArrayMap(Node.class, Matrix4.class);
            for (ObjectMap.Entry entry : originalNodePart.invBoneBindTransforms.entries()) {
                Node copiedBoneNode = (Node)nodeMap.get((Object)((Node)entry.key));
                if (copiedBoneNode == null) continue;
                copiedNodePart.invBoneBindTransforms.put((Object)copiedBoneNode, (Object)new Matrix4((Matrix4)entry.value));
            }
        }
        return copiedNodePart;
    }

    private static Animation copyAnimation(Animation originalAnimation, ObjectMap<Node, Node> nodeMap) {
        Animation copiedAnimation = new Animation();
        copiedAnimation.id = originalAnimation.id;
        copiedAnimation.duration = originalAnimation.duration;
        for (NodeAnimation originalNodeAnim : originalAnimation.nodeAnimations) {
            Node copiedNode = (Node)nodeMap.get((Object)originalNodeAnim.node);
            if (copiedNode == null) continue;
            NodeAnimation copiedNodeAnim = LibGDXModelCopier.copyNodeAnimation(originalNodeAnim, copiedNode);
            copiedAnimation.nodeAnimations.add((Object)copiedNodeAnim);
        }
        return copiedAnimation;
    }

    private static NodeAnimation copyNodeAnimation(NodeAnimation originalNodeAnim, Node copiedNode) {
        NodeKeyframe copiedKeyframe;
        NodeAnimation copiedNodeAnim = new NodeAnimation();
        copiedNodeAnim.node = copiedNode;
        if (originalNodeAnim.translation != null) {
            copiedNodeAnim.translation = new Array();
            for (NodeKeyframe originalKeyframe : originalNodeAnim.translation) {
                copiedKeyframe = new NodeKeyframe(originalKeyframe.keytime, (Object)new Vector3((Vector3)originalKeyframe.value));
                copiedNodeAnim.translation.add((Object)copiedKeyframe);
            }
        }
        if (originalNodeAnim.rotation != null) {
            copiedNodeAnim.rotation = new Array();
            for (NodeKeyframe originalKeyframe : originalNodeAnim.rotation) {
                copiedKeyframe = new NodeKeyframe(originalKeyframe.keytime, (Object)new Quaternion((Quaternion)originalKeyframe.value));
                copiedNodeAnim.rotation.add((Object)copiedKeyframe);
            }
        }
        if (originalNodeAnim.scaling != null) {
            copiedNodeAnim.scaling = new Array();
            for (NodeKeyframe originalKeyframe : originalNodeAnim.scaling) {
                copiedKeyframe = new NodeKeyframe(originalKeyframe.keytime, (Object)new Vector3((Vector3)originalKeyframe.value));
                copiedNodeAnim.scaling.add((Object)copiedKeyframe);
            }
        }
        return copiedNodeAnim;
    }
}

