/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.shader;

import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.Shader;
import com.badlogic.gdx.graphics.g3d.shaders.BaseShader;
import com.badlogic.gdx.graphics.g3d.utils.ShaderProvider;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import org.apache.commons.lang3.tuple.Pair;
import us.ihmc.log.LogTools;
import us.ihmc.rdx.shader.RDXDefaultBaseShader;
import us.ihmc.rdx.shader.RDXUniform;
import us.ihmc.rdx.tools.LibGDXTools;

public class RDXShader
implements ShaderProvider {
    private final Class<?> clazz;
    private BaseShader baseShader;
    private ShaderProgram shaderProgram;

    public RDXShader(Class<?> clazz) {
        this.clazz = clazz;
    }

    public void create() {
        this.create(null, null);
    }

    public void create(String[] vertexFlags, String[] fragmentFlags) {
        String path = this.clazz.getName().replace(".", "/") + ".glsl";
        Pair<String, String> shaderStrings = LibGDXTools.loadCombinedShader(path);
        String vertexShader = (String)shaderStrings.getLeft();
        String fragmentShader = (String)shaderStrings.getRight();
        String vertexShaderWithFlags = RDXShader.addFlags(vertexShader, vertexFlags);
        String fragmentShaderWithFlags = RDXShader.addFlags(fragmentShader, fragmentFlags);
        this.shaderProgram = new ShaderProgram(vertexShaderWithFlags, fragmentShaderWithFlags);
        LogTools.info((String)"OpenGL shader compilation output for {}:\n{}", (Object)path, (Object)this.shaderProgram.getLog());
        this.baseShader = new RDXDefaultBaseShader(){

            public void render(Renderable renderable) {
                this.context.setBlending(false, 770, 771);
                this.context.setCullFace(1029);
                this.context.setDepthTest(515, 0.0f, 50.0f);
                this.context.setDepthMask(true);
                super.render(renderable);
            }
        };
    }

    public void init(Renderable renderable) {
        this.baseShader.init(this.shaderProgram, renderable);
    }

    public void registerUniform(RDXUniform uniform) {
        this.baseShader.register(uniform.getUniform(), uniform.getSetter());
    }

    public BaseShader getBaseShader() {
        return this.baseShader;
    }

    public Shader getShader(Renderable renderable) {
        return this.baseShader;
    }

    public void dispose() {
        this.baseShader.dispose();
    }

    private static String addFlags(String shader, String[] flags) {
        if (flags == null || flags.length == 0) {
            return shader;
        }
        String[] versionAndCode = shader.trim().split("\n", 2);
        StringBuilder shaderWithFlags = new StringBuilder(versionAndCode[0] + "\n");
        for (String flag : flags) {
            shaderWithFlags.append("#define " + flag + "\n");
        }
        shaderWithFlags.append(versionAndCode[1]);
        return shaderWithFlags.toString();
    }
}

