/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.sceneManager;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Environment;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.DirectionalLightsAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.PointLightsAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.SpotLightsAttribute;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.environment.PointLight;
import com.badlogic.gdx.graphics.g3d.shaders.DepthShader;
import com.badlogic.gdx.graphics.g3d.utils.DepthShaderProvider;
import com.badlogic.gdx.graphics.g3d.utils.RenderableSorter;
import com.badlogic.gdx.graphics.g3d.utils.ShaderProvider;
import com.badlogic.gdx.math.Vector3;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.mgsx.gltf.scene3d.lights.DirectionalLightEx;
import net.mgsx.gltf.scene3d.lights.PointLightEx;
import net.mgsx.gltf.scene3d.scene.SceneRenderableSorter;
import net.mgsx.gltf.scene3d.shaders.PBRShaderConfig;
import net.mgsx.gltf.scene3d.shaders.PBRShaderProvider;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.rdx.lighting.RDXDirectionalLight;
import us.ihmc.rdx.lighting.RDXPointLight;
import us.ihmc.rdx.sceneManager.RDXRenderableAdapter;
import us.ihmc.rdx.sceneManager.RDXRenderableProvider;
import us.ihmc.rdx.sceneManager.RDXSceneLevel;
import us.ihmc.rdx.tools.RDXModelBuilder;
import us.ihmc.rdx.vr.RDXVREye;
import us.ihmc.robotics.robotSide.RobotSide;

public class RDX3DScene {
    public static final float DEFAULT_AMBIENT_LIGHT_INTENSITY = 0.0f;
    public static final float DEFAULT_POINT_LIGHT_INTENSITY = 660.0f;
    public static final float DEFAULT_DIRECTIONAL_LIGHT_INTENSITY = 2.0f;
    private final HashSet<ModelInstance> modelInstances = new HashSet();
    private final Set<RDXRenderableAdapter> renderables = new HashSet<RDXRenderableAdapter>();
    private final Map<Object, RDXRenderableAdapter> renderableOwnerKeyMap = new HashMap<Object, RDXRenderableAdapter>();
    private TreeSet<RDXSceneLevel> sceneLevelsToRender;
    private ColorAttribute ambientLight;
    private float pointLightIntensity = 660.0f;
    private float directionalLightIntensity = 2.0f;
    private ModelBatch colorModelBatch;
    private ModelBatch depthModelBatch;
    private Environment environment;
    private final PointLightsAttribute pointLights = new PointLightsAttribute();
    private final DirectionalLightsAttribute directionalLights = new DirectionalLightsAttribute();
    private final SpotLightsAttribute spotLights = new SpotLightsAttribute();

    public void create() {
        this.create(RDXSceneLevel.MODEL, RDXSceneLevel.VIRTUAL);
    }

    public void create(RDXSceneLevel ... sceneLevelsToRender) {
        this.sceneLevelsToRender = new TreeSet();
        Collections.addAll(this.sceneLevelsToRender, sceneLevelsToRender);
        int maxBones = 0;
        PBRShaderConfig pbrColorShaderConfig = new PBRShaderConfig();
        pbrColorShaderConfig.numBones = maxBones;
        pbrColorShaderConfig.numPointLights = 10;
        DepthShader.Config depthShaderConfig = new DepthShader.Config();
        depthShaderConfig.numBones = maxBones;
        PBRShaderProvider pbrColorShader = PBRShaderProvider.createDefault((PBRShaderConfig)pbrColorShaderConfig);
        DepthShaderProvider pbrDepthShader = PBRShaderProvider.createDefaultDepth((DepthShader.Config)depthShaderConfig);
        SceneRenderableSorter sceneRenderableSorter = new SceneRenderableSorter();
        this.colorModelBatch = new ModelBatch((ShaderProvider)pbrColorShader, (RenderableSorter)sceneRenderableSorter);
        this.depthModelBatch = new ModelBatch((ShaderProvider)pbrDepthShader);
        this.environment = new Environment();
        this.ambientLight = ColorAttribute.createAmbientLight((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.environment.set((Attribute)this.ambientLight);
        this.environment.set((Attribute)this.pointLights);
        this.environment.set((Attribute)this.directionalLights);
        this.environment.set((Attribute)this.spotLights);
    }

    public void preRender(Camera camera) {
        this.colorModelBatch.begin(camera);
    }

    public void preRenderDepth(Camera camera) {
        this.depthModelBatch.begin(camera);
    }

    public void render() {
        this.renderInternal(this.colorModelBatch, this.sceneLevelsToRender);
    }

    public void render(RDXSceneLevel exclusiveSceneLevel) {
        this.renderInternal(this.colorModelBatch, exclusiveSceneLevel.SINGLETON_SET);
    }

    public void render(Set<RDXSceneLevel> sceneLevels) {
        this.renderInternal(this.colorModelBatch, sceneLevels);
    }

    public void renderExternalBatch(ModelBatch batch, Set<RDXSceneLevel> sceneLevel) {
        this.renderInternal(batch, sceneLevel);
    }

    public void renderDepth(Set<RDXSceneLevel> sceneLevel) {
        this.renderInternal(this.depthModelBatch, sceneLevel);
    }

    public void renderToCamera(Camera camera) {
        RDXVREye eye;
        if (camera instanceof RDXVREye) {
            eye = (RDXVREye)camera;
            if (eye.getSide() == RobotSide.LEFT) {
                this.sceneLevelsToRender.add(RDXSceneLevel.VR_EYE_LEFT);
            }
            if (eye.getSide() == RobotSide.RIGHT) {
                this.sceneLevelsToRender.add(RDXSceneLevel.VR_EYE_RIGHT);
            }
        }
        this.colorModelBatch.begin(camera);
        this.renderInternal(this.colorModelBatch, this.sceneLevelsToRender);
        if (camera instanceof RDXVREye) {
            eye = (RDXVREye)camera;
            if (eye.getSide() == RobotSide.LEFT) {
                this.sceneLevelsToRender.remove((Object)RDXSceneLevel.VR_EYE_LEFT);
            }
            if (eye.getSide() == RobotSide.RIGHT) {
                this.sceneLevelsToRender.remove((Object)RDXSceneLevel.VR_EYE_RIGHT);
            }
        }
        this.postRender();
    }

    private void renderInternal(ModelBatch modelBatch, Set<RDXSceneLevel> sceneLevelsToRender) {
        for (RDXRenderableAdapter renderable : this.renderables) {
            renderable.setSceneLevelsToRender(sceneLevelsToRender);
            modelBatch.render((RenderableProvider)renderable, this.environment);
        }
    }

    public void postRender() {
        this.colorModelBatch.end();
    }

    public void postRenderDepth() {
        this.depthModelBatch.end();
    }

    public void dispose() {
        for (ModelInstance modelInstance : this.modelInstances) {
            ExceptionTools.handle(() -> ((Model)modelInstance.model).dispose(), (ExceptionHandler)DefaultExceptionHandler.PRINT_MESSAGE);
        }
        this.colorModelBatch.dispose();
    }

    public RDXRenderableAdapter addModelInstance(ModelInstance modelInstance) {
        return this.addModelInstance(modelInstance, RDXSceneLevel.MODEL);
    }

    public RDXRenderableAdapter addModelInstance(ModelInstance modelInstance, RDXSceneLevel sceneLevel) {
        this.modelInstances.add(modelInstance);
        return this.addRenderableProvider((RenderableProvider)modelInstance, sceneLevel);
    }

    public RDXRenderableAdapter addCoordinateFrame(double size) {
        return this.addModelInstance(RDXModelBuilder.createCoordinateFrameInstance(size), RDXSceneLevel.VIRTUAL);
    }

    public RDXRenderableAdapter addRenderableProvider(RenderableProvider renderableProvider) {
        return this.addRenderableProvider(renderableProvider, RDXSceneLevel.MODEL);
    }

    public RDXRenderableAdapter addRenderableProvider(RenderableProvider renderableProvider, RDXSceneLevel sceneLevel) {
        RDXRenderableAdapter renderableAdapter = new RDXRenderableAdapter(renderableProvider, sceneLevel);
        this.addRenderableInternal(renderableAdapter);
        return renderableAdapter;
    }

    public RDXRenderableAdapter addRenderableProvider(RDXRenderableProvider renderableProvider) {
        RDXRenderableAdapter renderableAdapter = new RDXRenderableAdapter(renderableProvider);
        this.addRenderableInternal(renderableAdapter);
        return renderableAdapter;
    }

    public void addRenderableProvider(Object ownerKey, RDXRenderableProvider renderableProvider) {
        RDXRenderableAdapter renderableAdapter = new RDXRenderableAdapter(renderableProvider);
        this.renderableOwnerKeyMap.put(ownerKey, renderableAdapter);
        this.addRenderableInternal(renderableAdapter);
    }

    public void addRenderableProvider(Object ownerKey, RenderableProvider renderableProvider) {
        this.addRenderableProvider(ownerKey, renderableProvider, RDXSceneLevel.MODEL);
    }

    public void addRenderableProvider(Object ownerKey, RenderableProvider renderableProvider, RDXSceneLevel sceneLevel) {
        RDXRenderableAdapter renderableAdapter = new RDXRenderableAdapter(renderableProvider, sceneLevel);
        this.renderableOwnerKeyMap.put(ownerKey, renderableAdapter);
        this.addRenderableInternal(renderableAdapter);
    }

    public void addRenderableAdapter(RDXRenderableAdapter renderableAdapter) {
        this.addRenderableInternal(renderableAdapter);
    }

    private void addRenderableInternal(RDXRenderableAdapter renderableAdapter) {
        this.renderables.add(renderableAdapter);
    }

    public void removeRenderable(Object ownerKey) {
        this.renderables.remove(this.renderableOwnerKeyMap.remove(ownerKey));
    }

    public void removeRenderableAdapter(RDXRenderableAdapter renderableAdapter) {
        this.renderables.remove(renderableAdapter);
    }

    public void addDefaultLighting() {
        this.environment.add((DirectionalLight)new DirectionalLightEx().set(Color.WHITE, new Vector3(-1.0f, -4.0f, -2.0f), this.directionalLightIntensity));
        this.environment.add((DirectionalLight)new DirectionalLightEx().set(Color.WHITE, new Vector3(0.0f, 0.0f, 1.0f), this.directionalLightIntensity));
        Float range = null;
        this.environment.add((PointLight)new PointLightEx().set(Color.WHITE, new Vector3(10.0f, 10.0f, 10.0f), this.pointLightIntensity, range));
        this.environment.add((PointLight)new PointLightEx().set(Color.WHITE, new Vector3(10.0f, -10.0f, 10.0f), this.pointLightIntensity, range));
        this.environment.add((PointLight)new PointLightEx().set(Color.WHITE, new Vector3(-10.0f, 10.0f, 10.0f), this.pointLightIntensity, range));
        this.environment.add((PointLight)new PointLightEx().set(Color.WHITE, new Vector3(-10.0f, -10.0f, 10.0f), this.pointLightIntensity, range));
    }

    public void clearLights() {
        this.pointLights.lights.clear();
        this.directionalLights.lights.clear();
    }

    public void addPointLight(RDXPointLight pointLight) {
        this.environment.add((PointLight)pointLight.getPointLightEx());
    }

    public void addDirectionalLight(RDXDirectionalLight directionalLight) {
        this.environment.add((DirectionalLight)directionalLight.getDirectionalLightEx());
    }

    public void removePointLight(RDXPointLight pointLight) {
        this.pointLights.lights.removeValue((Object)pointLight.getPointLightEx(), true);
    }

    public void removeDirectionalLight(RDXDirectionalLight directionalLight) {
        this.directionalLights.lights.removeValue((Object)directionalLight.getDirectionalLightEx(), true);
    }

    public void setAmbientLightIntensity(float ambientLightIntensity) {
        this.ambientLight.color.r = ambientLightIntensity;
        this.ambientLight.color.g = ambientLightIntensity;
        this.ambientLight.color.b = ambientLightIntensity;
    }

    public float getAmbientLightIntensity() {
        return this.ambientLight.color.r;
    }

    public float getPointLightIntensity() {
        return this.pointLightIntensity;
    }

    public void setPointLightIntensity(float pointLightIntensity) {
        this.pointLightIntensity = pointLightIntensity;
        for (int i = 0; i < this.pointLights.lights.size; ++i) {
            ((PointLight)this.pointLights.lights.get((int)i)).intensity = pointLightIntensity;
        }
    }

    public float getDirectionalLightIntensity() {
        return this.directionalLightIntensity;
    }

    public void setDirectionalLightIntensity(float directionalLightIntensity) {
        this.directionalLightIntensity = directionalLightIntensity;
        for (int i = 0; i < this.directionalLights.lights.size; ++i) {
            Object object = this.directionalLights.lights.get(i);
            if (!(object instanceof DirectionalLightEx)) continue;
            DirectionalLightEx directionalLightEx = (DirectionalLightEx)object;
            directionalLightEx.intensity = directionalLightIntensity;
        }
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public TreeSet<RDXSceneLevel> getSceneLevelsToRender() {
        return this.sceneLevelsToRender;
    }
}

