/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.mesh;

import com.badlogic.gdx.graphics.Color;
import java.util.List;
import java.util.function.Supplier;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.MeshDataBuilder;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.rdx.mesh.RDXMutableMeshModel;

public class RDXMutableMultiLineModel
extends RDXMutableMeshModel {
    public static final double EPSILON = 1.0E-4;
    private final RecyclingArrayList<Point3D> points = new RecyclingArrayList(Point3D::new);
    private double lineWidth = Double.NaN;
    private Supplier<MeshDataHolder> meshDataSupplier;
    private final MeshDataBuilder meshDataBuilder = new MeshDataBuilder();

    public void update(List<? extends Tuple3DReadOnly> pointsUpdateReadOnly, double lineWidthUpdate, Color color) {
        if (this.meshDataSupplier == null) {
            this.meshDataSupplier = () -> {
                this.meshDataBuilder.clear();
                boolean close = false;
                this.meshDataBuilder.addMultiLine(this.points, this.lineWidth, close);
                return this.meshDataBuilder.generateMeshDataHolder();
            };
        }
        boolean outOfDate = false;
        outOfDate |= this.modelInstance == null != pointsUpdateReadOnly.isEmpty();
        outOfDate |= this.points.size() != pointsUpdateReadOnly.size();
        outOfDate |= !EuclidCoreTools.epsilonEquals((double)this.lineWidth, (double)lineWidthUpdate, (double)1.0E-4);
        if (!(outOfDate |= this.isColorOutOfDate(color))) {
            for (int i = 0; i < pointsUpdateReadOnly.size(); ++i) {
                outOfDate |= !((Point3D)this.points.get(i)).geometricallyEquals((EuclidGeometry)pointsUpdateReadOnly.get(i), 1.0E-4);
            }
        }
        if (outOfDate) {
            this.points.clear();
            for (Tuple3DReadOnly tuple3DReadOnly : pointsUpdateReadOnly) {
                ((Point3D)this.points.add()).set(tuple3DReadOnly);
            }
            this.lineWidth = lineWidthUpdate;
            this.updateMesh(this.meshDataSupplier.get());
        }
    }
}

